package com.zurrtum.create.client.infrastructure.model;

import com.google.common.base.Suppliers;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_10401;
import net.minecraft.class_10402;
import net.minecraft.class_10419;
import net.minecraft.class_10430;
import net.minecraft.class_10439;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_10526;
import net.minecraft.class_10809;
import net.minecraft.class_10819;
import net.minecraft.class_1086;
import net.minecraft.class_11566;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_638;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_811;
import net.minecraft.client.renderer.item.*;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3fc;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

import static com.zurrtum.create.Create.MOD_ID;

public class OversizedModel implements class_10439 {
    public static final class_2960 ID = class_2960.method_60655(MOD_ID, "model/oversized");
    private final List<class_10401> tints;
    private final List<class_777> quads;
    private final Supplier<Vector3fc[]> vector;
    private final class_10809 settings;
    private final class_238 box;
    private final boolean animated;
    private final Function<class_1799, class_1921> renderType;

    public OversizedModel(
        List<class_10401> tints,
        List<class_777> quads,
        class_10809 settings,
        Function<class_1799, class_1921> renderType,
        class_238 box
    ) {
        this.tints = tints;
        this.quads = quads;
        this.settings = settings;
        this.renderType = renderType;
        this.vector = Suppliers.memoize(() -> class_10430.method_67990(this.quads));
        this.box = box;
        boolean animated = false;

        for (class_777 bakedQuad : quads) {
            if (bakedQuad.comp_3724().method_45851().method_73020()) {
                animated = true;
                break;
            }
        }

        this.animated = animated;
    }

    @Override
    public void method_65584(
        class_10444 state,
        class_1799 stack,
        class_10442 resolver,
        class_811 displayContext,
        @Nullable class_638 world,
        @Nullable class_11566 heldItemContext,
        int seed
    ) {
        state.method_70946(this);
        class_10444.class_10446 layerRenderState = state.method_65601();
        if (stack.method_7958()) {
            layerRenderState.method_65615(class_10444.class_10445.field_55342);
            state.method_70947();
            state.method_70946(class_10444.class_10445.field_55342);
        }

        int i = tints.size();
        int[] is = layerRenderState.method_65613(i);

        for (int j = 0; j < i; j++) {
            int k = tints.get(j).method_65389(stack, world, heldItemContext == null ? null : heldItemContext.method_72393());
            is[j] = k;
            state.method_70946(k);
        }

        layerRenderState.method_67995(vector);
        layerRenderState.method_67992(renderType.apply(stack));
        settings.method_68000(layerRenderState, displayContext);
        layerRenderState.method_67997().addAll(quads);
        if (animated) {
            state.method_70947();
        }
        if (displayContext == class_811.field_4317) {
            state.method_72172(true);
            state.field_61031 = box;
        }
    }

    public record Unbaked(class_2960 model, List<class_10401> tints, List<Double> min, List<Double> max) implements class_10439.class_10441 {
        public static final MapCodec<com.zurrtum.create.client.infrastructure.model.OversizedModel.Unbaked> CODEC = RecordCodecBuilder.mapCodec(
            instance -> instance.group(
                class_2960.field_25139.fieldOf("model").forGetter(com.zurrtum.create.client.infrastructure.model.OversizedModel.Unbaked::model),
                class_10402.field_55234.listOf().optionalFieldOf("tints", List.of())
                    .forGetter(com.zurrtum.create.client.infrastructure.model.OversizedModel.Unbaked::tints),
                Codec.DOUBLE.listOf(3, 3).fieldOf("min").forGetter(com.zurrtum.create.client.infrastructure.model.OversizedModel.Unbaked::min),
                Codec.DOUBLE.listOf(3, 3).fieldOf("max").forGetter(com.zurrtum.create.client.infrastructure.model.OversizedModel.Unbaked::max)
            ).apply(instance, com.zurrtum.create.client.infrastructure.model.OversizedModel.Unbaked::new));

        @Override
        public void method_62326(class_10526.class_10103 resolver) {
            resolver.markDependency(this.model);
        }

        @Override
        public class_10439 method_65587(class_10439.class_10440 context) {
            class_7775 baker = context.comp_3390();
            class_10819 bakedSimpleModel = baker.method_45872(this.model);
            class_10419 modelTextures = bakedSimpleModel.method_68045();
            List<class_777> quads = bakedSimpleModel.method_68034(modelTextures, baker, class_1086.field_63619).method_68048();
            class_10809 modelSettings = class_10809.method_68001(baker, bakedSimpleModel, modelTextures);
            Function<class_1799, class_1921> renderTypeGetter = class_10430.method_76558(quads);
            return new OversizedModel(
                tints,
                quads,
                modelSettings,
                renderTypeGetter,
                new class_238(min.get(0), min.get(1), min.get(2), max.get(0), max.get(1), max.get(2))
            );
        }

        @Override
        public MapCodec<com.zurrtum.create.client.infrastructure.model.OversizedModel.Unbaked> method_65585() {
            return CODEC;
        }
    }
}
