package com.zurrtum.create.client.infrastructure.model;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.infrastructure.component.SandPaperItemComponent;
import net.minecraft.class_10419;
import net.minecraft.class_10430;
import net.minecraft.class_10439;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_10444.class_10446;
import net.minecraft.class_10515;
import net.minecraft.class_10809;
import net.minecraft.class_10819;
import net.minecraft.class_1086;
import net.minecraft.class_11566;
import net.minecraft.class_11659;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4722;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.client.renderer.item.*;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3fc;

import java.util.List;
import java.util.function.Consumer;

import static com.zurrtum.create.Create.MOD_ID;

public class SandPaperModel implements class_10439, class_10515<SandPaperModel.RenderData> {
    public static final class_2960 ID = class_2960.method_60655(MOD_ID, "model/sand_paper");

    private final class_1921 layer = class_4722.method_29382();
    private final List<class_777> quads;
    private final class_10809 settings;
    private final Supplier<Vector3fc[]> vector;

    public SandPaperModel(List<class_777> quads, class_10809 settings) {
        this.quads = quads;
        this.settings = settings;
        this.vector = Suppliers.memoize(() -> class_10430.method_67990(this.quads));
    }

    @Override
    public void method_65584(
        class_10444 state,
        class_1799 stack,
        class_10442 resolver,
        class_811 displayContext,
        @Nullable class_638 world,
        @Nullable class_11566 ctx,
        int seed
    ) {
        state.method_70946(this);
        state.method_70947();
        class_10444.class_10446 layerRenderState = state.method_65601();
        layerRenderState.method_67992(layer);
        layerRenderState.method_67995(vector);
        settings.method_68000(layerRenderState, displayContext);
        layerRenderState.method_67997().addAll(quads);

        RenderData data = new RenderData();
        data.state = layerRenderState;
        class_1657 entity;
        if (ctx instanceof class_1657 player) {
            data.itemInUseCount = player.method_6014();
            entity = player;
        } else {
            class_746 player = class_310.method_1551().field_1724;
            data.itemInUseCount = player.method_6014();
            entity = player;
        }

        SandPaperItemComponent component = stack.method_58694(AllDataComponents.SAND_PAPER_POLISHING);
        if (component != null) {
            int maxUseTime = stack.method_7935(entity);
            boolean jeiMode = stack.method_57826(AllDataComponents.SAND_PAPER_JEI);
            float partialTicks = AnimationTickHolder.getPartialTicks();
            float time = (float) (!jeiMode ? data.itemInUseCount : (-AnimationTickHolder.getTicks()) % maxUseTime) - partialTicks + 1.0F;
            data.reverseBobbing = time / (float) maxUseTime < 0.8F;
            if (data.reverseBobbing) {
                data.bobbing = -class_3532.method_15379(class_3532.method_15362(time / 4.0F * (float) Math.PI) * 0.1F);
            }

            class_1799 toPolish = component.item();
            data.item = new class_10444();
            data.item.field_55337 = displayContext;
            resolver.method_65596(data.item, toPolish, class_811.field_4317, world, ctx, seed);
        }

        layerRenderState.method_65617(this, data);
    }

    @Override
    public void submit(
        RenderData data,
        class_811 displayContext,
        class_4587 matrices,
        class_11659 queue,
        int light,
        int overlay,
        boolean glint,
        int i
    ) {
        assert data != null;
        class_10446 state = data.state;
        boolean leftHand = displayContext == class_811.field_4321;
        boolean firstPerson = leftHand || displayContext == class_811.field_4322;

        matrices.method_22903();
        if (firstPerson && data.itemInUseCount > 0) {
            int modifier = leftHand ? -1 : 1;
            matrices.method_46416(0.5F, 0.5F, 0.5F);
            matrices.method_46416(modifier * .5f, 0, -.25f);
            matrices.method_22907(class_7833.field_40718.rotationDegrees(modifier * 40));
            matrices.method_22907(class_7833.field_40714.rotationDegrees(modifier * 10));
            matrices.method_22907(class_7833.field_40716.rotationDegrees(modifier * 90));
            matrices.method_46416(-0.5F, -0.5F, -0.5F);
        }
        queue.method_73480(matrices, displayContext, light, overlay, 0, state.field_55349, state.field_56964, state.field_55347, state.field_55348);
        matrices.method_22909();

        if (data.item == null) {
            return;
        }

        matrices.method_22903();
        matrices.method_46416(0.5F, 0.5F, 0.5F);
        if (displayContext == class_811.field_4317) {
            matrices.method_46416(0.0F, .2f, 1.0F);
            matrices.method_22905(.75f, .75f, .75f);
        } else {
            int modifier = leftHand ? -1 : 1;
            matrices.method_22907(class_7833.field_40716.rotationDegrees(modifier * 40));
        }
        if (data.reverseBobbing) {
            if (displayContext == class_811.field_4317) {
                matrices.method_46416(data.bobbing, data.bobbing, 0.0F);
            } else {
                matrices.method_46416(0.0F, data.bobbing, 0.0F);
            }
        }
        data.item.method_65604(matrices, queue, light, overlay, 0);
        matrices.method_22909();
    }

    @Override
    public void method_72175(Consumer<Vector3fc> output) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RenderData method_65695(class_1799 stack) {
        throw new UnsupportedOperationException();
    }

    public static class RenderData {
        class_10446 state;
        class_10444 item;
        int itemInUseCount;
        boolean reverseBobbing;
        float bobbing;
    }

    public record Unbaked(class_2960 model) implements class_10439.class_10441 {
        public static final MapCodec<com.zurrtum.create.client.infrastructure.model.SandPaperModel.Unbaked> CODEC = RecordCodecBuilder.mapCodec(
            instance -> instance.group(class_2960.field_25139.fieldOf("model")
                    .forGetter(com.zurrtum.create.client.infrastructure.model.SandPaperModel.Unbaked::model))
                .apply(instance, com.zurrtum.create.client.infrastructure.model.SandPaperModel.Unbaked::new));

        @Override
        public MapCodec<com.zurrtum.create.client.infrastructure.model.SandPaperModel.Unbaked> method_65585() {
            return CODEC;
        }

        @Override
        public void method_62326(class_10103 resolver) {
            resolver.markDependency(model);
        }

        @Override
        public class_10439 method_65587(class_10439.class_10440 context) {
            class_7775 baker = context.comp_3390();
            class_10819 model = baker.method_45872(this.model);
            class_10419 textures = model.method_68045();
            List<class_777> quads = model.method_68034(textures, baker, class_1086.field_63619).method_68048();
            class_10809 settings = class_10809.method_68001(baker, model, textures);
            return new SandPaperModel(quads, settings);
        }
    }
}
