package com.zurrtum.create.client.infrastructure.particle;

import net.minecraft.class_2400;
import net.minecraft.class_4002;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;

public class BasicParticleFactory implements class_707<class_2400> {
    @FunctionalInterface
    public interface Factory {
        class_703 createParticle(
            class_2400 parameters,
            class_4002 spriteSet,
            class_638 world,
            double x,
            double y,
            double z,
            double velocityX,
            double velocityY,
            double velocityZ,
            class_5819 random
        );
    }

    private final Factory factory;
    private class_4002 spriteSet;

    private BasicParticleFactory(Factory factory, class_4002 spriteSet) {
        this.factory = factory;
        this.spriteSet = spriteSet;
    }

    public static class_707<class_2400> wifi(class_4002 spriteSet) {
        return new BasicParticleFactory(WiFiParticle::new, spriteSet);
    }

    public static class_707<class_2400> soul(class_4002 spriteSet) {
        return new BasicParticleFactory(SoulParticle::new, spriteSet);
    }

    public static class_707<class_2400> soulBase(class_4002 spriteSet) {
        return new BasicParticleFactory(SoulBaseParticle::new, spriteSet);
    }

    @Override
    public class_703 createParticle(
        class_2400 parameters,
        class_638 world,
        double x,
        double y,
        double z,
        double velocityX,
        double velocityY,
        double velocityZ,
        class_5819 random
    ) {
        return factory.createParticle(parameters, spriteSet, world, x, y, z, velocityX, velocityY, velocityZ, random);
    }
}
