package com.zurrtum.create.client.infrastructure.ponder.scenes.highLogistics;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.client.foundation.ponder.CreateSceneBuilder;
import com.zurrtum.create.client.ponder.api.PonderPalette;
import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.api.element.ParrotPose.FacePointOfInterestPose;
import com.zurrtum.create.client.ponder.api.element.WorldSectionElement;
import com.zurrtum.create.client.ponder.api.scene.SceneBuilder;
import com.zurrtum.create.client.ponder.api.scene.SceneBuildingUtil;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.packager.PackagerBlock;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;

public class RequesterAndShopScenes {

    public static void requester(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("redstone_requester", "Automated orders with Redstone Requesters");
        scene.configureBasePlate(0, 0, 7);
        scene.showBasePlate();

        Selection vault = util.select().fromTo(4, 1, 3, 5, 2, 5);
        Selection packS = util.select().fromTo(3, 1, 4, 3, 2, 4);
        class_2338 pack = util.grid().at(3, 2, 4);
        class_2338 link = util.grid().at(3, 3, 4);
        Selection linkS = util.select().position(3, 3, 4);
        Selection funnel = util.select().position(2, 2, 4);
        Selection belt = util.select().fromTo(2, 1, 5, 2, 1, 2);
        Selection cogs = util.select().fromTo(3, 1, 6, 3, 1, 5);
        Selection largeCog = util.select().position(3, 0, 7);
        class_2338 req = util.grid().at(3, 1, 1);
        Selection reqS = util.select().position(3, 1, 1);
        Selection buttonAndRedstone = util.select().fromTo(1, 1, 1, 2, 1, 1);
        Selection ticker = util.select().fromTo(3, 1, 0, 4, 1, 0);

        scene.idle(10);

        ElementLink<WorldSectionElement> linkL = scene.world().showIndependentSection(linkS, class_2350.field_11033);
        scene.world().moveSection(linkL, util.vector().of(0, -2, 0), 0);
        scene.idle(15);

        class_1799 linkItem = AllItems.REDSTONE_REQUESTER.method_7854();
        scene.overlay().showControls(util.vector().topOf(link.method_10087(2)), Pointing.DOWN, 50).rightClick().withItem(linkItem);
        scene.idle(5);

        class_238 bb1 = new class_238(link.method_10087(2));
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.BLUE, link, bb1.method_1011(0.45), 10);
        scene.idle(1);
        bb1 = bb1.method_1011(1 / 16f).method_1002(0, 8 / 16f, 0);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.BLUE, link, bb1, 50);
        scene.idle(26);

        scene.overlay().showText(100).text("Right-click a Stock link before placement to connect to its network").attachKeyFrame()
            .colored(PonderPalette.BLUE).placeNearTarget().pointAt(util.vector().centerOf(link.method_10087(2)));

        scene.idle(40);

        scene.world().showSection(reqS, class_2350.field_11033);
        scene.idle(20);

        scene.overlay().chaseBoundingBoxOutline(PonderPalette.GREEN, ticker, new class_238(req), 40);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.GREEN, link, bb1, 40);
        scene.overlay().showLine(
            PonderPalette.GREEN,
            util.vector().centerOf(req).method_1023(0, 1 / 4f, 0),
            util.vector().centerOf(link.method_10087(2)).method_1023(0, 1 / 4f, 0),
            40
        );
        scene.idle(60);

        scene.world().cycleBlockProperty(pack, PackagerBlock.LINKED);

        scene.world().moveSection(linkL, util.vector().of(0, 2.25, 0), 10);
        scene.idle(8);
        scene.world().showSection(packS, class_2350.field_11043);
        scene.idle(3);
        scene.world().moveSection(linkL, util.vector().of(0, -.25, 0), 10);
        scene.idle(10);
        scene.world().cycleBlockProperty(pack, PackagerBlock.LINKED);
        scene.effects().indicateSuccess(pack);
        scene.idle(5);
        scene.world().showSection(vault, class_2350.field_11039);
        scene.idle(30);

        scene.overlay().showText(110).text("Just like Stock tickers, Redstone requesters can order items from the logistics network").attachKeyFrame()
            .placeNearTarget().pointAt(util.vector().blockSurface(req, class_2350.field_11039));
        scene.idle(120);

        scene.overlay().showControls(util.vector().topOf(req), Pointing.DOWN, 80).rightClick();
        scene.idle(10);

        scene.overlay().showOutlineWithText(reqS, 80).text("Right-click the requester to open its configuration UI").attachKeyFrame()
            .colored(PonderPalette.BLUE).placeNearTarget().pointAt(util.vector().blockSurface(req, class_2350.field_11039));

        scene.idle(90);
        scene.world().showSection(buttonAndRedstone, class_2350.field_11034);
        scene.idle(5);
        scene.world().showSection(belt, class_2350.field_11034);
        scene.world().showSection(cogs, class_2350.field_11043);
        scene.world().showSection(largeCog, class_2350.field_11036);
        scene.world().showSection(funnel, class_2350.field_11033);
        scene.idle(30);

        scene.world().toggleRedstonePower(util.select().fromTo(1, 1, 1, 3, 1, 1));
        scene.effects().indicateRedstone(util.grid().at(1, 1, 1));
        PonderHilo.requesterEffect(scene, req);
        scene.idle(5);
        class_1799 box = PackageItem.containing(List.of());
        PonderHilo.packagerCreate(scene, pack, box);
        PonderHilo.linkEffect(scene, link);
        scene.idle(20);

        PonderHilo.packagerClear(scene, pack);
        scene.world().createItemOnBelt(util.grid().at(2, 1, 4), class_2350.field_11034, box);
        scene.idle(15);

        scene.world().toggleRedstonePower(util.select().fromTo(1, 1, 1, 3, 1, 1));

        scene.overlay().showText(120).text("The order set in the UI will be requested on every redstone pulse").attachKeyFrame().placeNearTarget()
            .pointAt(util.vector().blockSurface(util.grid().at(3, 2, 4), class_2350.field_11039));
        scene.idle(60);

        scene.world().toggleRedstonePower(util.select().fromTo(1, 1, 1, 3, 1, 1));
        scene.effects().indicateRedstone(util.grid().at(1, 1, 1));
        PonderHilo.requesterEffect(scene, req);
        scene.idle(5);
        class_1799 box2 = box.method_7972();
        PonderHilo.packagerCreate(scene, pack, box2);
        PonderHilo.linkEffect(scene, link);
        scene.idle(20);

        PonderHilo.packagerClear(scene, pack);
        scene.world().createItemOnBelt(util.grid().at(2, 1, 4), class_2350.field_11034, box2);
        scene.idle(15);

        scene.world().toggleRedstonePower(util.select().fromTo(1, 1, 1, 3, 1, 1));
        scene.idle(60);

        scene.world().hideSection(reqS, class_2350.field_11036);
        scene.world().hideSection(buttonAndRedstone, class_2350.field_11039);
        scene.idle(15);
        ElementLink<WorldSectionElement> tickerL = scene.world().showIndependentSection(ticker, class_2350.field_11033);
        scene.world().moveSection(tickerL, util.vector().of(0, 0, 1), 0);
        scene.idle(5);
        scene.special().createBirb(util.vector().centerOf(util.grid().at(4, 1, 1)), FacePointOfInterestPose::new);
        scene.idle(20);

        class_243 keeper = util.vector().blockSurface(util.grid().at(4, 1, 1), class_2350.field_11039).method_1031(0, 0.5, 0);
        scene.overlay().showControls(util.vector().topOf(util.grid().at(4, 1, 1)), Pointing.DOWN, 50).rightClick().withItem(linkItem);
        scene.idle(10);

        scene.overlay().showText(80).text("Alternatively, the requester can be fully configured before placement").attachKeyFrame()
            .colored(PonderPalette.BLUE).placeNearTarget().pointAt(keeper);
        scene.idle(90);

        scene.overlay().showText(100).text("Right-click a Stock keeper with it and set the desired order there").colored(PonderPalette.BLUE)
            .placeNearTarget().pointAt(keeper);
        scene.idle(90);

    }

}