package com.zurrtum.create.client.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.zurrtum.create.client.infrastructure.model.WrapperBlockStateModel;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_778;

@Mixin(value = class_776.class, priority = 999)
public class BlockRenderDispatcherMixin {

    @Shadow
    @Final
    private class_5819 singleThreadRandom;

    @Shadow
    @Final
    private List<class_10889> singleThreadPartList;

    @Shadow
    @Final
    private class_778 modelRenderer;

    @Inject(method = "renderBreakingTexture(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/BlockAndTintGetter;Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;)V", at = @At(value = "INVOKE_ASSIGN", target = "Lnet/minecraft/client/renderer/block/BlockModelShaper;getBlockModel(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/client/renderer/block/model/BlockStateModel;", shift = At.Shift.AFTER), cancellable = true)
    private void renderDamage(
        class_2680 state,
        class_2338 pos,
        class_1920 world,
        class_4587 matrices,
        class_4588 vertexConsumer,
        CallbackInfo ci,
        @Local class_1087 model
    ) {
        if (WrapperBlockStateModel.unwrapCompat(model) instanceof WrapperBlockStateModel wrapper) {
            singleThreadRandom.method_43052(state.method_26190(pos));
            singleThreadPartList.clear();
            wrapper.addPartsWithInfo(world, pos, state, singleThreadRandom, singleThreadPartList);
            if (!singleThreadPartList.isEmpty()) {
                modelRenderer.method_3374(world, this.singleThreadPartList, state, pos, matrices, vertexConsumer, true, class_4608.field_21444);
            }
            ci.cancel();
        }
    }
}
