package com.zurrtum.create.client.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.content.contraptions.ContraptionHandlerClient;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.impl.visualization.VisualizationEventHandler;
import com.zurrtum.create.client.flywheel.lib.visualization.VisualizationHelper;
import com.zurrtum.create.content.contraptions.minecart.capability.CapabilityMinecartController;
import com.zurrtum.create.content.equipment.armor.CardboardArmorHandler;
import com.zurrtum.create.content.equipment.armor.DivingBootsItem;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import net.minecraft.class_638;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static com.zurrtum.create.Create.REDSTONE_LINK_NETWORK_HANDLER;

@Mixin(class_638.class)
public class ClientLevelMixin {
    @Inject(method = "onBlockEntityAdded(Lnet/minecraft/world/level/block/entity/BlockEntity;)V", at = @At(value = "INVOKE", target = "Ljava/util/Set;add(Ljava/lang/Object;)Z"), cancellable = true)
    private void flywheel$decideNotToRenderEntity(class_2586 entity, CallbackInfo ci) {
        if (VisualizationManager.supportsVisualization(entity.method_10997()) && VisualizationHelper.skipVanillaRender(entity)) {
            ci.cancel();
        }
    }

    @Inject(method = "<init>", at = @At("TAIL"))
    private void onLoadWorld(CallbackInfo ci) {
        Create.SCHEMATIC_HANDLER.updateRenderers();
        REDSTONE_LINK_NETWORK_HANDLER.onLoadWorld((class_1937) (Object) this);
    }

    @Inject(method = "addEntity(Lnet/minecraft/world/entity/Entity;)V", at = @At("HEAD"))
    private void addEntity(CallbackInfo ci, @Local(argsOnly = true) class_1297 entity) {
        class_638 world = (class_638) (Object) this;
        VisualizationEventHandler.onEntityJoinLevel(world, entity);
        ContraptionHandlerClient.addSpawnedContraptionsToCollisionList(entity, world);
        CapabilityMinecartController.attach(entity);
    }

    @Inject(method = "tickNonPassenger(Lnet/minecraft/world/entity/Entity;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/Entity;tick()V"))
    private void tickEntity(class_1297 entity, CallbackInfo ci) {
        CapabilityMinecartController.entityTick(entity);
        DivingBootsItem.accelerateDescentUnderwater(entity);
        CardboardArmorHandler.mobsMayLoseTargetWhenItIsWearingCardboard(entity);
    }
}
