package com.zurrtum.create.client.mixin;

import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1065;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3268;
import net.minecraft.class_3272;
import net.minecraft.class_3288;
import net.minecraft.class_5352;
import net.minecraft.class_7662;
import net.minecraft.class_7665;
import net.minecraft.class_9224;
import net.minecraft.class_9225;
import net.minecraft.class_9226;
import net.minecraft.server.packs.*;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.nio.file.Path;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;

import static com.zurrtum.create.Create.MOD_ID;

@Mixin(class_1065.class)
public abstract class ClientPackSourceMixin {
    @Inject(method = "populatePackList(Ljava/util/function/BiConsumer;)V", at = @At("TAIL"))
    private void loadResourcePack(BiConsumer<String, Function<String, class_3288>> consumer, CallbackInfo ci) {
        ModContainer mod = FabricLoader.getInstance().getModContainer(MOD_ID).orElseThrow();
        consumer.accept(
            MOD_ID, id -> {
                ModMetadata metadata = mod.getMetadata();
                class_9224 info = new class_9224(
                    id,
                    class_2561.method_30163(metadata.getName()),
                    class_5352.field_25348,
                    Optional.of(new class_9226(id, "assets", metadata.getVersion().getFriendlyString()))
                );
                class_3264 type = class_3264.field_14188;
                class_7662 metadataMap = class_7662.method_45174(
                    class_3272.field_61155,
                    new class_3272(
                        class_2561.method_43471("advancement.create.root"),
                        class_155.method_16673().method_70592(type).method_72318()
                    )
                );
                class_7665 builder = new class_7665().method_45198(metadataMap)
                    .method_45206(id, "minecraft", "flywheel", "vanillin", "ponder", "fabric");
                String directory = type.method_14413();
                for (Path path : mod.getRootPaths()) {
                    builder.method_45201(type, path.resolve(directory));
                }
                class_3268 pack = builder.method_45210(info);
                class_3288.class_7680 packFactory = new class_3288.class_7680() {
                    @Override
                    public class_3262 method_52424(class_9224 info) {
                        return pack;
                    }

                    @Override
                    public class_3262 method_52425(class_9224 info, class_3288.class_7679 metadata) {
                        return pack;
                    }
                };
                class_9225 position = new class_9225(true, class_3288.class_3289.field_14281, false);
                return class_3288.method_45275(info, packFactory, type, position);
            }
        );
    }
}
