package com.zurrtum.create.client.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.brigadier.CommandDispatcher;
import com.zurrtum.create.client.flywheel.impl.FlwCommands;
import com.zurrtum.create.foundation.blockEntity.SyncedBlockEntity;
import net.minecraft.class_11368;
import net.minecraft.class_2172;
import net.minecraft.class_2586;
import net.minecraft.class_2641;
import net.minecraft.class_634;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_634.class)
public class ClientPacketListenerMixin {
    @Shadow
    private CommandDispatcher<class_2172> commands;

    @Inject(method = "handleCommands(Lnet/minecraft/network/protocol/game/ClientboundCommandsPacket;)V", at = @At("TAIL"))
    private void addCommand(class_2641 packet, CallbackInfo ci) {
        FlwCommands.registerClientCommands(commands);
    }

    @WrapOperation(method = "method_38542(Lnet/minecraft/network/protocol/game/ClientboundBlockEntityDataPacket;Lnet/minecraft/world/level/block/entity/BlockEntity;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/block/entity/BlockEntity;loadWithComponents(Lnet/minecraft/world/level/storage/ValueInput;)V"))
    private void onDataPacket(class_2586 blockEntity, class_11368 view, Operation<Void> original) {
        if (blockEntity instanceof SyncedBlockEntity syncedBlockEntity) {
            syncedBlockEntity.onDataPacket(view);
        } else {
            original.call(blockEntity, view);
        }
    }
}
