/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.zurrtum.create.client.mixin;

import com.zurrtum.create.client.infrastructure.itemGroup.FabricCreativeGuiComponents;
import com.zurrtum.create.client.infrastructure.itemGroup.FabricCreativeInventoryScreen;
import com.zurrtum.create.infrastructure.itemGroup.FabricItemGroupImpl;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Objects;
import net.minecraft.class_11908;
import net.minecraft.class_1661;
import net.minecraft.class_1761;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_7706;

@Mixin(class_481.class)
public abstract class CreativeModeInventoryScreenMixin extends class_465<class_481.class_483> implements FabricCreativeInventoryScreen {
    public CreativeModeInventoryScreenMixin(class_481.class_483 screenHandler, class_1661 playerInventory, class_2561 text) {
        super(screenHandler, playerInventory, text);
    }

    @Shadow
    protected abstract void selectTab(class_1761 itemGroup_1);

    @Shadow
    private static class_1761 selectedTab;

    // "static" matches selectedTab
    @Unique
    private static int currentPage = 0;

    @Inject(method = "init", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/components/EditBox;setTextColor(I)V", shift = At.Shift.AFTER))
    private void init(CallbackInfo info) {
        currentPage = fabric_getPage(selectedTab);

        int xpos = field_2776 + 171;
        int ypos = field_2800 + 4;

        method_37063(new FabricCreativeGuiComponents.ItemGroupButtonWidget(xpos + 10, ypos, FabricCreativeGuiComponents.Type.NEXT, this));
        method_37063(new FabricCreativeGuiComponents.ItemGroupButtonWidget(xpos, ypos, FabricCreativeGuiComponents.Type.PREVIOUS, this));
    }

    @Inject(method = "selectTab", at = @At("HEAD"), cancellable = true)
    private void setSelectedTab(class_1761 itemGroup, CallbackInfo info) {
        if (!isGroupVisible(itemGroup)) {
            info.cancel();
        }
    }

    @Inject(method = "checkTabHovering", at = @At("HEAD"), cancellable = true)
    private void renderTabTooltipIfHovered(class_332 drawContext, class_1761 itemGroup, int mx, int my, CallbackInfoReturnable<Boolean> info) {
        if (!isGroupVisible(itemGroup)) {
            info.setReturnValue(false);
        }
    }

    @Inject(method = "checkTabClicked", at = @At("HEAD"), cancellable = true)
    private void isClickInTab(class_1761 itemGroup, double mx, double my, CallbackInfoReturnable<Boolean> info) {
        if (!isGroupVisible(itemGroup)) {
            info.setReturnValue(false);
        }
    }

    @Inject(method = "renderTabButton", at = @At("HEAD"), cancellable = true)
    private void renderTabIcon(class_332 graphics, int mouseX, int mouseY, class_1761 itemGroup, CallbackInfo info) {
        if (!isGroupVisible(itemGroup)) {
            info.cancel();
        }
    }

    @Inject(method = "keyPressed", at = @At("HEAD"), cancellable = true)
    private void keyPressed(class_11908 input, CallbackInfoReturnable<Boolean> cir) {
        int keyCode = input.comp_4795();
        if (keyCode == GLFW.GLFW_KEY_PAGE_UP) {
            if (fabric_switchToPreviousPage()) {
                cir.setReturnValue(true);
            }
        } else if (keyCode == GLFW.GLFW_KEY_PAGE_DOWN) {
            if (fabric_switchToNextPage()) {
                cir.setReturnValue(true);
            }
        }
    }

    @Override
    public int fabric_getCurrentPage() {
        return currentPage;
    }

    @Override
    public boolean fabric_switchToPage(int page) {
        if (!hasGroupForPage(page)) {
            return false;
        }

        if (currentPage == page) {
            return false;
        }

        currentPage = page;
        updateSelection();
        return true;
    }

    @Override
    public int fabric_getPage(class_1761 itemGroup) {
        if (FabricCreativeGuiComponents.COMMON_GROUPS.contains(itemGroup)) {
            return currentPage;
        }

        final FabricItemGroupImpl fabricItemGroup = (FabricItemGroupImpl) itemGroup;
        return fabricItemGroup.fabric_getPage();
    }

    @Override
    public boolean fabric_hasAdditionalPages() {
        return class_7706.method_47335().size() > (Objects.requireNonNull(class_7706.field_42466).comp_1252() ? 14 : 13);
    }

    @Override
    public int fabric_getPageCount() {
        return FabricCreativeGuiComponents.getPageCount();
    }

    @Unique
    private boolean isGroupVisible(class_1761 itemGroup) {
        return itemGroup.method_47311() && currentPage == fabric_getPage(itemGroup);
    }

    @Unique
    private void updateSelection() {
        if (!isGroupVisible(selectedTab)) {
            class_7706.method_47341().stream().filter(this::isGroupVisible).min((a, b) -> Boolean.compare(a.method_7752(), b.method_7752()))
                .ifPresent(this::selectTab);
        }
    }

    @Unique
    private boolean hasGroupForPage(int page) {
        return class_7706.method_47335().stream().anyMatch(itemGroup -> fabric_getPage(itemGroup) == page);
    }
}