package com.zurrtum.create.client.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.zurrtum.create.foundation.block.SoundControlBlock;
import net.minecraft.class_2338;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_638;
import net.minecraft.class_9959;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_9959.class)
public class LevelEventHandlerMixin {
    @Shadow
    @Final
    private class_638 level;

    @WrapOperation(method = "levelEvent(ILnet/minecraft/core/BlockPos;I)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/block/state/BlockState;getSoundType()Lnet/minecraft/world/level/block/SoundType;"))
    private class_2498 getBreakSound(class_2680 state, Operation<class_2498> original, @Local(argsOnly = true) class_2338 pos) {
        if (state.method_26204() instanceof SoundControlBlock block) {
            return block.getSoundGroup(level, pos);
        }
        return original.call(state);
    }
}
