package com.zurrtum.create.client.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.zurrtum.create.client.model.NormalsBakedQuad;
import com.zurrtum.create.client.model.NormalsModelElement;
import com.zurrtum.create.client.model.NormalsModelElement.NormalsType;
import net.minecraft.class_1058;
import net.minecraft.class_10802;
import net.minecraft.class_2350;
import net.minecraft.class_3665;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_783;
import net.minecraft.class_785;
import net.minecraft.class_789;
import net.minecraft.client.renderer.block.model.*;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_10802.class)
public class SimpleUnbakedGeometryMixin {
    @WrapOperation(method = "bake(Ljava/util/List;Lnet/minecraft/client/renderer/block/model/TextureSlots;Lnet/minecraft/client/resources/model/ModelBaker;Lnet/minecraft/client/resources/model/ModelState;Lnet/minecraft/client/resources/model/ModelDebugName;)Lnet/minecraft/client/resources/model/QuadCollection;", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/block/model/FaceBakery;bakeQuad(Lnet/minecraft/client/resources/model/ModelBaker$PartCache;Lorg/joml/Vector3fc;Lorg/joml/Vector3fc;Lnet/minecraft/client/renderer/block/model/BlockElementFace;Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;Lnet/minecraft/core/Direction;Lnet/minecraft/client/resources/model/ModelState;Lnet/minecraft/client/renderer/block/model/BlockElementRotation;ZI)Lnet/minecraft/client/renderer/block/model/BakedQuad;"))
    private static class_777 bakeQuad(
        final class_7775.class_12356 partCache,
        final Vector3fc from,
        final Vector3fc to,
        final class_783 face,
        final class_1058 icon,
        final class_2350 facing,
        final class_3665 modelState,
        @Nullable final class_789 elementRotation,
        final boolean shade,
        final int lightEmission,
        Operation<class_777> original,
        @Local class_785 element
    ) {
        class_777 quad = original.call(partCache, from, to, face, icon, facing, modelState, elementRotation, shade, lightEmission);
        NormalsType type = NormalsModelElement.getNormalsType(element);
        if (type != null) {
            Vector3fc vector;
            if (type == NormalsType.CALC) {
                Vector3f v1 = new Vector3f(quad.comp_5241());
                Vector3fc t1 = quad.comp_5239();
                Vector3f v2 = new Vector3f(quad.comp_5240());
                Vector3fc t2 = quad.comp_5238();
                v1.sub(t1);
                v2.sub(t2);
                v2.cross(v1);
                vector = v2.normalize();
            } else {
                vector = quad.comp_3723().method_68072();
            }

            int x = ((byte) Math.round(vector.x() * 127)) & 0xFF;
            int y = ((byte) Math.round(vector.y() * 127)) & 0xFF;
            int z = ((byte) Math.round(vector.z() * 127)) & 0xFF;
            int normal = x | (y << 0x08) | (z << 0x10);
            NormalsBakedQuad.setNormals(quad, new int[]{normal, normal, normal, normal});
        }
        return quad;
    }
}
