package com.zurrtum.create.client.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.serialization.Dynamic;
import com.zurrtum.create.infrastructure.worldgen.AllPlacedFeatures;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_3283;
import net.minecraft.class_6904;
import net.minecraft.class_7196;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_7196.class)
public class WorldOpenFlowsMixin {
    @WrapOperation(method = "openWorldLoadLevelStem(Lnet/minecraft/world/level/storage/LevelStorageSource$LevelStorageAccess;Lcom/mojang/serialization/Dynamic;ZLjava/lang/Runnable;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screens/worldselection/WorldOpenFlows;loadWorldStem(Lcom/mojang/serialization/Dynamic;ZLnet/minecraft/server/packs/repository/PackRepository;)Lnet/minecraft/server/WorldStem;"))
    private class_6904 addBiomeFeatures(
        class_7196 instance,
        Dynamic<?> levelProperties,
        boolean safeMode,
        class_3283 dataPackManager,
        Operation<class_6904> original
    ) {
        class_6904 loader = original.call(instance, levelProperties, safeMode, dataPackManager);
        AllPlacedFeatures.register(loader.comp_358().method_45926());
        return loader;
    }

    @WrapOperation(method = "createLevelFromExistingSettings(Lnet/minecraft/world/level/storage/LevelStorageSource$LevelStorageAccess;Lnet/minecraft/server/ReloadableServerResources;Lnet/minecraft/core/LayeredRegistryAccess;Lnet/minecraft/world/level/storage/WorldData;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/Minecraft;doWorldLoad(Lnet/minecraft/world/level/storage/LevelStorageSource$LevelStorageAccess;Lnet/minecraft/server/packs/repository/PackRepository;Lnet/minecraft/server/WorldStem;Z)V"))
    private void addBiomeFeatures(
        class_310 instance,
        class_32.class_5143 session,
        class_3283 dataPackManager,
        class_6904 saveLoader,
        boolean newWorld,
        Operation<Void> original
    ) {
        AllPlacedFeatures.register(saveLoader.comp_358().method_45926());
        original.call(instance, session, dataPackManager, saveLoader, newWorld);
    }
}
