/*
 * Copyright (c) NeoForged and contributors
 * SPDX-License-Identifier: LGPL-2.1-only
 */

package com.zurrtum.create.client.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import org.jetbrains.annotations.Nullable;

import java.util.Map;
import net.minecraft.class_10419;
import net.minecraft.class_1100;
import net.minecraft.class_11515;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_4590;
import net.minecraft.class_809;

/**
 * Wrapper around all standard top-level model parameters added by vanilla and NeoForge except elements.
 * <p>
 * For use in custom model loaders which want to respect these properties but create the quads from
 * something other than the vanilla elements spec.
 */
public record StandardModelParameters(
    @Nullable class_2960 parent, class_10419.class_10420 textures, @Nullable class_809 itemTransforms, @Nullable Boolean ambientOcclusion,
    @Nullable class_1100.class_4751 guiLight, @Nullable class_4590 rootTransform, @Nullable class_11515 layer,
    Map<String, Boolean> partVisibility
) {
    public static StandardModelParameters parse(JsonObject jsonObject, JsonDeserializationContext context) {
        String parentName = class_3518.method_15253(jsonObject, "parent", "");
        class_2960 parent = parentName.isEmpty() ? null : class_2960.method_60654(parentName);

        class_10419.class_10420 textures = class_10419.class_10420.field_55278;
        if (jsonObject.has("textures")) {
            JsonObject jsonobject = class_3518.method_15296(jsonObject, "textures");
            textures = class_10419.method_65544(jsonobject);
        }

        class_809 itemTransforms = null;
        if (jsonObject.has("display")) {
            JsonObject jsonobject1 = class_3518.method_15296(jsonObject, "display");
            itemTransforms = context.deserialize(jsonobject1, class_809.class);
        }

        Boolean ambientOcclusion = null;
        if (jsonObject.has("ambientocclusion")) {
            ambientOcclusion = class_3518.method_15270(jsonObject, "ambientocclusion");
        }

        class_1100.class_4751 guiLight = null;
        if (jsonObject.has("gui_light")) {
            guiLight = class_1100.class_4751.method_24300(class_3518.method_15265(jsonObject, "gui_light"));
        }

        class_4590 rootTransform = NeoForgeModelProperties.deserializeRootTransform(jsonObject, context);
        class_11515 layer = NeoForgeModelProperties.deserializeRenderType(jsonObject);
        Map<String, Boolean> partVisibility = NeoForgeModelProperties.deserializePartVisibility(jsonObject);

        return new StandardModelParameters(parent, textures, itemTransforms, ambientOcclusion, guiLight, rootTransform, layer, partVisibility);
    }
}
