package com.zurrtum.create.client.ponder.api.scene;

import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.api.element.EntityElement;
import com.zurrtum.create.client.ponder.api.element.WorldSectionElement;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_7225;

public interface WorldInstructions {
    class_7225.class_7874 getHolderLookupProvider();

    void incrementBlockBreakingProgress(class_2338 pos);

    void showSection(Selection selection, class_2350 fadeInDirection);

    void showSectionAndMerge(Selection selection, class_2350 fadeInDirection, ElementLink<WorldSectionElement> link);

    void glueBlockOnto(class_2338 position, class_2350 fadeInDirection, ElementLink<WorldSectionElement> link);

    ElementLink<WorldSectionElement> showIndependentSection(Selection selection, class_2350 fadeInDirection);

    ElementLink<WorldSectionElement> showIndependentSectionImmediately(Selection selection);

    void hideSection(Selection selection, class_2350 fadeOutDirection);

    void hideIndependentSection(ElementLink<WorldSectionElement> link, class_2350 fadeOutDirection);

    void restoreBlocks(Selection selection);

    ElementLink<WorldSectionElement> makeSectionIndependent(Selection selection);

    void rotateSection(ElementLink<WorldSectionElement> link, double xRotation, double yRotation, double zRotation, int duration);

    void configureCenterOfRotation(ElementLink<WorldSectionElement> link, class_243 anchor);

    void configureStabilization(ElementLink<WorldSectionElement> link, class_243 anchor);

    void moveSection(ElementLink<WorldSectionElement> link, class_243 offset, int duration);

    void setBlocks(Selection selection, class_2680 state, boolean spawnParticles);

    void destroyBlock(class_2338 pos);

    void setBlock(class_2338 pos, class_2680 state, boolean spawnParticles);

    void replaceBlocks(Selection selection, class_2680 state, boolean spawnParticles);

    void modifyBlock(class_2338 pos, UnaryOperator<class_2680> stateFunc, boolean spawnParticles);

    void cycleBlockProperty(class_2338 pos, class_2769<?> property);

    void modifyBlocks(Selection selection, UnaryOperator<class_2680> stateFunc, boolean spawnParticles);

    void toggleRedstonePower(Selection selection);

    <T extends class_1297> void modifyEntities(Class<T> entityClass, Consumer<T> entityCallBack);

    <T extends class_1297> void modifyEntitiesInside(Class<T> entityClass, Selection area, Consumer<T> entityCallBack);

    void modifyEntity(ElementLink<EntityElement> link, Consumer<class_1297> entityCallBack);

    ElementLink<EntityElement> createEntity(Function<class_1937, class_1297> factory);

    ElementLink<EntityElement> createItemEntity(class_243 location, class_243 motion, class_1799 stack);

    void modifyBlockEntityNBT(Selection selection, Class<? extends class_2586> beType, Consumer<class_2487> consumer);

    <T extends class_2586> void modifyBlockEntity(class_2338 position, Class<T> beType, Consumer<T> consumer);

    void modifyBlockEntityNBT(Selection selection, Class<? extends class_2586> teType, Consumer<class_2487> consumer, boolean reDrawBlocks);
}