package com.zurrtum.create.client.ponder.foundation;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.UIRenderHelper;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.catnip.render.SuperRenderTypeBuffer;
import com.zurrtum.create.client.ponder.api.element.*;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.client.ponder.api.registration.StoryBoardEntry.SceneOrderingEntry;
import com.zurrtum.create.client.ponder.api.scene.SceneBuilder;
import com.zurrtum.create.client.ponder.api.scene.SceneBuildingUtil;
import com.zurrtum.create.client.ponder.foundation.element.WorldSectionElementImpl;
import com.zurrtum.create.client.ponder.foundation.instruction.HideAllInstruction;
import com.zurrtum.create.client.ponder.foundation.instruction.PonderInstruction;
import com.zurrtum.create.client.ponder.foundation.registration.PonderLocalization;
import com.zurrtum.create.client.ponder.foundation.ui.PonderUI;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix4f;
import org.joml.Vector4f;

import java.util.*;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_10442;
import net.minecraft.class_11515;
import net.minecraft.class_11661;
import net.minecraft.class_12075;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3341;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import net.minecraft.class_824;
import net.minecraft.class_898;

public class PonderScene {

    public static final String TITLE_KEY = "header";

    final PonderLocalization localization;

    private boolean finished;
    //	private int sceneIndex;
    private int textIndex;
    class_2960 sceneId;

    private final IntList keyframeTimes;

    List<PonderInstruction> schedule;
    private final List<PonderInstruction> activeSchedule;
    private final Map<UUID, PonderElement> linkedElements;
    private final Set<PonderElement> elements;
    private final List<PonderTag> tags;
    private final List<SceneOrderingEntry> orderingEntries;

    private final PonderLevel world;
    private final String namespace;
    private final class_2960 location;
    private final SceneCamera camera;
    private final class_12075 cameraRenderState;
    private final Outliner outliner;
    private SceneTransform transform;
    //	private String defaultTitle;

    private final WorldSectionElement baseWorldSection;
    private final class_1297 renderViewEntity;
    private class_243 pointOfInterest;
    @Nullable
    private class_243 chasingPointOfInterest;

    int basePlateOffsetX;
    int basePlateOffsetZ;
    int basePlateSize;
    float scaleFactor;
    float yOffset;
    boolean hidePlatformShadow;

    private boolean stoppedCounting;
    private int totalTime;
    private int currentTime;
    private boolean nextUpEnabled = true;

    public PonderScene(
        @Nullable PonderLevel world,
        PonderLocalization localization,
        String namespace,
        class_2960 location,
        Collection<class_2960> tags,
        Collection<SceneOrderingEntry> orderingEntries
    ) {
        if (world != null) {
            world.scene = this;
        }
        this.world = world;

        this.localization = localization;

        pointOfInterest = class_243.field_1353;
        textIndex = 1;
        hidePlatformShadow = false;

        this.namespace = namespace;
        this.location = location;
        this.sceneId = class_2960.method_60655(namespace, "missing_title");

        outliner = new Outliner();
        elements = new HashSet<>();
        linkedElements = new HashMap<>();
        this.tags = tags.stream().map(PonderIndex.getTagAccess()::getRegisteredTag).toList();
        this.orderingEntries = new ArrayList<>(orderingEntries);
        schedule = new ArrayList<>();
        activeSchedule = new ArrayList<>();
        transform = new SceneTransform();
        basePlateSize = getBounds().method_35414();
        camera = new SceneCamera();
        cameraRenderState = new class_12075();
        baseWorldSection = new WorldSectionElementImpl();
        keyframeTimes = new IntArrayList(4);
        scaleFactor = 1;
        yOffset = 0;

        if (world != null) {
            renderViewEntity = new class_1531(world, 0, 0, 0);
        } else {
            renderViewEntity = null;
        }

        setPointOfInterest(new class_243(0, 4, 0));
    }

    public void deselect() {
        forEach(WorldSectionElement.class, WorldSectionElement::resetSelectedBlock);
    }

    public Pair<class_1799, class_2338> rayTraceScene(class_243 from, class_243 to) {
        MutableObject<Pair<WorldSectionElement, Pair<class_243, class_3965>>> nearestHit = new MutableObject<>();
        MutableDouble bestDistance = new MutableDouble(0);

        forEach(
            WorldSectionElement.class, wse -> {
                wse.resetSelectedBlock();
                if (!wse.isVisible())
                    return;
                Pair<class_243, class_3965> rayTrace = wse.rayTrace(world, from, to);
                if (rayTrace == null)
                    return;
                double distanceTo = rayTrace.getFirst().method_1022(from);
                if (nearestHit.getValue() != null && distanceTo >= bestDistance.getValue())
                    return;

                nearestHit.setValue(Pair.of(wse, rayTrace));
                bestDistance.setValue(distanceTo);
            }
        );

        if (nearestHit.getValue() == null)
            return Pair.of(class_1799.field_8037, class_2338.field_10980);

        Pair<class_243, class_3965> selectedHit = nearestHit.getValue().getSecond();
        class_2338 selectedPos = selectedHit.getSecond().method_17777();

        class_2338 origin = new class_2338(basePlateOffsetX, 0, basePlateOffsetZ);
        if (!world.getBounds().method_14662(selectedPos))
            return Pair.of(class_1799.field_8037, null);
        if (class_3341.method_34390(origin, origin.method_10081(new class_2382(basePlateSize - 1, 0, basePlateSize - 1))).method_14662(selectedPos)) {
            if (PonderIndex.editingModeActive())
                nearestHit.getValue().getFirst().selectBlock(selectedPos);
            return Pair.of(class_1799.field_8037, selectedPos);
        }

        nearestHit.getValue().getFirst().selectBlock(selectedPos);
        class_2680 blockState = world.method_8320(selectedPos);

        class_1799 pickBlock = blockState.method_65171(world, selectedPos, true);

        return Pair.of(pickBlock, selectedPos);
    }

    public void reset() {
        currentTime = 0;
        activeSchedule.clear();
        schedule.forEach(mdi -> mdi.reset(this));
    }

    public void begin() {
        reset();
        forEach(pe -> pe.reset(this));

        world.restore();
        elements.clear();
        linkedElements.clear();
        keyframeTimes.clear();

        transform = new SceneTransform();
        finished = false;
        setPointOfInterest(new class_243(0, 4, 0));

        baseWorldSection.setEmpty();
        baseWorldSection.forceApplyFade(1);
        elements.add(baseWorldSection);

        totalTime = 0;
        stoppedCounting = false;
        activeSchedule.addAll(schedule);
        activeSchedule.forEach(i -> i.onScheduled(this));
    }

    public WorldSectionElement getBaseWorldSection() {
        return baseWorldSection;
    }

    public float getSceneProgress() {
        return totalTime == 0 ? 0 : currentTime / (float) totalTime;
    }

    public void fadeOut() {
        reset();
        activeSchedule.add(new HideAllInstruction(10, null));
    }

    public void renderScene(class_310 mc, SuperRenderTypeBuffer buffer, class_11661 queue, class_4587 ms, float pt) {
        ms.method_22903();
        class_1297 prevRVE = mc.method_1560();

        camera.set(transform.xRotation.getValue(pt) + 90, transform.yRotation.getValue(pt) + 180);
        cameraRenderState.field_63079 = true;
        cameraRenderState.field_63078 = camera.method_71156();
        cameraRenderState.field_63077 = camera.method_19328();
        cameraRenderState.field_63080 = renderViewEntity.method_30950(pt);
        cameraRenderState.field_63081.set(camera.method_23767());
        mc.method_1504(renderViewEntity);
        class_824 blockEntityRenderManager = mc.method_31975();
        class_776 blockRenderManager = mc.method_1541();
        class_898 entityRenderDispatcher = mc.method_1561();
        class_10442 itemModelManager = mc.method_65386();
        forEachVisible(
            PonderSceneElement.class,
            e -> e.renderFirst(blockEntityRenderManager, blockRenderManager, world, buffer, queue, camera, cameraRenderState, ms, pt)
        );
        mc.method_1504(prevRVE);

        for (class_11515 type : class_11515.values())
            forEachVisible(PonderSceneElement.class, e -> e.renderLayer(world, buffer, type, ms, pt));

        forEachVisible(
            PonderSceneElement.class,
            e -> e.renderLast(entityRenderDispatcher, itemModelManager, world, buffer, queue, camera, cameraRenderState, ms, pt)
        );
        class_308 lighting = mc.field_1773.method_71114();
        lighting.method_71034(class_308.class_11274.field_60028);
        world.renderEntities(ms, queue, camera, cameraRenderState, pt);
        lighting.method_71034(class_308.class_11274.field_60025);
        world.renderParticles(ms, queue, camera, cameraRenderState, pt);
        outliner.renderOutlines(mc, ms, buffer, class_243.field_1353, pt);

        ms.method_22909();
    }

    public void renderOverlay(PonderUI screen, class_332 graphics, float partialTicks) {
        Matrix3x2fStack matrices = graphics.method_51448();
        matrices.pushMatrix();
        forEachVisible(PonderOverlayElement.class, e -> e.render(this, screen, graphics, partialTicks));
        matrices.popMatrix();
    }

    public void setPointOfInterest(class_243 poi) {
        if (chasingPointOfInterest == null)
            pointOfInterest = poi;
        chasingPointOfInterest = poi;
    }

    public class_243 getPointOfInterest() {
        return pointOfInterest;
    }

    public void tick() {
        if (chasingPointOfInterest != null)
            pointOfInterest = VecHelper.lerp(.25f, pointOfInterest, chasingPointOfInterest);

        outliner.tickOutlines();
        world.tick();
        transform.tick();
        forEach(e -> e.tick(this));

        if (currentTime < totalTime)
            currentTime++;

        for (Iterator<PonderInstruction> iterator = activeSchedule.iterator(); iterator.hasNext(); ) {
            PonderInstruction instruction = iterator.next();
            instruction.tick(this);
            if (instruction.isComplete()) {
                iterator.remove();
                if (instruction.isBlocking())
                    break;
                continue;
            }
            if (instruction.isBlocking())
                break;
        }

        if (activeSchedule.isEmpty())
            finished = true;
    }

    public void seekToTime(int time) {
        if (time < currentTime)
            throw new IllegalStateException("Cannot seek backwards. Rewind first.");

        while (currentTime < time && !finished) {
            forEach(e -> e.whileSkipping(this));
            tick();
        }

        forEach(WorldSectionElement.class, WorldSectionElement::queueRedraw);
    }

    public void addToSceneTime(int time) {
        if (!stoppedCounting)
            totalTime += time;
    }

    public void stopCounting() {
        stoppedCounting = true;
    }

    public void markKeyframe(int offset) {
        if (!stoppedCounting)
            keyframeTimes.add(totalTime + offset);
    }

    public void addElement(PonderElement e) {
        elements.add(e);
    }

    public <E extends PonderElement> void linkElement(E e, ElementLink<E> link) {
        linkedElements.put(link.getId(), e);
    }

    @Nullable
    public <E extends PonderElement> E resolve(ElementLink<E> link) {
        return link.cast(linkedElements.get(link.getId()));
    }

    public <E extends PonderElement> Optional<E> resolveOptional(ElementLink<E> link) {
        return Optional.ofNullable(resolve(link));
    }

    public <E extends PonderElement> void runWith(ElementLink<E> link, Consumer<E> callback) {
        callback.accept(resolve(link));
    }

    public <E extends PonderElement, F> F applyTo(ElementLink<E> link, Function<E, F> function) {
        return function.apply(resolve(link));
    }

    public void forEach(Consumer<? super PonderElement> function) {
        for (PonderElement elemtent : elements)
            function.accept(elemtent);
    }

    public <T extends PonderElement> void forEach(Class<T> type, Consumer<T> function) {
        for (PonderElement element : elements)
            if (type.isInstance(element))
                function.accept(type.cast(element));
    }

    public <T extends PonderElement> void forEachVisible(Class<T> type, Consumer<T> function) {
        for (PonderElement element : elements)
            if (type.isInstance(element) && element.isVisible())
                function.accept(type.cast(element));
    }

    public <T extends class_1297> void forEachWorldEntity(Class<T> type, Consumer<T> function) {
        for (class_1297 entity : world.getEntityList()) {
            if (type.isInstance(entity)) {
                function.accept(type.cast(entity));
            }
        }
    }

    public Supplier<String> registerText(String defaultText) {
        final String key = "text_" + textIndex;
        localization.registerSpecific(sceneId, key, defaultText);
        Supplier<String> supplier = () -> localization.getSpecific(sceneId, key);
        textIndex++;
        return supplier;
    }

    public Supplier<String> registerText(String defaultText, Object... params) {
        final String key = "text_" + textIndex;
        localization.registerSpecific(sceneId, key, defaultText);
        Supplier<String> supplier = () -> localization.getSpecific(sceneId, key, params);
        textIndex++;
        return supplier;
    }

    public SceneBuilder builder() {
        return new PonderSceneBuilder(this);
    }

    public SceneBuildingUtil getSceneBuildingUtil() {
        return new PonderSceneBuildingUtil(getBounds());
    }

    public String getTitle() {
        return getString(TITLE_KEY);
    }

    public String getString(String key) {
        return localization.getSpecific(sceneId, key);
    }

    public PonderLevel getLevel() {
        return world;
    }

    public String getNamespace() {
        return namespace;
    }

    public int getKeyframeCount() {
        return keyframeTimes.size();
    }

    public int getKeyframeTime(int index) {
        return keyframeTimes.getInt(index);
    }

    public List<PonderTag> getTags() {
        return tags;
    }

    public List<SceneOrderingEntry> getOrderingEntries() {
        return orderingEntries;
    }

    public class_2960 getLocation() {
        return location;
    }

    public Set<PonderElement> getElements() {
        return elements;
    }

    public class_3341 getBounds() {
        return world == null ? new class_3341(class_2338.field_10980) : world.getBounds();
    }

    public class_2960 getId() {
        return sceneId;
    }

    public SceneTransform getTransform() {
        return transform;
    }

    public Outliner getOutliner() {
        return outliner;
    }

    public boolean isFinished() {
        return finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public int getBasePlateOffsetX() {
        return basePlateOffsetX;
    }

    public int getBasePlateOffsetZ() {
        return basePlateOffsetZ;
    }

    public boolean shouldHidePlatformShadow() {
        return hidePlatformShadow;
    }

    public int getBasePlateSize() {
        return basePlateSize;
    }

    public float getScaleFactor() {
        return scaleFactor;
    }

    public float getYOffset() {
        return yOffset;
    }

    public int getTotalTime() {
        return totalTime;
    }

    public int getCurrentTime() {
        return currentTime;
    }

    public void setNextUpEnabled(boolean nextUpEnabled) {
        this.nextUpEnabled = nextUpEnabled;
    }

    public boolean isNextUpEnabled() {
        return nextUpEnabled;
    }

    public class SceneTransform {

        public LerpedFloat xRotation, yRotation;

        // Screen params
        private int width, height;
        private double offset;
        private Matrix4f cachedMat;

        public SceneTransform() {
            xRotation = LerpedFloat.angular().disableSmartAngleChasing().startWithValue(-35);
            yRotation = LerpedFloat.angular().disableSmartAngleChasing().startWithValue(55 + 90);
        }

        public void tick() {
            xRotation.tickChaser();
            yRotation.tickChaser();
        }

        public void updateScreenParams(int width, int height, double offset) {
            this.width = width;
            this.height = height;
            this.offset = offset;
            cachedMat = null;
        }

        public class_4587 apply(class_4587 ms) {
            return apply(ms, AnimationTickHolder.getPartialTicks(world));
        }

        public class_4587 apply(class_4587 ms, float pt) {
            ms.method_22904(width / 2, height / 2, 200 + offset);

            ms.method_22907(class_7833.field_40714.rotationDegrees(-35));
            ms.method_22907(class_7833.field_40716.rotationDegrees(55));
            ms.method_22904(offset, 0, 0);
            ms.method_22907(class_7833.field_40716.rotationDegrees(-55));
            ms.method_22907(class_7833.field_40714.rotationDegrees(35));
            ms.method_22907(class_7833.field_40714.rotationDegrees(xRotation.getValue(pt)));
            ms.method_22907(class_7833.field_40716.rotationDegrees(yRotation.getValue(pt)));

            UIRenderHelper.flipForGuiRender(ms);
            float f = 30 * scaleFactor;
            ms.method_22905(f, f, f);
            ms.method_46416(basePlateSize / -2f - basePlateOffsetX, -1f + yOffset, basePlateSize / -2f - basePlateOffsetZ);

            return ms;
        }

        public void updateSceneRVE(float pt) {
            class_243 v = screenToScene(width / 2, height / 2, 500, pt);
            if (renderViewEntity != null)
                renderViewEntity.method_23327(v.field_1352, v.field_1351, v.field_1350);
        }

        public class_243 screenToScene(double x, double y, int depth, float pt) {
            refreshMatrix(pt);
            class_243 vec = new class_243(x, y, depth);

            vec = vec.method_1023(width / 2, height / 2, 200 + offset);
            vec = VecHelper.rotate(vec, 35, net.minecraft.class_2350.class_2351.field_11048);
            vec = VecHelper.rotate(vec, -55, net.minecraft.class_2350.class_2351.field_11052);
            vec = vec.method_1023(offset, 0, 0);
            vec = VecHelper.rotate(vec, 55, net.minecraft.class_2350.class_2351.field_11052);
            vec = VecHelper.rotate(vec, -35, net.minecraft.class_2350.class_2351.field_11048);
            vec = VecHelper.rotate(vec, -xRotation.getValue(pt), net.minecraft.class_2350.class_2351.field_11048);
            vec = VecHelper.rotate(vec, -yRotation.getValue(pt), net.minecraft.class_2350.class_2351.field_11052);

            float f = 1f / (30 * scaleFactor);

            vec = vec.method_18805(f, -f, f);
            vec = vec.method_1023(basePlateSize / -2f - basePlateOffsetX, -1f + yOffset, basePlateSize / -2f - basePlateOffsetZ);

            return vec;
        }

        public class_241 sceneToScreen(class_243 vec, float pt) {
            refreshMatrix(pt);
            Vector4f vec4 = new Vector4f((float) vec.field_1352, (float) vec.field_1351, (float) vec.field_1350, 1);
            vec4.mul(cachedMat);
            return new class_241(vec4.x(), vec4.y());
        }

        protected void refreshMatrix(float pt) {
            if (cachedMat != null)
                return;
            cachedMat = apply(new class_4587(), pt).method_23760().method_23761();
        }

    }

    public static class SceneCamera extends class_4184 {

        public void set(float xRotation, float yRotation) {
            method_19325(yRotation, xRotation);
        }

    }

}