package com.zurrtum.create.client.ponder.foundation;

import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.zurrtum.create.client.catnip.levelWrappers.WrappedClientLevel;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.class_1060;
import net.minecraft.class_11659;
import net.minecraft.class_11661;
import net.minecraft.class_11788;
import net.minecraft.class_11938;
import net.minecraft.class_11943;
import net.minecraft.class_11944;
import net.minecraft.class_11977;
import net.minecraft.class_12075;
import net.minecraft.class_12137;
import net.minecraft.class_2394;
import net.minecraft.class_310;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4604;
import net.minecraft.class_5878;
import net.minecraft.class_638;
import net.minecraft.class_702;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_7923;
import net.minecraft.client.particle.*;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

import java.util.*;
import java.util.function.Supplier;

public class PonderWorldParticles {
    private static final class_4604 FRUSTUM = new PassFrustum();
    private final class_11943 particleBatch = new class_11943();
    private final Map<class_3999, class_11938<?>> particles = Maps.newIdentityHashMap();
    private final Queue<class_703> newParticles = Queues.newArrayDeque();
    private final Object2IntOpenHashMap<class_5878> groupCounts = new Object2IntOpenHashMap<>();
    private final class_702 particleManager;
    private final class_11977.class_12051 verticesCache = new class_11977.class_12051();

    PonderLevel world;
    private final Supplier<class_638> asClientWorld = Suppliers.memoize(() -> WrappedClientLevel.of(world));

    public PonderWorldParticles(PonderLevel world) {
        this.world = world;
        this.particleManager = class_310.method_1551().field_1713;
    }

    public void addParticle(class_703 particle) {
        Optional<class_5878> optional = particle.method_34019();
        if (optional.isPresent()) {
            if (canAdd(optional.get())) {
                newParticles.add(particle);
                addTo(optional.get(), 1);
            }
        } else {
            newParticles.add(particle);
        }
    }

    private boolean canAdd(class_5878 group) {
        return groupCounts.getInt(group) < group.comp_4820();
    }

    protected void addTo(class_5878 group, int count) {
        this.groupCounts.addTo(group, count);
    }

    public void tick() {
        particles.forEach((textureSheet, particlex) -> particlex.method_74287());

        class_703 particle;
        if (!newParticles.isEmpty()) {
            while ((particle = newParticles.poll()) != null) {
                particles.computeIfAbsent(particle.method_74274(), particleManager::method_74281).method_74285(particle);
            }
        }
    }

    @Nullable
    @SuppressWarnings("unchecked")
    public <T extends class_2394> class_703 addParticle(
        T parameters,
        double x,
        double y,
        double z,
        double velocityX,
        double velocityY,
        double velocityZ
    ) {
        class_707<T> particleFactory = (class_707<T>) particleManager.field_62618.method_74292()
            .get(class_7923.field_41180.method_10206(parameters.method_10295()));
        if (particleFactory == null) {
            return null;
        }
        class_703 particle = particleFactory.method_3090(parameters, asClientWorld.get(), x, y, z, velocityX, velocityY, velocityZ, world.field_9229);
        if (particle == null) {
            return null;
        }
        addParticle(particle);
        return particle;
    }

    public void renderParticles(class_4587 ms, class_11661 queue, class_4184 camera, class_12075 cameraRenderState, float tickProgress) {
        Matrix4fStack stack = RenderSystem.getModelViewStack();
        stack.pushMatrix();
        stack.mul(ms.method_23760().method_23761());
        for (class_3999 particleTextureSheet : class_702.field_17820) {
            class_11938<?> particleRenderer = particles.get(particleTextureSheet);
            if (particleRenderer != null && !particleRenderer.method_74284()) {
                particleBatch.method_74318(particleRenderer.method_74276(FRUSTUM, camera, tickProgress));
            }
        }
        particleBatch.method_74319(queue, cameraRenderState);
        for (class_11788 commandQueue : queue.method_73532().values()) {
            List<class_11659.class_11947> commands = commandQueue.method_74330();
            if (commands.isEmpty()) {
                continue;
            }
            GpuTextureView gpuTextureView = RenderSystem.outputColorTextureOverride;
            GpuTextureView gpuTextureView2 = RenderSystem.outputDepthTextureOverride;
            class_310 mc = class_310.method_1551();
            GpuTextureView lightTextureView = mc.field_1773.method_22974().method_71650();
            class_12137 sampler = RenderSystem.getSamplerCache().method_75294(FilterMode.LINEAR);
            class_1060 textureManager = mc.method_1531();
            for (class_11659.class_11947 layeredCustom : commands) {
                class_11944.class_12041 buffers = layeredCustom.method_74755(verticesCache);
                if (buffers != null) {
                    try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(
                        () -> "Immediate draw for particle",
                        gpuTextureView,
                        OptionalInt.empty(),
                        gpuTextureView2,
                        OptionalDouble.empty()
                    )) {
                        renderPass.setUniform("Projection", RenderSystem.getProjectionMatrixBuffer());
                        renderPass.setUniform("Fog", RenderSystem.getShaderFog());
                        renderPass.bindTexture("Sampler2", lightTextureView, sampler);
                        layeredCustom.method_74324(buffers, verticesCache, renderPass, textureManager, false);
                        layeredCustom.method_74324(buffers, verticesCache, renderPass, textureManager, true);
                    }
                }
            }
            commands.clear();
        }
        stack.popMatrix();
        particleBatch.method_74317();
    }

    public void clearEffects() {
        newParticles.clear();
        groupCounts.clear();
    }

    public static class PassFrustum extends class_4604 {
        public PassFrustum() {
            super(new Matrix4f(), new Matrix4f());
        }

        @Override
        public boolean method_74404(double x, double y, double z) {
            return true;
        }
    }
}