package com.zurrtum.create.client.ponder.foundation.instruction;

import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import java.util.function.UnaryOperator;
import net.minecraft.class_2246;
import net.minecraft.class_2680;

public class ReplaceBlocksInstruction extends WorldModifyInstruction {

    private final UnaryOperator<class_2680> stateToUse;
    private final boolean replaceAir;
    private final boolean spawnParticles;

    public ReplaceBlocksInstruction(Selection selection, UnaryOperator<class_2680> stateToUse, boolean replaceAir, boolean spawnParticles) {
        super(selection);
        this.stateToUse = stateToUse;
        this.replaceAir = replaceAir;
        this.spawnParticles = spawnParticles;
    }

    @Override
    protected void runModification(Selection selection, PonderScene scene) {
        PonderLevel level = scene.getLevel();
        selection.forEach(pos -> {
            if (!level.getBounds().method_14662(pos))
                return;
            class_2680 prevState = level.method_8320(pos);
            if (!replaceAir && prevState == class_2246.field_10124.method_9564())
                return;
            if (spawnParticles)
                level.addBlockDestroyEffects(pos, prevState);
            level.method_8501(pos, stateToUse.apply(prevState));
        });
    }

    @Override
    protected boolean needsRedraw() {
        return true;
    }

}