package com.zurrtum.create.client.ponder.foundation.registration;

import com.zurrtum.create.client.ponder.api.registration.MultiSceneBuilder;
import com.zurrtum.create.client.ponder.api.registration.PonderSceneRegistrationHelper;
import com.zurrtum.create.client.ponder.api.registration.StoryBoardEntry;
import com.zurrtum.create.client.ponder.api.scene.PonderStoryBoard;
import com.zurrtum.create.client.ponder.foundation.PonderStoryBoardEntry;

import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.class_2960;

public class DefaultPonderSceneRegistrationHelper implements PonderSceneRegistrationHelper<class_2960> {

    protected String namespace;
    protected PonderSceneRegistry sceneRegistry;

    public DefaultPonderSceneRegistrationHelper(String namespace, PonderSceneRegistry sceneRegistry) {
        this.namespace = namespace;
        this.sceneRegistry = sceneRegistry;
    }

    @Override
    public <T> GenericPonderSceneRegistrationHelper<T> withKeyFunction(Function<T, class_2960> keyGen) {
        return new GenericPonderSceneRegistrationHelper<>(this, keyGen);
    }

    @Override
    public StoryBoardEntry addStoryBoard(class_2960 component, class_2960 schematicLocation, PonderStoryBoard storyBoard, class_2960... tags) {
        StoryBoardEntry entry = this.createStoryBoardEntry(storyBoard, schematicLocation, component);
        entry.highlightTags(tags);
        sceneRegistry.addStoryBoard(entry);
        return entry;
    }

    @Override
    public StoryBoardEntry addStoryBoard(class_2960 component, String schematicPath, PonderStoryBoard storyBoard, class_2960... tags) {
        return addStoryBoard(component, asLocation(schematicPath), storyBoard, tags);
    }

    @Override
    public MultiSceneBuilder forComponents(class_2960... components) {
        return new GenericMultiSceneBuilder<>(this, Arrays.asList(components));
    }

    @Override
    public MultiSceneBuilder forComponents(Iterable<? extends class_2960> components) {
        return new GenericMultiSceneBuilder<>(this, components);
    }

    @Override
    public class_2960 asLocation(String path) {
        return class_2960.method_60655(namespace, path);
    }

    private PonderStoryBoardEntry createStoryBoardEntry(PonderStoryBoard storyBoard, class_2960 schematicLocation, class_2960 component) {
        return new PonderStoryBoardEntry(storyBoard, namespace, schematicLocation, component);
    }

}