package com.zurrtum.create.client.ponder.foundation.registration;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.client.ponder.api.registration.LangRegistryAccess;
import com.zurrtum.create.client.ponder.foundation.PonderIndex;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1074;
import net.minecraft.class_2960;

public class PonderLocalization implements LangRegistryAccess {
    public static final String LANG_PREFIX = "ponder.";
    public static final String UI_PREFIX = "ui.";

    public final Map<class_2960, String> shared = new HashMap<>();
    public final Map<class_2960, Couple<String>> tag = new HashMap<>();
    public final Map<class_2960, Map<String, String>> specific = new HashMap<>();

    //

    public void clearAll() {
        shared.clear();
        tag.clear();
        specific.clear();
    }

    public void clearShared() {
        shared.clear();
    }

    public void registerShared(class_2960 key, String enUS) {
        shared.put(key, enUS);
    }

    public void registerTag(class_2960 key, String title, String description) {
        tag.put(key, Couple.create(title, description));
    }

    public void registerSpecific(class_2960 sceneId, String key, String enUS) {
        specific.computeIfAbsent(sceneId, $ -> new HashMap<>()).put(key, enUS);
    }

    //

    protected static String langKeyForShared(class_2960 k) {
        return k.method_12836() + "." + LANG_PREFIX + "shared." + k.method_12832();
    }

    protected static String langKeyForTag(class_2960 k) {
        return k.method_12836() + "." + LANG_PREFIX + "tag." + k.method_12832();
    }

    protected static String langKeyForTagDescription(class_2960 k) {
        return k.method_12836() + "." + LANG_PREFIX + "tag." + k.method_12832() + ".description";
    }

    protected static String langKeyForSpecific(class_2960 sceneId, String k) {
        return sceneId.method_12836() + "." + LANG_PREFIX + sceneId.method_12832() + "." + k;
    }

    @Override
    public String getShared(class_2960 key) {
        if (PonderIndex.editingModeActive())
            return shared.containsKey(key) ? shared.get(key) : ("unregistered shared entry: " + key);
        return class_1074.method_4662(langKeyForShared(key));
    }

    @Override
    public String getShared(class_2960 key, Object... params) {
        if (PonderIndex.editingModeActive())
            return shared.containsKey(key) ? String.format(shared.get(key), params) : ("unregistered shared entry: " + key);
        return class_1074.method_4662(langKeyForShared(key), params);
    }

    @Override
    public String getTagName(class_2960 key) {
        if (PonderIndex.editingModeActive())
            return tag.containsKey(key) ? tag.get(key).getFirst() : ("unregistered tag entry: " + key);
        return class_1074.method_4662(langKeyForTag(key));
    }

    @Override
    public String getTagDescription(class_2960 key) {
        if (PonderIndex.editingModeActive())
            return tag.containsKey(key) ? tag.get(key).getSecond() : ("unregistered tag entry: " + key);
        return class_1074.method_4662(langKeyForTagDescription(key));
    }

    @Override
    public String getSpecific(class_2960 sceneId, String k) {
        if (PonderIndex.editingModeActive())
            try {
                return specific.get(sceneId).get(k);
            } catch (Exception e) {
                return "MISSING_SPECIFIC";
            }
        return class_1074.method_4662(langKeyForSpecific(sceneId, k));
    }

    @Override
    public String getSpecific(class_2960 sceneId, String k, Object... params) {
        if (PonderIndex.editingModeActive())
            try {
                return String.format(specific.get(sceneId).get(k), params);
            } catch (Exception e) {
                return "MISSING_SPECIFIC";
            }
        return class_1074.method_4662(langKeyForSpecific(sceneId, k), params);
    }
}
