package com.zurrtum.create.client.ponder.foundation.render;

import com.zurrtum.create.client.catnip.gui.UIRenderHelper;
import com.zurrtum.create.client.catnip.lang.ClientFontHelper;
import net.minecraft.class_11239;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7833;

public class TitleTextRenderer extends class_11239<TitleTextRenderState> {
    public TitleTextRenderer(class_4597.class_4598 vertexConsumers) {
        super(vertexConsumers);
    }

    @Override
    protected void renderToTexture(TitleTextRenderState state, class_4587 matrices) {
        matrices.method_22905(1, 1, -1);
        matrices.method_46416(-90, -20, 0);
        class_327 font = class_310.method_1551().field_1772;
        float indexDiff = state.diff();
        float absoluteIndexDiff = Math.abs(indexDiff);
        float angle = indexDiff * -90;
        matrices.method_46416(0, 6, 0);
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40713.rotationDegrees(angle + Math.signum(indexDiff) * 90));
        matrices.method_46416(0, -6, 5);
        ClientFontHelper.drawSplitString(
            field_59933,
            matrices,
            font,
            state.otherTitle(),
            0,
            0,
            180,
            UIRenderHelper.COLOR_TEXT.getFirst().scaleAlphaForText(absoluteIndexDiff).getRGB()
        );
        matrices.method_22909();

        matrices.method_22907(class_7833.field_40713.rotationDegrees(angle));
        matrices.method_46416(0, -6, 5);
        ClientFontHelper.drawSplitString(
            field_59933,
            matrices,
            font,
            state.title(),
            0,
            0,
            180,
            UIRenderHelper.COLOR_TEXT.getFirst().scaleAlphaForText(1 - absoluteIndexDiff).getRGB()
        );
    }

    @Override
    protected String method_70906() {
        return "Title Text";
    }

    @Override
    public Class<TitleTextRenderState> method_70903() {
        return TitleTextRenderState.class;
    }
}
