package com.zurrtum.create.client.ponder.foundation.ui;

import com.google.common.graph.ElementOrder;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.animation.LerpedFloat.Chaser;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.catnip.registry.RegisteredObjectsHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.NavigatableSimiScreen;
import com.zurrtum.create.client.catnip.gui.ScreenOpener;
import com.zurrtum.create.client.catnip.gui.UIRenderHelper;
import com.zurrtum.create.client.catnip.gui.element.BoxElement;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement.GuiItemRenderBuilder;
import com.zurrtum.create.client.catnip.gui.widget.BoxWidget;
import com.zurrtum.create.client.catnip.lang.ClientFontHelper;
import com.zurrtum.create.client.ponder.Ponder;
import com.zurrtum.create.client.ponder.api.registration.StoryBoardEntry;
import com.zurrtum.create.client.ponder.api.registration.StoryBoardEntry.SceneOrderingEntry;
import com.zurrtum.create.client.ponder.api.registration.StoryBoardEntry.SceneOrderingType;
import com.zurrtum.create.client.ponder.enums.PonderConfig;
import com.zurrtum.create.client.ponder.enums.PonderGuiTextures;
import com.zurrtum.create.client.ponder.foundation.*;
import com.zurrtum.create.client.ponder.foundation.PonderScene.SceneTransform;
import com.zurrtum.create.client.ponder.foundation.content.DebugScenes;
import com.zurrtum.create.client.ponder.foundation.element.TextWindowElement;
import com.zurrtum.create.client.ponder.foundation.render.SceneRenderState;
import com.zurrtum.create.client.ponder.foundation.render.TitleTextRenderState;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;

import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_1041;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3674;
import net.minecraft.class_5250;

public class PonderUI extends AbstractPonderScreen {

    public static int ponderTicks;
    public static float ponderPartialTicksPaused;

    public static final Color BACKGROUND_TRANSPARENT = new Color(0xdd_000000, true);
    public static final Color BACKGROUND_FLAT = new Color(0xff_000000, true);
    public static final Color BACKGROUND_IMPORTANT = new Color(0xdd_0e0e20, true);

    public static final Couple<Color> COLOR_IDLE = Couple.create(new Color(0x40_ffeedd, true), new Color(0x20_ffeedd, true)).map(Color::setImmutable);
    public static final Couple<Color> COLOR_HOVER = Couple.create(new Color(0x70_ffffff, true), new Color(0x30_ffffff, true))
        .map(Color::setImmutable);
    public static final Couple<Color> COLOR_HIGHLIGHT = Couple.create(new Color(0xf0_ffeedd, true), new Color(0x60_ffeedd, true))
        .map(Color::setImmutable);
    public static final Couple<Color> MISSING_VANILLA_ENTRY = Couple.create(new Color(0x50_5000ff, true), new Color(0x50_28007f, true))
        .map(Color::setImmutable);
    public static final Couple<Color> MISSING_MODDED_ENTRY = Couple.create(new Color(0x70_984500, true), new Color(0x70_692400, true))
        .map(Color::setImmutable);

    private final List<PonderScene> scenes;
    private final List<PonderTag> tags;
    private List<PonderButton> tagButtons = new ArrayList<>();
    private List<LerpedFloat> tagFades = new ArrayList<>();
    private final LerpedFloat fadeIn;
    class_1799 stack;
    GuiItemRenderBuilder itemRender;
    @Nullable PonderChapter chapter = null;

    private boolean userViewMode;
    private boolean identifyMode;
    private class_1799 hoveredTooltipItem = class_1799.field_8037;
    @Nullable
    private class_2338 hoveredBlockPos;

    private final class_3674 clipboardHelper;
    @Nullable
    private class_2338 copiedBlockPos;

    private final LerpedFloat finishingFlash;
    private final LerpedFloat nextUp;
    private int finishingFlashWarmup = 0;
    private int nextUpWarmup = 0;

    private final LerpedFloat lazyIndex;
    private int index = 0;
    @Nullable
    private PonderTag referredToByTag;

    private PonderButton left, right, scan, chap, userMode, close, replay, slowMode;
    private int skipCooling = 0;

    private int extendedTickLength = 0;
    private int extendedTickTimer = 0;

    public static PonderUI of(class_2960 id) {
        return new PonderUI(PonderIndex.getSceneAccess().compile(id));
    }

    public static PonderUI of(class_1799 item) {
        return new PonderUI(PonderIndex.getSceneAccess().compile(RegisteredObjectsHelper.getKeyOrThrow(item.method_7909())));
    }

    public static PonderUI of(class_1799 item, PonderTag tag) {
        PonderUI ponderUI = new PonderUI(PonderIndex.getSceneAccess().compile(RegisteredObjectsHelper.getKeyOrThrow(item.method_7909())));
        ponderUI.referredToByTag = tag;
        return ponderUI;
    }

    protected PonderUI(List<PonderScene> scenes) {
        class_2960 location = scenes.get(0).getLocation();
        stack = new class_1799(RegisteredObjectsHelper.getItemOrBlock(location));
        itemRender = GuiGameElement.of(stack).scale(2).at(-35, 1);

        tags = new ArrayList<>(PonderIndex.getTagAccess().getTags(location));

        Ponder.LOGGER.debug("Ponder Scenes before ordering: {}", Arrays.toString(scenes.stream().map(PonderScene::getId).toArray()));

        List<PonderScene> orderedScenes;
        try {
            orderedScenes = orderScenes(scenes);
            Ponder.LOGGER.debug("Ponder Scenes after ordering: {}", Arrays.toString(orderedScenes.stream().map(PonderScene::getId).toArray()));
        } catch (Exception e) {
            Ponder.LOGGER.warn("Unable to sort PonderScenes, using unordered List", e);
            orderedScenes = scenes;
        }
        this.scenes = orderedScenes;

        if (this.scenes.isEmpty()) {
            List<StoryBoardEntry> list = Collections.singletonList(new PonderStoryBoardEntry(
                DebugScenes::empty,
                Ponder.MOD_ID,
                "debug/scene_1",
                class_2960.method_60654("stick")
            ));
            this.scenes.addAll(PonderIndex.getSceneAccess().compile(list));
        }
        lazyIndex = LerpedFloat.linear().startWithValue(index);
        fadeIn = LerpedFloat.linear().startWithValue(0).chase(1, .1f, Chaser.EXP);
        clipboardHelper = new class_3674();
        finishingFlash = LerpedFloat.linear().startWithValue(0).chase(0, .1f, Chaser.EXP);
        nextUp = LerpedFloat.linear().startWithValue(0).chase(0, .4f, Chaser.EXP);
    }

    @SuppressWarnings("UnstableApiUsage")
    private List<PonderScene> orderScenes(List<PonderScene> scenes) {
        Map<Boolean, List<PonderScene>> partitioned = scenes.stream()
            .collect(Collectors.partitioningBy(scene -> scene.getOrderingEntries().isEmpty()));

        List<PonderScene> scenesWithOrdering = partitioned.get(false);
        List<PonderScene> scenesWithoutOrdering = partitioned.get(true);

        if (scenesWithOrdering.isEmpty())
            return scenes;

        List<PonderScene> sceneList = new ArrayList<>(scenes);
        Collections.reverse(sceneList);

        Map<class_2960, PonderScene> sceneLookup = scenes.stream().collect(Collectors.toMap(PonderScene::getId, scene -> scene));

        MutableGraph<PonderScene> graph = GraphBuilder.directed().nodeOrder(ElementOrder.insertion()).build();
        sceneList.forEach(graph::addNode);

        IntStream.range(1, scenesWithoutOrdering.size()).forEach(i -> graph.putEdge(scenesWithoutOrdering.get(i - 1), scenesWithoutOrdering.get(i)));

        scenesWithOrdering.forEach(scene -> {
            List<SceneOrderingEntry> relevantOrderings = scene.getOrderingEntries().stream()
                .filter(entry -> scenes.stream().anyMatch(sc -> sc.getId().equals(entry.sceneId()))).toList();

            if (relevantOrderings.isEmpty())
                return;

            relevantOrderings.forEach(entry -> {
                PonderScene otherScene = sceneLookup.get(entry.sceneId());
                if (entry.type() == SceneOrderingType.BEFORE) {
                    graph.putEdge(scene, otherScene);
                } else if (entry.type() == SceneOrderingType.AFTER) {
                    graph.putEdge(otherScene, scene);
                }
            });
        });

        return topologicalSort(graph);

		/*sceneList.sort((scene1, scene2) -> {
			boolean hasOrderings1 = !scene1.getOrderingEntries().isEmpty();
			boolean hasOrderings2 = !scene2.getOrderingEntries().isEmpty();

			if (!hasOrderings1 && !hasOrderings2)
				return 0;

			Map<SceneOrderingType, Long> relevantOrderings1 = scene1.getOrderingEntries()
					.stream()
					.filter(entry -> entry.sceneId().equals(scene2.getId()))
					.collect(Collectors.groupingBy(SceneOrderingEntry::type, Collectors.counting()));

			Map<SceneOrderingType, Long> relevantOrderings2 = scene2.getOrderingEntries()
					.stream()
					.filter(entry -> entry.sceneId().equals(scene1.getId()))
					.collect(Collectors.groupingBy(SceneOrderingEntry::type, Collectors.counting()));

			// both scenes don't want to be ordered compared to each other
			if (relevantOrderings1.isEmpty() && relevantOrderings2.isEmpty())
				return 0;

			// only scene2 wants to be ordered either before or after scene1
			if (relevantOrderings1.isEmpty())
				return relevantOrderings2.containsKey(SceneOrderingType.AFTER) ? -1 : 1;

			// only scene1 wants to be ordered either before or after scene2
			if (relevantOrderings2.isEmpty())
				return relevantOrderings1.containsKey(SceneOrderingType.AFTER) ? 1 : -1;

			// both scenes want scene1 to be ordered after scene2
			if (relevantOrderings1.containsKey(SceneOrderingType.AFTER) && relevantOrderings2.containsKey(SceneOrderingType.BEFORE))
				return 1;

			// both scenes want scene1 to be ordered before scene2
			if (relevantOrderings1.containsKey(SceneOrderingType.BEFORE) && relevantOrderings2.containsKey(SceneOrderingType.AFTER))
				return -1;

			// everything else is contradictory so we ignore it
			return 0;
		});

		return sceneList;*/
    }

    private static List<PonderScene> topologicalSort(MutableGraph<PonderScene> graph) {
        List<PonderScene> result = new ArrayList<>();
        Set<PonderScene> visited = new HashSet<>();
        Set<PonderScene> currentlyVisiting = new HashSet<>();

        for (PonderScene node : graph.nodes()) {
            if (!visited.contains(node)) {
                if (!dfs(node, graph, visited, currentlyVisiting, result)) {
                    throw new IllegalArgumentException("Graph has a cycle!");
                }
            }
        }

        Collections.reverse(result);
        return result;
    }

    private static boolean dfs(
        PonderScene node,
        MutableGraph<PonderScene> graph,
        Set<PonderScene> visited,
        Set<PonderScene> currentlyVisiting,
        List<PonderScene> result
    ) {
        if (currentlyVisiting.contains(node)) {
            return false; // Detected a cycle
        }

        if (!visited.contains(node)) {
            currentlyVisiting.add(node);
            for (PonderScene neighbor : graph.successors(node)) {
                if (!dfs(neighbor, graph, visited, currentlyVisiting, result)) {
                    return false; // Detected a cycle
                }
            }
            currentlyVisiting.remove(node);
            visited.add(node);
            result.add(node);
        }

        return true;
    }

    @Override
    protected void method_25426() {
        super.method_25426();

        tagButtons = new ArrayList<>();
        tagFades = new ArrayList<>();

        tags.forEach(t -> {
            int i = tagButtons.size();
            int x = 31;
            int y = 81 + i * 30;

            PonderButton b2 = new PonderButton(x, y).showing(t).withCallback((mX, mY) -> {
                centerScalingOn(mX, mY);
                ScreenOpener.transitionTo(new PonderTagScreen(t));
            });

            method_37063(b2);
            tagButtons.add(b2);

            LerpedFloat chase = LerpedFloat.linear().startWithValue(0).chase(0, .05f, Chaser.exp(.1));
            tagFades.add(chase);

        });

        /*
         * if (chapter != null) { widgets.add(chap = new PonderButton(width - 31 - 24,
         * 31, () -> { }).showing(chapter)); }
         */

        class_315 bindings = field_22787.field_1690;
        int spacing = 8;
        int bX = (field_22789 - 20) / 2 - (70 + 2 * spacing);
        int bY = field_22790 - 20 - 31;

        {
            int pX = (field_22789 / 2) - 110;
            int pY = bY + 20 + 4;
            int pW = field_22789 - 2 * pX;
            method_37063(new PonderProgressBar(this, pX, pY, pW, 1));
        }

        method_37063(scan = new PonderButton(bX, bY).withShortcut(bindings.field_1869).showing(PonderGuiTextures.ICON_PONDER_IDENTIFY)
            .enableFade(0, 5).withCallback(() -> {
                identifyMode = !identifyMode;
                if (!identifyMode)
                    scenes.get(index).deselect();
                else
                    ponderPartialTicksPaused = AnimationTickHolder.getPartialTicksUI(field_22787.method_61966());
            }));
        scan.atZLevel(600);

        method_37063(slowMode = new PonderButton(field_22789 - 20 - 31, bY).showing(PonderGuiTextures.ICON_PONDER_SLOW_MODE).enableFade(0, 5)
            .withCallback(() -> setComfyReadingEnabled(!isComfyReadingEnabled())));

        if (PonderIndex.editingModeActive()) {
            method_37063(userMode = new PonderButton(field_22789 - 50 - 31, bY).showing(PonderGuiTextures.ICON_PONDER_USER_MODE).enableFade(0, 5)
                .withCallback(() -> userViewMode = !userViewMode));
        }

        bX += 50 + spacing;
        method_37063(left = new PonderButton(bX, bY).withShortcut(bindings.field_1913).showing(PonderGuiTextures.ICON_PONDER_LEFT)
            .enableFade(0, 5).withCallback(() -> this.scroll(false)));

        bX += 20 + spacing;
        method_37063(close = new PonderButton(bX, bY).withShortcut(bindings.field_1822).showing(PonderGuiTextures.ICON_PONDER_CLOSE)
            .enableFade(0, 5).withCallback(this::method_25419));

        bX += 20 + spacing;
        method_37063(right = new PonderButton(bX, bY).withShortcut(bindings.field_1849).showing(PonderGuiTextures.ICON_PONDER_RIGHT)
            .enableFade(0, 5).withCallback(() -> this.scroll(true)));

        bX += 50 + spacing;
        method_37063(replay = new PonderButton(bX, bY).withShortcut(bindings.field_1881).showing(PonderGuiTextures.ICON_PONDER_REPLAY)
            .enableFade(0, 5).withCallback(this::replay));
    }

    @Override
    protected void initBackTrackIcon(BoxWidget backTrack) {
        backTrack.showingElement(GuiGameElement.of(stack).scale(1.5f).at(-4, -4));
    }

    @Override
    public void method_25393() {
        super.method_25393();

        if (skipCooling > 0)
            skipCooling--;

        if (referredToByTag != null) {
            for (int i = 0; i < scenes.size(); i++) {
                PonderScene ponderScene = scenes.get(i);
                if (!ponderScene.getTags().contains(referredToByTag))
                    continue;
                if (i == index)
                    break;
                scenes.get(index).fadeOut();
                index = i;
                scenes.get(index).begin();
                lazyIndex.chase(index, 1 / 4f, Chaser.EXP);
                identifyMode = false;
                break;
            }
            referredToByTag = null;
        }

        lazyIndex.tickChaser();
        fadeIn.tickChaser();
        finishingFlash.tickChaser();
        nextUp.tickChaser();
        PonderScene activeScene = scenes.get(index);

        extendedTickLength = 0;
        if (isComfyReadingEnabled())
            activeScene.forEachVisible(TextWindowElement.class, twe -> extendedTickLength = 2);

        if (extendedTickTimer == 0) {
            if (!identifyMode) {
                ponderTicks++;
                if (skipCooling == 0)
                    activeScene.tick();
            }

            if (!identifyMode) {
                float lazyIndexValue = lazyIndex.getValue();
                if (Math.abs(lazyIndexValue - index) > 1 / 512f)
                    scenes.get(lazyIndexValue < index ? index - 1 : index + 1).tick();
            }
            extendedTickTimer = extendedTickLength;
        } else
            extendedTickTimer--;

        if (activeScene.getCurrentTime() == activeScene.getTotalTime() - 1) {
            finishingFlashWarmup = 30;
            nextUpWarmup = 50;
        }

        if (finishingFlashWarmup > 0) {
            finishingFlashWarmup--;
            if (finishingFlashWarmup == 0) {
                finishingFlash.setValue(1);
                finishingFlash.setValue(1);
            }
        }

        if (nextUpWarmup > 0) {
            nextUpWarmup--;
            if (nextUpWarmup == 0)
                nextUp.updateChaseTarget(1);
        }

        updateIdentifiedItem(activeScene);
    }

    public PonderScene getActiveScene() {
        return scenes.get(index);
    }

    public void seekToTime(int time) {
        if (getActiveScene().getCurrentTime() > time)
            replay();

        getActiveScene().seekToTime(time);
        if (time != 0)
            coolDownAfterSkip();
    }

    public void updateIdentifiedItem(PonderScene activeScene) {
        hoveredTooltipItem = class_1799.field_8037;
        hoveredBlockPos = null;
        if (!identifyMode)
            return;

        class_1041 w = field_22787.method_22683();
        double mouseX = field_22787.field_1729.method_1603() * w.method_4486() / w.method_4480();
        double mouseY = field_22787.field_1729.method_1604() * w.method_4502() / w.method_4507();
        SceneTransform t = activeScene.getTransform();
        class_243 vec1 = t.screenToScene(mouseX, mouseY, 1000, 0);
        class_243 vec2 = t.screenToScene(mouseX, mouseY, -100, 0);
        Pair<class_1799, class_2338> pair = activeScene.rayTraceScene(vec1, vec2);
        hoveredTooltipItem = pair.getFirst();
        hoveredBlockPos = pair.getSecond();
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (scroll(scrollY > 0))
            return true;
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    protected void replay() {
        identifyMode = false;
        PonderScene scene = scenes.get(index);

        if (AllKeys.hasShiftDown()) {
            PonderIndex.reload();
            this.scenes.clear();
            this.scenes.addAll(PonderIndex.getSceneAccess().compile(scene.getLocation()));


			/*PonderScene finalScene = scene;
			List<PonderStoryBoardEntry> list = PonderIndex.getSceneAccess().getRegisteredEntries().stream().filter(
					entry -> entry.getKey() == finalScene.getLocation()).map(Map.Entry::getValue).toList();
			PonderStoryBoardEntry sb = list.get(index);
			StructureTemplate activeTemplate = PonderSceneRegistry.loadSchematic(sb.getSchematicLocation());
			PonderLevel world = new PonderLevel(BlockPos.ZERO, Minecraft.getInstance().level);
			activeTemplate.placeInWorld(world, BlockPos.ZERO, BlockPos.ZERO, new StructurePlaceSettings(),
										RandomSource.create(), Block.UPDATE_CLIENTS);
			world.createBackup();
			scene = PonderSceneRegistry.compileScene(scene.localization, sb, world);
			scene.begin();
			this.scenes.set(index, scene);*/
        }

        scene.begin();
    }

    protected boolean scroll(boolean forward) {
        int prevIndex = index;
        index = forward ? index + 1 : index - 1;
        index = class_3532.method_15340(index, 0, scenes.size() - 1);
        if (prevIndex != index) {// && Math.abs(index - lazyIndex.getValue()) < 1.5f) {
            scenes.get(prevIndex).fadeOut();
            scenes.get(index).begin();
            lazyIndex.chase(index, 1 / 4f, Chaser.EXP);
            identifyMode = false;
            return true;
        } else
            index = prevIndex;
        return false;
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWindow(graphics, mouseX, mouseY, partialTicks);
        partialTicks = getPartialTicks();
        renderVisibleScenes(graphics, mouseX, mouseY, skipCooling > 0 ? 0 : identifyMode ? ponderPartialTicksPaused : partialTicks);
        renderWidgets(graphics, mouseX, mouseY, identifyMode ? ponderPartialTicksPaused : partialTicks);
    }

    protected void renderVisibleScenes(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        class_1041 window = graphics.field_44656.method_22683();
        float uiTicks = lazyIndex.getValue(AnimationTickHolder.getPartialTicksUI(field_22787.method_61966()));// TODO - Checkover
        renderScene(graphics, 0, window, index, partialTicks, uiTicks);
        float lazyIndexValue = lazyIndex.getValue(partialTicks);
        if (Math.abs(lazyIndexValue - index) > 1 / 512f)
            renderScene(graphics, 1, window, lazyIndexValue < index ? index - 1 : index + 1, partialTicks, uiTicks);
    }

    protected void renderScene(class_332 graphics, int id, class_1041 window, int i, float partialTicks, float uiTicks) {
        double diff = i - uiTicks;
        double slide = class_3532.method_16436(diff * diff, 200, 600) * diff;
        PonderScene scene = scenes.get(i);
        graphics.field_59826.method_70922(new SceneRenderState(
            id,
            scene,
            field_22789,
            field_22790,
            slide,
            userViewMode,
            finishingFlash,
            partialTicks,
            window,
            new Matrix3x2f(graphics.method_51448())
        ));
    }

    protected void renderWidgets(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        float fade = fadeIn.getValue(partialTicks);
        float lazyIndexValue = lazyIndex.getValue(partialTicks);
        float indexDiff = lazyIndexValue - index;
        PonderScene activeScene = scenes.get(index);
        PonderScene nextScene = scenes.size() > index + 1 ? scenes.get(index + 1) : null;

        boolean noWidgetsHovered = true;
        for (class_364 child : method_25396())
            noWidgetsHovered &= !child.method_25405(mouseX, mouseY);

        int tooltipColor = UIRenderHelper.COLOR_TEXT_DARKER.getFirst().getRGB();
        renderSceneInformation(graphics, fade, indexDiff, activeScene, tooltipColor);

        Matrix3x2fStack ms = graphics.method_51448();

        class_310 mc = class_310.method_1551();
        if (identifyMode) {
            if (noWidgetsHovered && mouseY < field_22790 - 80) {
                if (hoveredTooltipItem.method_7960()) {

                    class_5250 text = Ponder.lang().translate(
                        AbstractPonderScreen.IDENTIFY_MODE,
                        ((class_5250) field_22787.field_1690.field_1869.method_16007()).method_27692(class_124.field_1068)
                    ).style(class_124.field_1080).component();

                    List<class_2561> tooltipLines = field_22793.method_27527().method_27495(text, field_22789 / 3, class_2583.field_24360).stream()
                        .map(t -> (class_2561) class_2561.method_43470(t.getString())).toList();
                    graphics.method_51434(field_22793, tooltipLines, mouseX, mouseY);
                } else
                    graphics.method_51446(field_22793, hoveredTooltipItem, mouseX, mouseY);
                if (hoveredBlockPos != null && PonderIndex.editingModeActive() && !userViewMode) {
                    boolean copied = hoveredBlockPos.equals(copiedBlockPos);
                    class_5250 coords = class_2561.method_43470(hoveredBlockPos.method_10263() + ", " + hoveredBlockPos.method_10264() + ", " + hoveredBlockPos.method_10260())
                        .method_27692(copied ? class_124.field_1060 : class_124.field_1065);
                    graphics.method_51438(field_22793, coords, 0, -15);
                }
            }
            scan.flash();
        } else {
            scan.dim();
        }

        if (PonderIndex.editingModeActive()) {
            if (userViewMode)
                userMode.flash();
            else
                userMode.dim();
        }

        if (isComfyReadingEnabled())
            slowMode.flash();
        else
            slowMode.dim();

        renderSceneOverlay(graphics, partialTicks, lazyIndexValue, Math.abs(indexDiff));

        renderNextUp(graphics, partialTicks, nextScene);

        // Widgets
        getRenderables().forEach(w -> {
            if (w instanceof PonderButton button) {
                button.fade().startWithValue(fade);
            }
        });

        if (index == 0 || index == 1 && lazyIndexValue < index)
            left.fade().startWithValue(lazyIndexValue);
        if (index == scenes.size() - 1 || index == scenes.size() - 2 && lazyIndexValue > index)
            right.fade().startWithValue(scenes.size() - lazyIndexValue - 1);

        if (activeScene.isFinished())
            right.flash();
        else {
            right.dim();
            nextUp.updateChaseTarget(0);
        }

        // Arrows behind the main widgets
        Color c1 = COLOR_NAV_ARROW.getFirst().setAlpha(0x40);
        Color c2 = COLOR_NAV_ARROW.getFirst().setAlpha(0x20);
        Color c3 = COLOR_NAV_ARROW.getFirst().setAlpha(0x10);
        UIRenderHelper.breadcrumbArrow(graphics, field_22789 / 2 - 20, field_22790 - 51, 20, 20, 5, c1, c2);
        UIRenderHelper.breadcrumbArrow(graphics, field_22789 / 2 + 20, field_22790 - 51, -20, 20, -5, c1, c2);
        UIRenderHelper.breadcrumbArrow(graphics, field_22789 / 2 - 90, field_22790 - 51, 70, 20, 5, c1, c3);
        UIRenderHelper.breadcrumbArrow(graphics, field_22789 / 2 + 90, field_22790 - 51, -70, 20, -5, c1, c3);

        // Tags
        List<PonderTag> sceneTags = activeScene.getTags();
        boolean highlightAll = sceneTags.stream().anyMatch(tag -> tag.getId() == PonderTag.Highlight.ALL);
        double s = mc.method_22683().method_4495();
        IntStream.range(0, tagButtons.size()).forEach(i -> {
            ms.pushMatrix();
            PonderTag tag = this.tags.get(i);
            LerpedFloat chase = tagFades.get(i);
            PonderButton button = tagButtons.get(i);
            if (button.method_25405(mouseX, mouseY)) {
                chase.updateChaseTarget(1);
            } else
                chase.updateChaseTarget(0);

            chase.tickChaser();

            if (highlightAll || sceneTags.contains(tag))
                button.flash();
            else
                button.dim();

            int x = button.method_46426() + button.method_25368() + 4;
            int y = button.method_46427() - 2;
            ms.translate(x, y + 5 * (1 - fade));

            float fadedWidth = 200 * chase.getValue(partialTicks);
            UIRenderHelper.streak(graphics, 0, 0, 12, 26, (int) fadedWidth);

            //            graphics.enableScissor(x, 0, (int) fadedWidth, height);

            graphics.method_44379(0, 8, (int) fadedWidth, 8 + field_22790);
            String tagName = tag.getTitle();
            graphics.method_51433(field_22793, tagName, 3, 8, UIRenderHelper.COLOR_TEXT_ACCENT.getFirst().getRGB(), false);

            graphics.method_44380();

            ms.popMatrix();
        });

        renderHoverTooltips(graphics, tooltipColor);
    }

    private void renderHoverTooltips(class_332 graphics, int tooltipColor) {
        int tooltipY = field_22790 - 16;
        if (scan.method_25367())
            graphics.method_27534(
                field_22793,
                Ponder.lang().translate(AbstractPonderScreen.IDENTIFY).component(),
                scan.method_46426() + 10,
                tooltipY,
                tooltipColor
            );
        if (index != 0 && left.method_25367())
            graphics.method_27534(
                field_22793,
                Ponder.lang().translate(AbstractPonderScreen.PREVIOUS).component(),
                left.method_46426() + 10,
                tooltipY,
                tooltipColor
            );
        if (close.method_25367())
            graphics.method_27534(
                field_22793,
                Ponder.lang().translate(AbstractPonderScreen.CLOSE).component(),
                close.method_46426() + 10,
                tooltipY,
                tooltipColor
            );
        if (index != scenes.size() - 1 && right.method_25367())
            graphics.method_27534(
                field_22793,
                Ponder.lang().translate(AbstractPonderScreen.NEXT).component(),
                right.method_46426() + 10,
                tooltipY,
                tooltipColor
            );
        if (replay.method_25367())
            graphics.method_27534(
                field_22793,
                Ponder.lang().translate(AbstractPonderScreen.REPLAY).component(),
                replay.method_46426() + 10,
                tooltipY,
                tooltipColor
            );
        if (slowMode.method_25367())
            graphics.method_27534(
                field_22793,
                Ponder.lang().translate(AbstractPonderScreen.SLOW_TEXT).component(),
                slowMode.method_46426() + 5,
                tooltipY,
                tooltipColor
            );
        if (PonderIndex.editingModeActive() && userMode.method_25367())
            graphics.method_25300(field_22793, "Editor View", userMode.method_46426() + 10, tooltipY, tooltipColor);
    }

    private void renderNextUp(class_332 graphics, float partialTicks, @Nullable PonderScene nextScene) {
        if (!getActiveScene().isFinished())
            return;

        if (nextScene == null || !nextScene.isNextUpEnabled())
            return;

        if (!(nextUp.getValue() > 1 / 16f))
            return;

        Matrix3x2fStack poseStack = graphics.method_51448();
        poseStack.pushMatrix();
        poseStack.translate(right.method_46426() + 10, right.method_46427() - 6 + nextUp.getValue(partialTicks) * 5);
        class_5250 nextUpComponent = Ponder.lang().translate(AbstractPonderScreen.NEXT_UP).component();
        int boxWidth = (Math.max(field_22793.method_1727(nextScene.getTitle()), field_22793.method_27525(nextUpComponent)) + 5);
        renderSpeechBox(graphics, 0, 0, boxWidth, 20, right.method_25367(), Pointing.DOWN, false);
        poseStack.translate(0, -29);
        graphics.method_27534(field_22793, nextUpComponent, 0, 0, UIRenderHelper.COLOR_TEXT_DARKER.getFirst().getRGB());
        graphics.method_25300(field_22793, nextScene.getTitle(), 0, 10, UIRenderHelper.COLOR_TEXT.getFirst().getRGB());
        poseStack.popMatrix();
    }

    private void renderSceneOverlay(class_332 graphics, float partialTicks, float lazyIndexValue, float indexDiff) {
        // Scene overlay
        float scenePT = skipCooling > 0 ? 0 : partialTicks;
        renderOverlay(graphics, index, scenePT);
        if (indexDiff > 1 / 512f)
            renderOverlay(graphics, lazyIndexValue < index ? index - 1 : index + 1, scenePT);
    }

    private void renderSceneInformation(class_332 graphics, float fade, float indexDiff, PonderScene activeScene, int tooltipColor) {
        float absoluteIndexDiff = Math.abs(indexDiff);
        // info includes icon, scene title and the "Pondering about... " text

        int otherIndex = index;
        if (scenes.size() != 1 && absoluteIndexDiff >= 0.01) {
            float indexOffset = Math.signum(indexDiff);
            otherIndex = index + (int) indexOffset;
            if (otherIndex < 0 || otherIndex >= scenes.size()) {
                return; // should never be reached
            }
        }

        String title = activeScene.getTitle();
        String otherTitle = scenes.get(otherIndex).getTitle();

        int maxTitleWidth = 180;

        int titleWidth = field_22793.method_1727(title);
        if (titleWidth > maxTitleWidth)
            titleWidth = maxTitleWidth;

        int otherTitleWidth = field_22793.method_1727(otherTitle);
        if (otherTitleWidth > maxTitleWidth)
            otherTitleWidth = maxTitleWidth;

        int wrappedTitleHeight = field_22793.method_44378(class_2561.method_43470(title), maxTitleWidth);
        int otherWrappedTitleHeight = field_22793.method_44378(class_2561.method_43470(otherTitle), maxTitleWidth);

        // height is ideal for single line titles
        int streakHeight = 35 - 9 + class_3532.method_48781(absoluteIndexDiff, wrappedTitleHeight, otherWrappedTitleHeight);
        int streakWidth = 70 + class_3532.method_48781(absoluteIndexDiff, titleWidth, otherTitleWidth);

        Matrix3x2fStack poseStack = graphics.method_51448();
        poseStack.pushMatrix();
        // translate to top left of the background streak
        poseStack.translate(55, 19);

        // background streak
        UIRenderHelper.streak(graphics, 0, 0, streakHeight / 2, streakHeight, (int) (streakWidth * fade));
        UIRenderHelper.streak(graphics, 180, 0, streakHeight / 2, streakHeight, (int) (30 * fade));

        // icon
        new BoxElement().withBackground(PonderUI.BACKGROUND_FLAT).gradientBorder(COLOR_IDLE).at(-34, 2, 100).withBounds(30, 30).render(graphics);

        itemRender.render(graphics);

        // pondering about text
        poseStack.translate(4, 6);
        graphics.method_51439(field_22793, Ponder.lang().translate(AbstractPonderScreen.PONDERING).component(), 0, 0, tooltipColor, false);

        // scene title
        poseStack.translate(0, 14);

        // short version for single scene views
        if (scenes.size() == 1 || absoluteIndexDiff < 0.01) {
            ClientFontHelper.drawSplitString(
                graphics,
                field_22793,
                title,
                0,
                0,
                maxTitleWidth,
                UIRenderHelper.COLOR_TEXT.getFirst().scaleAlphaForText(fade).getRGB()
            );

            poseStack.popMatrix();
            return;
        }

        graphics.field_59826.method_70922(new TitleTextRenderState(new Matrix3x2f(poseStack), 0, 0, indexDiff, title, otherTitle));
        poseStack.popMatrix();
    }

    private void renderOverlay(class_332 graphics, int i, float partialTicks) {
        if (identifyMode)
            return;
        Matrix3x2fStack matrices = graphics.method_51448();
        matrices.pushMatrix();
        PonderScene story = scenes.get(i);
        story.renderOverlay(this, graphics, skipCooling > 0 ? 0 : identifyMode ? ponderPartialTicksPaused : partialTicks);
        matrices.popMatrix();
    }

    @Override
    public boolean method_25402(class_11909 click, boolean doubled) {
        if (identifyMode && hoveredBlockPos != null && PonderIndex.editingModeActive()) {
            class_1041 window = field_22787.method_22683();
            if (copiedBlockPos != null && click.method_74245() == 1) {
                clipboardHelper.method_15979(
                    window,
                    "util.select().fromTo(" + copiedBlockPos.method_10263() + ", " + copiedBlockPos.method_10264() + ", " + copiedBlockPos.method_10260() + ", " + hoveredBlockPos.method_10263() + ", " + hoveredBlockPos.method_10264() + ", " + hoveredBlockPos.method_10260() + ")"
                );
                copiedBlockPos = hoveredBlockPos;
                return true;
            }

            if (AllKeys.hasShiftDown())
                clipboardHelper.method_15979(
                    window,
                    "util.select().position(" + hoveredBlockPos.method_10263() + ", " + hoveredBlockPos.method_10264() + ", " + hoveredBlockPos.method_10260() + ")"
                );
            else
                clipboardHelper.method_15979(
                    window,
                    "util.grid().at(" + hoveredBlockPos.method_10263() + ", " + hoveredBlockPos.method_10264() + ", " + hoveredBlockPos.method_10260() + ")"
                );
            copiedBlockPos = hoveredBlockPos;
            return true;
        }

        return super.method_25402(click, doubled);
    }

    @Override
    protected String getBreadcrumbTitle() {
        if (chapter != null)
            return chapter.getTitle();

        return stack.method_7909().method_63680().getString();
    }

    public class_327 getFontRenderer() {
        return field_22793;
    }

    protected boolean isMouseOver(double mouseX, double mouseY, int x, int y, int w, int h) {
        boolean hovered = !(mouseX < x || mouseX > x + w);
        hovered &= !(mouseY < y || mouseY > y + h);
        return hovered;
    }

    @SuppressWarnings("DefaultNotLastCaseInSwitch")
    public static void renderSpeechBox(
        class_332 graphics,
        int x,
        int y,
        int w,
        int h,
        boolean highlighted,
        Pointing pointing,
        boolean returnWithLocalTransform
    ) {
        Matrix3x2fStack poseStack = graphics.method_51448();
        if (!returnWithLocalTransform) {
            poseStack.pushMatrix();
        }

        int boxX = x;
        int boxY = y;
        int divotX = x;
        int divotY = y;
        int divotRotation;
        int divotSize = 8;
        int distance = 1;
        int divotRadius = divotSize / 2;
        Couple<Color> borderColors = highlighted ? PonderButton.COLOR_HOVER : COLOR_IDLE;
        Color c;

        switch (pointing) {
            default:
            case DOWN:
                divotRotation = 0;
                boxX -= w / 2;
                boxY -= h + divotSize + 1 + distance;
                divotX -= divotRadius;
                divotY -= divotSize + distance;
                c = borderColors.getSecond();
                break;
            case LEFT:
                divotRotation = 90;
                boxX += divotSize + 1 + distance;
                boxY -= h / 2;
                divotX += distance;
                divotY -= divotRadius;
                c = Color.mixColors(borderColors, 0.5f);
                break;
            case RIGHT:
                divotRotation = 270;
                boxX -= w + divotSize + 1 + distance;
                boxY -= h / 2;
                divotX -= divotSize + distance;
                divotY -= divotRadius;
                c = Color.mixColors(borderColors, 0.5f);
                break;
            case UP:
                divotRotation = 180;
                boxX -= w / 2;
                boxY += divotSize + 1 + distance;
                divotX -= divotRadius;
                divotY += distance;
                c = borderColors.getFirst();
                break;
        }

        new BoxElement().withBackground(PonderUI.BACKGROUND_FLAT).gradientBorder(borderColors).at(boxX, boxY, 100).withBounds(w, h).render(graphics);

        poseStack.pushMatrix();
        poseStack.translate(divotX + divotRadius, divotY + divotRadius);
        poseStack.rotate(divotRotation * (float) (Math.PI / 180.0));
        poseStack.translate(-divotRadius, -divotRadius);
        PonderGuiTextures.SPEECH_TOOLTIP_BACKGROUND.render(graphics, 0, 0);
        PonderGuiTextures.SPEECH_TOOLTIP_COLOR.render(graphics, 0, 0, c);
        poseStack.popMatrix();

        if (returnWithLocalTransform) {
            poseStack.translate(boxX, boxY);
            return;
        }

        poseStack.popMatrix();

    }

    public class_1799 getHoveredTooltipItem() {
        return hoveredTooltipItem;
    }

    public class_1799 getSubject() {
        return stack;
    }

    @Override
    public boolean isEquivalentTo(NavigatableSimiScreen other) {
        if (other instanceof PonderUI otherUI)
            return !otherUI.stack.method_7960() && stack.method_31574(otherUI.stack.method_7909());
        return super.isEquivalentTo(other);
    }

    @Override
    public void shareContextWith(NavigatableSimiScreen other) {
        if (other instanceof PonderUI ponderUI) {
            ponderUI.referredToByTag = referredToByTag;
        }
    }

    public static float getPartialTicks() {
        class_310 mc = class_310.method_1551();
        float renderPartialTicks = AnimationTickHolder.getPartialTicksUI(mc.method_61966());

        if (mc.field_1755 instanceof PonderUI ui) {
            if (ui.identifyMode)
                return ponderPartialTicksPaused;

            return (renderPartialTicks + (ui.extendedTickLength - ui.extendedTickTimer)) / (ui.extendedTickLength + 1);
        }

        return renderPartialTicks;
    }

    @Override
    public boolean method_25421() {
        return true;
    }

    public void coolDownAfterSkip() {
        skipCooling = 15;
    }

    @Override
    public void method_25432() {
        super.method_25432();
        hoveredTooltipItem = class_1799.field_8037;
        itemRender.clear();
        for (PonderTag tag : tags) {
            tag.clear();
        }
    }

    public boolean isComfyReadingEnabled() {
        return PonderConfig.client().comfyReading.get();
    }

    public void setComfyReadingEnabled(boolean slowTextMode) {
        PonderConfig.client().comfyReading.set(slowTextMode);
    }

}