package com.zurrtum.create.client.vanillin.visuals;

import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import net.minecraft.class_1701;
import net.minecraft.class_3532;
import net.minecraft.class_4608;
import net.minecraft.class_5602;
import org.joml.Matrix4f;

public class TntMinecartVisual<T extends class_1701> extends MinecartVisual<T> {
    private static final int WHITE_OVERLAY = class_4608.method_23625(class_4608.method_23210(1.0F), 10);

    public TntMinecartVisual(VisualizationContext ctx, T entity, float partialTick) {
        super(ctx, entity, partialTick, class_5602.field_27666);
    }

    @Override
    protected void updateContents(TransformedInstance contents, Matrix4f pose, float partialTick) {
        int fuseTime = entity.method_7577();
        if (fuseTime > -1 && (float) fuseTime - partialTick + 1.0F < 10.0F) {
            float f = 1.0F - ((float) fuseTime - partialTick + 1.0F) / 10.0F;
            f = class_3532.method_15363(f, 0.0F, 1.0F);
            f *= f;
            f *= f;
            float scale = 1.0F + f * 0.3F;
            pose.scale(scale);
        }

        int overlay;
        if (fuseTime > -1 && fuseTime / 5 % 2 == 0) {
            overlay = WHITE_OVERLAY;
        } else {
            overlay = class_4608.field_21444;
        }

        contents.setTransform(pose).overlay(overlay).setChanged();
    }
}
