package com.zurrtum.create.compat.rei.display;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.compat.rei.IngredientHelper;
import com.zurrtum.create.compat.rei.ReiCommonPlugin;
import com.zurrtum.create.content.fluids.transfer.FillingRecipe;
import com.zurrtum.create.content.kinetics.deployer.DeployerApplicationRecipe;
import com.zurrtum.create.content.processing.recipe.ChanceOutput;
import com.zurrtum.create.content.processing.sequenced.SequencedAssemblyRecipe;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_124;
import net.minecraft.class_1860;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5244;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public record SequencedAssemblyDisplay(
    EntryIngredient input, SequenceData sequences, ChanceOutput output, int loop, Optional<class_2960> location
) implements Display {
    public static final DisplaySerializer<SequencedAssemblyDisplay> SERIALIZER = DisplaySerializer.of(
        RecordCodecBuilder.mapCodec(instance -> instance.group(
            EntryIngredient.codec().fieldOf("input").forGetter(SequencedAssemblyDisplay::input),
            SequenceData.CODEC.fieldOf("sequences").forGetter(SequencedAssemblyDisplay::sequences),
            ChanceOutput.CODEC.fieldOf("output").forGetter(SequencedAssemblyDisplay::output),
            Codec.INT.fieldOf("loop").forGetter(SequencedAssemblyDisplay::loop),
            class_2960.field_25139.optionalFieldOf("location").forGetter(SequencedAssemblyDisplay::location)
        ).apply(instance, SequencedAssemblyDisplay::new)), class_9139.method_56906(
            EntryIngredient.streamCodec(),
            SequencedAssemblyDisplay::input,
            SequenceData.PACKET_CODEC,
            SequencedAssemblyDisplay::sequences,
            ChanceOutput.PACKET_CODEC,
            SequencedAssemblyDisplay::output,
            class_9135.field_49675,
            SequencedAssemblyDisplay::loop,
            class_9135.method_56382(class_2960.field_48267),
            SequencedAssemblyDisplay::location,
            SequencedAssemblyDisplay::new
        )
    );

    public SequencedAssemblyDisplay(class_8786<SequencedAssemblyRecipe> entry) {
        this(entry.comp_1932().method_29177(), entry.comp_1933());
    }

    public SequencedAssemblyDisplay(class_2960 id, SequencedAssemblyRecipe recipe) {
        this(EntryIngredients.ofIngredient(recipe.ingredient()), SequenceData.create(recipe), recipe.result(), recipe.loops(), Optional.of(id));
    }

    @Override
    public List<EntryIngredient> getInputEntries() {
        List<EntryIngredient> inputs = new ArrayList<>();
        inputs.add(input);
        for (EntryIngredient ingredient : sequences.ingredients) {
            if (ingredient.isEmpty()) {
                continue;
            }
            inputs.add(ingredient);
        }
        return inputs;
    }

    @Override
    public List<EntryIngredient> getOutputEntries() {
        return List.of(EntryIngredients.of(output.stack()));
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return ReiCommonPlugin.SEQUENCED_ASSEMBLY;
    }

    @Override
    public Optional<class_2960> getDisplayLocation() {
        return location;
    }

    @Override
    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }

    public record SequenceData(List<class_3956<?>> types, List<List<class_2561>> tooltip, List<EntryIngredient> ingredients) {
        public static final Codec<SequenceData> CODEC = RecordCodecBuilder.create(instance -> instance.group(
            class_7923.field_41188.method_39673().listOf().fieldOf("types").forGetter(SequenceData::types),
            class_8824.field_46597.listOf().listOf().fieldOf("tooltip").forGetter(SequenceData::tooltip),
            EntryIngredient.codec().listOf().fieldOf("ingredients").forGetter(SequenceData::ingredients)
        ).apply(instance, SequenceData::new));
        public static final class_9139<class_9129, SequenceData> PACKET_CODEC = class_9139.method_56436(
            class_9135.method_56365(class_7924.field_41217).method_56433(class_9135.method_56363()),
            SequenceData::types,
            class_8824.field_49668.method_56433(class_9135.method_56363()).method_56433(class_9135.method_56363()),
            SequenceData::tooltip,
            EntryIngredient.streamCodec().method_56433(class_9135.method_56363()),
            SequenceData::ingredients,
            SequenceData::new
        );

        public static SequenceData create(SequencedAssemblyRecipe recipe) {
            ImmutableList.Builder<EntryIngredient> ingredientBuilder = ImmutableList.builder();
            ImmutableList.Builder<List<class_2561>> textBuilder = ImmutableList.builder();
            ImmutableList.Builder<class_3956<?>> typeBuilder = ImmutableList.builder();
            List<class_1860<?>> recipes = recipe.sequence();
            for (int i = 0, size = recipes.size() / recipe.loops(); i < size; i++) {
                class_1860<?> sequence = recipes.get(i);
                typeBuilder.add(sequence.method_17716());
                ImmutableList.Builder<class_2561> tooltipBuilder = ImmutableList.builder();
                tooltipBuilder.add(class_2561.method_43469("create.recipe.assembly.step", i + 1));
                if (sequence instanceof DeployerApplicationRecipe deployerApplicationRecipe) {
                    tooltipBuilder.add(class_2561.method_43469("create.recipe.assembly.deploying_item", "").method_27692(class_124.field_1077));
                    ingredientBuilder.add(EntryIngredients.ofIngredient(deployerApplicationRecipe.ingredient()));
                } else if (sequence instanceof FillingRecipe fillingRecipe) {
                    tooltipBuilder.add(class_2561.method_43469("create.recipe.assembly.spout_filling_fluid", "").method_27692(class_124.field_1077));
                    ingredientBuilder.add(IngredientHelper.createEntryIngredient(fillingRecipe.fluidIngredient()));
                } else {
                    ingredientBuilder.add(EntryIngredient.empty());
                    class_2960 id = class_7923.field_41188.method_10221(sequence.method_17716());
                    if (id != null) {
                        String namespace = id.method_12836();
                        String recipeName;
                        if (namespace.equals("create")) {
                            recipeName = id.method_12832();
                        } else {
                            recipeName = id.method_12836() + "." + id.method_12832();
                        }
                        tooltipBuilder.add(class_2561.method_43471("create.recipe.assembly." + recipeName).method_27692(class_124.field_1077));
                    } else {
                        tooltipBuilder.add(class_5244.field_39003);
                    }
                }
                textBuilder.add(tooltipBuilder.build());
            }
            return new SequenceData(typeBuilder.build(), textBuilder.build(), ingredientBuilder.build());
        }
    }
}
