package com.zurrtum.create.content.contraptions;

import com.zurrtum.create.infrastructure.config.AllConfigs;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3499.class_3501;

public abstract class TranslatingContraption extends Contraption {

    protected Set<class_2338> cachedColliders;
    protected class_2350 cachedColliderDirection;

    public Set<class_2338> getOrCreateColliders(class_1937 world, class_2350 movementDirection) {
        if (getBlocks() == null)
            return Collections.emptySet();
        if (cachedColliders == null || cachedColliderDirection != movementDirection) {
            cachedColliderDirection = movementDirection;
            cachedColliders = createColliders(world, movementDirection);
        }
        return cachedColliders;
    }

    public Set<class_2338> createColliders(class_1937 world, class_2350 movementDirection) {
        Set<class_2338> colliders = new HashSet<>();
        for (class_3501 info : getBlocks().values()) {
            class_2338 offsetPos = info.comp_1341().method_10093(movementDirection);
            if (info.comp_1342().method_26220(world, offsetPos).method_1110())
                continue;
            if (getBlocks().containsKey(offsetPos) && !getBlocks().get(offsetPos).comp_1342().method_26220(world, offsetPos).method_1110())
                continue;
            colliders.add(info.comp_1341());
        }
        return colliders;
    }

    @Override
    public void removeBlocksFromWorld(class_1937 world, class_2338 offset) {
        int count = blocks.size();
        super.removeBlocksFromWorld(world, offset);
        if (count != blocks.size()) {
            cachedColliders = null;
        }
    }

    @Override
    public boolean canBeStabilized(class_2350 facing, class_2338 localPos) {
        return AllConfigs.server().kinetics.stabiliseStableContraptions.get();
    }

}
