package com.zurrtum.create.content.contraptions.actors.roller;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollOptionBehaviour;

import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2510;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;

public class RollerBlockEntity extends SmartBlockEntity {

    // For simulations such as Ponder
    private float manuallyAnimatedSpeed;

    public ServerFilteringBehaviour filtering;
    public ServerScrollOptionBehaviour<RollingMode> mode;

    private boolean dontPropagate;

    public RollerBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.MECHANICAL_ROLLER, pos, state);
        dontPropagate = false;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(filtering = new ServerFilteringBehaviour(this));
        behaviours.add(mode = new ServerScrollOptionBehaviour<>(RollingMode.class, this));

        filtering.withCallback(this::onFilterChanged);
        filtering.withPredicate(this::isValidMaterial);
        mode.withCallback(this::onModeChanged);
    }

    protected void onModeChanged(int mode) {
        shareValuesToAdjacent();
    }

    protected void onFilterChanged(class_1799 newFilter) {
        shareValuesToAdjacent();
    }

    protected boolean isValidMaterial(class_1799 newFilter) {
        if (newFilter.method_7960())
            return true;
        class_2680 appliedState = RollerMovementBehaviour.getStateToPaveWith(newFilter);
        if (appliedState.method_26215())
            return false;
        if (appliedState.method_26204() instanceof class_2343)
            return false;
        if (appliedState.method_26204() instanceof class_2510)
            return false;
        class_265 shape = appliedState.method_26218(field_11863, field_11867);
        if (shape.method_1110() || !shape.method_1107().equals(class_259.method_1077().method_1107()))
            return false;
        class_265 collisionShape = appliedState.method_26220(field_11863, field_11867);
        return !collisionShape.method_1110();
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return new class_238(field_11867).method_1014(1);
    }

    public float getAnimatedSpeed() {
        return manuallyAnimatedSpeed;
    }

    public void setAnimatedSpeed(float speed) {
        manuallyAnimatedSpeed = speed;
    }

    public void searchForSharedValues() {
        class_2680 blockState = method_11010();
        class_2350 facing = blockState.method_61767(RollerBlock.field_11177, class_2350.field_11035);

        for (int side : Iterate.positiveAndNegative) {
            class_2338 pos = this.field_11867.method_10079(facing.method_10170(), side);
            if (field_11863.method_8320(pos) != blockState)
                continue;
            if (!(field_11863.method_8321(pos) instanceof RollerBlockEntity otherRoller))
                continue;
            acceptSharedValues(otherRoller.mode.getValue(), otherRoller.filtering.getFilter());
            shareValuesToAdjacent();
            break;
        }
    }

    protected void acceptSharedValues(int mode, class_1799 filter) {
        dontPropagate = true;
        this.filtering.setFilter(filter.method_7972());
        this.mode.setValue(mode);
        dontPropagate = false;
        notifyUpdate();
    }

    public void shareValuesToAdjacent() {
        if (dontPropagate || field_11863.method_8608())
            return;
        class_2680 blockState = method_11010();
        class_2350 facing = blockState.method_61767(RollerBlock.field_11177, class_2350.field_11035);

        for (int side : Iterate.positiveAndNegative) {
            for (int i = 1; i < 100; i++) {
                class_2338 pos = this.field_11867.method_10079(facing.method_10170(), side * i);
                if (field_11863.method_8320(pos) != blockState)
                    break;
                if (!(field_11863.method_8321(pos) instanceof RollerBlockEntity otherRoller))
                    break;
                otherRoller.acceptSharedValues(mode.getValue(), filtering.getFilter());
            }
        }
    }

    public enum RollingMode {
        TUNNEL_PAVE,
        STRAIGHT_FILL,
        WIDE_FILL;
    }
}