package com.zurrtum.create.content.contraptions.behaviour;

import com.google.common.base.Suppliers;
import com.zurrtum.create.api.contraption.storage.fluid.MountedFluidStorage;
import com.zurrtum.create.api.contraption.storage.item.MountedItemStorage;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.logistics.filter.FilterItemStack;
import org.jetbrains.annotations.Nullable;

import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3499.class_3501;
import net.minecraft.class_6903;

public class MovementContext {

    public class_243 position;
    public class_243 motion;
    public class_243 relativeMotion;
    public UnaryOperator<class_243> rotation;

    public class_1937 world;
    public class_2680 state;
    public class_2338 localPos;
    public class_2487 blockEntityData;

    public boolean stall;
    public boolean disabled;
    public boolean firstMovement;
    public class_2487 data;
    public Contraption contraption;
    public Object temporaryData;

    private FilterItemStack filter;

    private final Supplier<MountedItemStorage> itemStorage;
    private final Supplier<MountedFluidStorage> fluidStorage;

    public MovementContext(class_1937 world, class_3501 info, Contraption contraption) {
        this.world = world;
        this.state = info.comp_1342();
        this.blockEntityData = info.comp_1343();
        this.contraption = contraption;
        localPos = info.comp_1341();

        disabled = false;
        firstMovement = true;
        motion = class_243.field_1353;
        relativeMotion = class_243.field_1353;
        rotation = v -> v;
        position = null;
        data = new class_2487();
        stall = false;
        filter = null;
        this.itemStorage = Suppliers.memoize(() -> contraption.getStorage().getAllItemStorages().get(this.localPos));
        this.fluidStorage = Suppliers.memoize(() -> contraption.getStorage().getFluids().storages.get(this.localPos));
    }

    public float getAnimationSpeed() {
        int modifier = 1000;
        double length = -motion.method_1033();
        if (disabled)
            return 0;
        if (world.method_8608() && contraption.stalled)
            return 700;
        if (Math.abs(length) < 1 / 512f)
            return 0;
        return (((int) (length * modifier + 100 * Math.signum(length))) / 100) * 100;
    }

    public static MovementContext read(class_1937 world, class_3501 info, class_11368 view, Contraption contraption) {
        MovementContext context = new MovementContext(world, info, contraption);
        context.motion = view.method_71426("Motion", class_243.field_38277).orElseThrow();
        context.relativeMotion = view.method_71426("RelativeMotion", class_243.field_38277).orElseThrow();
        view.method_71426("Position", class_243.field_38277).ifPresent(position -> context.position = position);
        context.stall = view.method_71433("Stall", false);
        context.firstMovement = view.method_71433("FirstMovement", false);
        context.data = view.method_71426("Data", class_2487.field_25128).orElseThrow();
        return context;
    }

    public void write(class_11372 view) {
        view.method_71468("Motion", class_243.field_38277, motion);
        view.method_71468("RelativeMotion", class_243.field_38277, relativeMotion);
        if (position != null)
            view.method_71468("Position", class_243.field_38277, position);
        view.method_71472("Stall", stall);
        view.method_71472("FirstMovement", firstMovement);
        view.method_71468("Data", class_2487.field_25128, data);
    }

    public FilterItemStack getFilterFromBE() {
        if (filter != null)
            return filter;
        class_6903<class_2520> ops = world.method_30349().method_57093(class_2509.field_11560);
        return filter = blockEntityData.method_67492("Filter", FilterItemStack.CODEC, ops).orElseGet(FilterItemStack::empty);
    }

    @Nullable
    public MountedItemStorage getItemStorage() {
        return this.itemStorage.get();
    }

    @Nullable
    public MountedFluidStorage getFluidStorage() {
        return this.fluidStorage.get();
    }
}
