package com.zurrtum.create.content.contraptions.glue;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.api.contraption.BlockMovementChecks;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.levelWrappers.RayTraceLevel;
import com.zurrtum.create.infrastructure.packet.s2c.GlueEffectPacket;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_11580;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239.class_240;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5134;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class SuperGlueHandler {

    public static void glueListensForBlockPlacement(class_3218 world, class_1657 player, class_2338 pos) {
        Set<SuperGlueEntity> cached = new HashSet<>();
        for (class_2350 direction : Iterate.directions) {
            class_2338 relative = pos.method_10093(direction);
            if (SuperGlueEntity.isGlued(world, pos, direction, cached) && BlockMovementChecks.isMovementNecessary(
                world.method_8320(relative),
                world,
                relative
            )) {
                world.method_14178().method_18751(player, new GlueEffectPacket(pos, direction, true));
            }
        }

        glueInOffHandAppliesOnBlockPlace(world, player, pos);
    }

    public static void glueInOffHandAppliesOnBlockPlace(class_3218 world, class_1657 placer, class_2338 pos) {
        class_1324 reachAttribute = placer.method_5996(class_5134.field_47758);
        if (reachAttribute == null)
            return;
        class_1799 itemstack = placer.method_6079();
        if (!itemstack.method_31574(AllItems.SUPER_GLUE))
            return;
        if (placer.method_6047().method_31574(AllItems.WRENCH))
            return;
        //TODO
        //        if (event.getPlacedAgainst() == IPlacementHelper.ID)
        //            return;

        double distance = reachAttribute.method_6194();
        class_243 start = placer.method_5836(1);
        class_243 look = placer.method_5828(1);
        class_243 end = start.method_1031(look.field_1352 * distance, look.field_1351 * distance, look.field_1350 * distance);

        RayTraceLevel rayTraceLevel = new RayTraceLevel(world, (p, state) -> p.equals(pos) ? class_2246.field_10124.method_9564() : state);
        class_3965 ray = rayTraceLevel.method_17742(new class_3959(start, end, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, placer));

        class_2350 face = ray.method_17780();
        if (face == null || ray.method_17783() == class_240.field_1333)
            return;

        class_2338 gluePos = ray.method_17777();
        if (!gluePos.method_10093(face).equals(pos)) {
            return;
        }

        if (SuperGlueEntity.isGlued(world, gluePos, face, null))
            return;

        SuperGlueEntity entity = new SuperGlueEntity(world, SuperGlueEntity.span(gluePos, gluePos.method_10093(face)));
        class_9279 customData = itemstack.method_58694(class_9334.field_49628);
        if (customData != null)
            class_1299.method_5881(world, placer, entity, class_11580.method_72535(entity.method_5864(), customData.method_57461()));

        if (SuperGlueEntity.isValidFace(world, gluePos, face)) {
            world.method_8649(entity);
            world.method_14178().method_18754(entity, new GlueEffectPacket(gluePos, face, true));
            itemstack.method_7970(1, placer, class_1304.field_6173);
        }
    }

}
