package com.zurrtum.create.content.contraptions.minecart;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.minecart.capability.MinecartController;
import net.minecraft.class_1297;
import net.minecraft.class_1313;
import net.minecraft.class_1688;
import net.minecraft.class_1696;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2768;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_9883;

public class CouplingPhysics {

    public static void tick(class_1937 world) {
        CouplingHandler.forEachLoadedCoupling(world, c -> tickCoupling(world, c));
    }

    public static void tickCoupling(class_1937 world, Couple<MinecartController> c) {
        Couple<class_1688> carts = c.map(MinecartController::cart);
        float couplingLength = c.getFirst().getCouplingLength(true);
        softCollisionStep(world, carts, couplingLength);
        if (world.method_8608())
            return;
        hardCollisionStep((class_3218) world, carts, couplingLength);
    }

    public static void hardCollisionStep(class_3218 world, Couple<class_1688> carts, double couplingLength) {
        if (!MinecartSim2020.canAddMotion(carts.get(false)) && MinecartSim2020.canAddMotion(carts.get(true)))
            carts = carts.swap();

        Couple<class_243> corrections = Couple.create(null, null);
        Couple<Double> maxSpeed = carts.map(cart -> cart.method_7504(world));
        boolean firstLoop = true;
        for (boolean current : new boolean[]{true, false, true}) {
            class_1688 cart = carts.get(current);
            class_1688 otherCart = carts.get(!current);

            float stress = (float) (couplingLength - cart.method_73189().method_1022(otherCart.method_73189()));

            if (Math.abs(stress) < 1 / 8f)
                continue;

            class_2768 shape = null;
            class_2338 railPosition = getCurrentRailPosition(cart);
            class_2680 railState = world.method_8320(railPosition.method_10084());

            if (railState.method_26204() instanceof class_2241 block) {
                shape = railState.method_11654(block.method_9474());
            }

            class_243 pos = cart.method_73189();
            class_243 link = otherCart.method_73189().method_1020(pos);
            float correctionMagnitude = firstLoop ? -stress / 2f : -stress;

            if (!MinecartSim2020.canAddMotion(cart))
                correctionMagnitude /= 2;

            class_243 correction = shape != null ? followLinkOnRail(
                link,
                pos,
                correctionMagnitude,
                MinecartSim2020.getRailVec(shape)
            ).method_1020(pos) : link.method_1029().method_1021(correctionMagnitude);

            float maxResolveSpeed = 1.75f;
            correction = VecHelper.clamp(correction, (float) Math.min(maxResolveSpeed, maxSpeed.get(current)));

            if (corrections.get(current) == null)
                corrections.set(current, correction);

            if (shape != null)
                MinecartSim2020.moveCartAlongTrack(world, cart, correction, railPosition, railState);
            else {
                cart.method_5784(class_1313.field_6308, correction);
                cart.method_18799(cart.method_18798().method_1021(0.95f));
            }
            firstLoop = false;
        }
    }

    private static class_2338 getCurrentRailPosition(class_1688 cart) {
        int x = class_3532.method_15357(cart.method_23317());
        int y = class_3532.method_15357(cart.method_23318());
        int z = class_3532.method_15357(cart.method_23321());
        class_2338 pos = new class_2338(x, y, z);
        class_2338 down = pos.method_10074();
        if (cart.method_73183().method_8320(down).method_26164(class_3481.field_15463)) {
            return down;
        }
        return pos;
    }

    public static void softCollisionStep(class_1937 world, Couple<class_1688> carts, double couplingLength) {
        Couple<Float> maxSpeed = carts.map(cart -> {
            if (world instanceof class_3218 serverWorld) {
                return (float) cart.method_7504(serverWorld);
            }
            if (cart.method_61569() instanceof class_9883) {
                return (float) cart.method_7504(null);
            }
            double speed = 8 * (cart.method_5799() ? 0.5 : 1.0) / 20.0;
            if (cart instanceof class_1696) {
                speed *= cart.method_5799() ? 0.75 : 0.5;
            }
            return (float) speed;
        });
        Couple<Boolean> canAddmotion = carts.map(MinecartSim2020::canAddMotion);

        // Assuming Minecarts will never move faster than 1 block/tick
        Couple<class_243> motions = carts.map(class_1297::method_18798);
        motions.replaceWithParams(VecHelper::clamp, Couple.create(1f, 1f));
        Couple<class_243> nextPositions = carts.map(MinecartSim2020::predictNextPositionOf);

        Couple<class_2768> shapes = carts.mapWithContext((minecart, current) -> {
            class_243 vec = nextPositions.get(current);
            int x = class_3532.method_15357(vec.method_10216());
            int y = class_3532.method_15357(vec.method_10214());
            int z = class_3532.method_15357(vec.method_10215());
            class_2338 pos = new class_2338(x, y - 1, z);
            if (minecart.method_73183().method_8320(pos).method_26164(class_3481.field_15463))
                pos = pos.method_10074();
            class_2338 railPosition = pos;
            class_2680 railState = world.method_8320(railPosition.method_10084());
            if (!(railState.method_26204() instanceof class_2241 block))
                return null;
            return railState.method_11654(block.method_9474());
        });

        float futureStress = (float) (couplingLength - nextPositions.getFirst().method_1022(nextPositions.getSecond()));
        if (class_3532.method_20390(futureStress, 0D))
            return;

        for (boolean current : Iterate.trueAndFalse) {
            class_243 correction;
            class_243 pos = nextPositions.get(current);
            class_243 link = nextPositions.get(!current).method_1020(pos);
            float correctionMagnitude = -futureStress / 2f;

            if (canAddmotion.get(current) != canAddmotion.get(!current))
                correctionMagnitude = !canAddmotion.get(current) ? 0 : correctionMagnitude * 2;
            if (!canAddmotion.get(current))
                continue;

            class_2768 shape = shapes.get(current);
            if (shape != null) {
                class_243 railVec = MinecartSim2020.getRailVec(shape);
                correction = followLinkOnRail(link, pos, correctionMagnitude, railVec).method_1020(pos);
            } else
                correction = link.method_1029().method_1021(correctionMagnitude);

            correction = VecHelper.clamp(correction, maxSpeed.get(current));

            motions.set(current, motions.get(current).method_1019(correction));
        }

        motions.replaceWithParams(VecHelper::clamp, maxSpeed);
        carts.forEachWithParams(class_1297::method_18799, motions);
    }

    public static class_243 followLinkOnRail(class_243 link, class_243 cart, float diffToReduce, class_243 railAxis) {
        double dotProduct = railAxis.method_1026(link);
        if (Double.isNaN(dotProduct) || dotProduct == 0 || diffToReduce == 0)
            return cart;

        class_243 axis = railAxis.method_1021(-Math.signum(dotProduct));
        class_243 center = cart.method_1019(link);
        double radius = link.method_1033() - diffToReduce;
        class_243 intersectSphere = VecHelper.intersectSphere(cart, axis, center, radius);

        // Cannot satisfy on current rail vector
        if (intersectSphere == null)
            return cart.method_1019(VecHelper.project(link, axis));

        return intersectSphere;
    }

}
