package com.zurrtum.create.content.contraptions.mounted;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.redstone.rail.ControllerRailBlock;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement.ItemUseType;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.MinecartPassBlock;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1694;
import net.minecraft.class_1696;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2768;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_8567;
import net.minecraft.class_9904;
import net.minecraft.world.level.block.state.properties.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CartAssemblerBlock extends class_2241 implements IBE<CartAssemblerBlockEntity>, IWrenchable, SpecialBlockItemRequirement, MinecartPassBlock {

    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2746 BACKWARDS = class_2746.method_11825("backwards");
    public static final class_2754<class_2768> RAIL_SHAPE = class_2754.method_11849(
        "shape",
        class_2768.class,
        class_2768.field_12674,
        class_2768.field_12665
    );
    public static final class_2754<CartAssembleRailType> RAIL_TYPE = class_2754.method_11850("rail_type", CartAssembleRailType.class);

    public static final MapCodec<CartAssemblerBlock> CODEC = method_54094(CartAssemblerBlock::new);

    public CartAssemblerBlock(class_2251 properties) {
        super(true, properties);
        method_9590(method_9564().method_11657(POWERED, false).method_11657(BACKWARDS, false)
            .method_11657(RAIL_TYPE, CartAssembleRailType.POWERED_RAIL).method_11657(field_27096, false));
    }

    public static class_2680 createAnchor(class_2680 state) {
        class_2351 axis = state.method_11654(RAIL_SHAPE) == class_2768.field_12665 ? class_2351.field_11051 : class_2351.field_11048;
        return AllBlocks.MINECART_ANCHOR.method_9564().method_11657(class_2741.field_12529, axis);
    }

    private static class_1792 getRailItem(class_2680 state) {
        return state.method_11654(RAIL_TYPE).getItem();
    }

    public static class_2680 getRailBlock(class_2680 state) {
        class_2241 railBlock = (class_2241) state.method_11654(RAIL_TYPE).getBlock();

        class_2680 railState = railBlock.method_9564().method_11657(railBlock.method_9474(), state.method_11654(RAIL_SHAPE));

        if (railState.method_28498(ControllerRailBlock.BACKWARDS))
            railState = railState.method_11657(ControllerRailBlock.BACKWARDS, state.method_11654(BACKWARDS));
        return railState;
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> builder) {
        builder.method_11667(RAIL_SHAPE, POWERED, RAIL_TYPE, BACKWARDS, field_27096);
        super.method_9515(builder);
    }

    @Override
    public boolean method_9478() {
        return false;
    }

    @Override
    public void onMinecartPass(class_2680 state, class_1937 world, class_2338 pos, class_1688 cart) {
        if (!canAssembleTo(cart))
            return;
        if (world.method_8608())
            return;

        withBlockEntityDo(world, pos, be -> be.assembleNextTick(cart));
    }

    public enum CartAssemblerAction {
        ASSEMBLE,
        DISASSEMBLE,
        ASSEMBLE_ACCELERATE,
        DISASSEMBLE_BRAKE,
        ASSEMBLE_ACCELERATE_DIRECTIONAL,
        PASS;

        public boolean shouldAssemble() {
            return this == ASSEMBLE || this == ASSEMBLE_ACCELERATE || this == ASSEMBLE_ACCELERATE_DIRECTIONAL;
        }

        public boolean shouldDisassemble() {
            return this == DISASSEMBLE || this == DISASSEMBLE_BRAKE;
        }
    }

    public static CartAssemblerAction getActionForCart(class_2680 state, class_1688 cart) {
        CartAssembleRailType type = state.method_11654(RAIL_TYPE);
        boolean powered = state.method_11654(POWERED);
        return switch (type) {
            case ACTIVATOR_RAIL -> powered ? CartAssemblerAction.DISASSEMBLE : CartAssemblerAction.PASS;
            case CONTROLLER_RAIL -> powered ? CartAssemblerAction.ASSEMBLE_ACCELERATE_DIRECTIONAL : CartAssemblerAction.DISASSEMBLE_BRAKE;
            case DETECTOR_RAIL -> cart.method_5685().isEmpty() ? CartAssemblerAction.ASSEMBLE_ACCELERATE : CartAssemblerAction.DISASSEMBLE;
            case POWERED_RAIL -> powered ? CartAssemblerAction.ASSEMBLE_ACCELERATE : CartAssemblerAction.DISASSEMBLE_BRAKE;
            case REGULAR -> powered ? CartAssemblerAction.ASSEMBLE : CartAssemblerAction.DISASSEMBLE;
            default -> CartAssemblerAction.PASS;
        };
    }

    public static boolean canAssembleTo(class_1688 cart) {
        return cart.method_64272() || cart instanceof class_1696 || cart instanceof class_1694;
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        class_1792 previousItem = getRailItem(state);
        class_1792 heldItem = stack.method_7909();
        if (heldItem != previousItem) {

            CartAssembleRailType newType = null;
            for (CartAssembleRailType type : CartAssembleRailType.values())
                if (heldItem == type.getItem())
                    newType = type;
            if (newType == null)
                return class_1269.field_52423;
            level.method_8396(null, pos, class_3417.field_15197, class_3419.field_15248, 1, 1);
            level.method_8501(pos, state.method_11657(RAIL_TYPE, newType));

            if (!player.method_68878()) {
                stack.method_7934(1);
                player.method_31548().method_7398(new class_1799(previousItem));
            }
            return class_1269.field_5812;
        }

        return class_1269.field_52423;
    }

    @Override
    public void method_9612(
        class_2680 state,
        class_1937 worldIn,
        class_2338 pos,
        class_2248 blockIn,
        @Nullable class_9904 WireOrientation,
        boolean isMoving
    ) {
        if (worldIn.method_8608())
            return;
        boolean previouslyPowered = state.method_11654(POWERED);
        if (previouslyPowered != worldIn.method_49803(pos))
            worldIn.method_8652(pos, state.method_28493(POWERED), class_2248.field_31028);
        super.method_9612(state, worldIn, pos, blockIn, WireOrientation, isMoving);
    }

    @Override
    @NotNull
    public class_2769<class_2768> method_9474() {
        return RAIL_SHAPE;
    }

    @Override
    @NotNull
    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return AllShapes.CART_ASSEMBLER.get(getRailAxis(state));
    }

    protected class_2351 getRailAxis(class_2680 state) {
        return state.method_11654(RAIL_SHAPE) == class_2768.field_12665 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
    }

    @Override
    @NotNull
    public class_265 method_9549(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        if (context instanceof class_3727 entityShapeContext) {
            class_1297 entity = entityShapeContext.method_32480();
            if (entity instanceof class_1688)
                return class_259.method_1073();
            if (entity instanceof class_1657)
                return AllShapes.CART_ASSEMBLER_PLAYER_COLLISION.get(getRailAxis(state));
        }
        return class_259.method_1077();
    }

    @Override
    public Class<CartAssemblerBlockEntity> getBlockEntityClass() {
        return CartAssemblerBlockEntity.class;
    }

    @Override
    public class_2591<? extends CartAssemblerBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.CART_ASSEMBLER;
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return false;
    }

    @Override
    public ItemRequirement getRequiredItems(class_2680 state, class_2586 be) {
        ArrayList<class_1799> requiredItems = new ArrayList<>();
        requiredItems.add(new class_1799(getRailItem(state)));
        requiredItems.add(new class_1799(method_8389()));
        return new ItemRequirement(ItemUseType.CONSUME, requiredItems);
    }

    @Override
    @NotNull
    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        List<class_1799> drops = super.method_9560(state, builder);
        drops.addAll(getRailBlock(state).method_26189(builder));
        return drops;
    }

    public List<class_1799> getDropsNoRail(
        class_2680 state,
        class_3218 world,
        class_2338 pos,
        @Nullable class_2586 p_220077_3_,
        @Nullable class_1297 p_220077_4_,
        class_1799 p_220077_5_
    ) {
        return super.method_9560(
            state,
            (new class_8567.class_8568(world)).method_51874(class_181.field_24424, class_243.method_24954(pos))
                .method_51874(class_181.field_1229, p_220077_5_).method_51877(class_181.field_1226, p_220077_4_)
                .method_51877(class_181.field_1228, p_220077_3_)
        );
    }

    @Override
    public class_1269 onSneakWrenched(class_2680 state, class_1838 context) {
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_1657 player = context.method_8036();
        if (world.method_8608())
            return class_1269.field_5812;
        if (player != null && !player.method_68878())
            getDropsNoRail(
                state,
                (class_3218) world,
                pos,
                world.method_8321(pos),
                player,
                context.method_8041()
            ).forEach(itemStack -> player.method_31548().method_7398(itemStack));
        if (world instanceof class_3218)
            state.method_26180((class_3218) world, pos, class_1799.field_8037, true);
        world.method_8501(pos, getRailBlock(state));
        return class_1269.field_5812;
    }

    public static class MinecartAnchorBlock extends class_2248 {

        public MinecartAnchorBlock(class_2251 p_i48440_1_) {
            super(p_i48440_1_);
        }

        @Override
        protected void method_9515(class_2690<class_2248, class_2680> builder) {
            builder.method_11667(class_2741.field_12529);
            super.method_9515(builder);
        }

        @Override
        @NotNull
        public class_265 method_9530(class_2680 p_220053_1_, class_1922 p_220053_2_, class_2338 p_220053_3_, class_3726 p_220053_4_) {
            return class_259.method_1073();
        }
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        class_1937 world = context.method_8045();
        if (world.method_8608())
            return class_1269.field_5812;
        class_2338 pos = context.method_8037();
        world.method_8652(pos, method_9598(state, class_2470.field_11463), class_2248.field_31036);
        world.method_8452(pos.method_10074(), this, null);
        return class_1269.field_5812;
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        if (rotation == class_2470.field_11467)
            return state;
        class_2680 base = AllBlocks.CONTROLLER_RAIL.method_9564().method_11657(ControllerRailBlock.SHAPE, state.method_11654(RAIL_SHAPE))
            .method_11657(ControllerRailBlock.BACKWARDS, state.method_11654(BACKWARDS)).method_26186(rotation);
        return state.method_11657(RAIL_SHAPE, base.method_11654(ControllerRailBlock.SHAPE)).method_11657(BACKWARDS, base.method_11654(ControllerRailBlock.BACKWARDS));
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        if (mirror == class_2415.field_11302)
            return state;
        class_2680 base = AllBlocks.CONTROLLER_RAIL.method_9564().method_11657(ControllerRailBlock.SHAPE, state.method_11654(RAIL_SHAPE))
            .method_11657(ControllerRailBlock.BACKWARDS, state.method_11654(BACKWARDS)).method_26185(mirror);
        return state.method_11657(BACKWARDS, base.method_11654(ControllerRailBlock.BACKWARDS));
    }

    public static class_2350 getHorizontalDirection(class_2680 blockState) {
        if (!(blockState.method_26204() instanceof CartAssemblerBlock))
            return class_2350.field_11035;
        class_2350 pointingTo = getPointingTowards(blockState);
        return blockState.method_11654(BACKWARDS) ? pointingTo.method_10153() : pointingTo;
    }

    private static class_2350 getPointingTowards(class_2680 state) {
        if (Objects.requireNonNull(state.method_11654(RAIL_SHAPE)) == class_2768.field_12674) {
            return class_2350.field_11039;
        }
        return class_2350.field_11043;
    }

    @Override
    protected @NotNull MapCodec<? extends class_2241> method_53969() {
        return field_46280;
    }
}
