package com.zurrtum.create.content.contraptions.mounted;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.api.contraption.ContraptionMovementSetting;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.OrientedContraptionEntity;
import com.zurrtum.create.content.contraptions.actors.psi.PortableStorageInterfaceMovement;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.contraptions.data.ContraptionPickupLimiting;
import com.zurrtum.create.content.kinetics.deployer.DeployerPlayer;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2768;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3499.class_3501;
import net.minecraft.class_3730;
import net.minecraft.class_6088;
import net.minecraft.class_8942;
import net.minecraft.class_9334;

import static com.zurrtum.create.Create.LOGGER;

public class MinecartContraptionItem extends class_1792 {

    private final class_1299<? extends class_1688> minecartType;

    public static MinecartContraptionItem rideable(class_1793 builder) {
        return new MinecartContraptionItem(class_1299.field_6096, builder);
    }

    public static MinecartContraptionItem furnace(class_1793 builder) {
        return new MinecartContraptionItem(class_1299.field_6080, builder);
    }

    public static MinecartContraptionItem chest(class_1793 builder) {
        return new MinecartContraptionItem(class_1299.field_6126, builder);
    }

    @Override
    public boolean method_31568() {
        return AllConfigs.server().kinetics.minecartContraptionInContainers.get();
    }

    private MinecartContraptionItem(class_1299<? extends class_1688> minecartTypeIn, class_1793 builder) {
        super(builder);
        this.minecartType = minecartTypeIn;
        class_2315.method_10009(this, DISPENSER_BEHAVIOR);
    }

    // Taken and adjusted from MinecartItem
    private static final class_2357 DISPENSER_BEHAVIOR = new class_2347() {
        private final class_2347 behaviourDefaultDispenseItem = new class_2347();

        @Override
        public class_1799 method_10135(class_2342 source, class_1799 stack) {
            class_2350 direction = source.comp_1969().method_11654(class_2315.field_10918);
            class_3218 world = source.comp_1967();
            class_243 vec3 = source.method_53906();
            double d0 = vec3.method_10216() + (double) direction.method_10148() * 1.125D;
            double d1 = Math.floor(vec3.method_10214()) + (double) direction.method_10164();
            double d2 = vec3.method_10215() + (double) direction.method_10165() * 1.125D;
            class_2338 blockpos = source.comp_1968().method_10093(direction);
            class_2680 blockstate = world.method_8320(blockpos);
            class_2768 railshape = blockstate.method_26204() instanceof class_2241 abstractRailBlock ? blockstate.method_11654(abstractRailBlock.method_9474()) : class_2768.field_12665;
            double d3;
            if (blockstate.method_26164(class_3481.field_15463)) {
                if (railshape.method_11897()) {
                    d3 = 0.6D;
                } else {
                    d3 = 0.1D;
                }
            } else {
                if (!blockstate.method_26215() || !world.method_8320(blockpos.method_10074()).method_26164(class_3481.field_15463)) {
                    return this.behaviourDefaultDispenseItem.dispense(source, stack);
                }

                class_2680 blockstate1 = world.method_8320(blockpos.method_10074());
                class_2768 railshape1 = blockstate1.method_26204() instanceof class_2241 abstractRailBlock ? blockstate1.method_11654(abstractRailBlock.method_9474()) : class_2768.field_12665;
                if (direction != class_2350.field_11033 && railshape1.method_11897()) {
                    d3 = -0.4D;
                } else {
                    d3 = -0.9D;
                }
            }

            class_1688 abstractminecartentity = class_1688.method_7523(
                world,
                d0,
                d1 + d3,
                d2,
                ((MinecartContraptionItem) stack.method_7909()).minecartType,
                class_3730.field_16465,
                stack,
                null
            );
            if (stack.method_57826(class_9334.field_49631))
                abstractminecartentity.method_5665(stack.method_7964());
            world.method_8649(abstractminecartentity);
            addContraptionToMinecart(world, stack, abstractminecartentity, direction);

            stack.method_7934(1);
            return stack;
        }

        @Override
        protected void method_10136(class_2342 source) {
            source.comp_1967().method_20290(class_6088.field_31140, source.comp_1968(), 0);
        }
    };

    // Taken and adjusted from MinecartItem
    @Override
    public class_1269 method_7884(class_1838 context) {
        class_1937 world = context.method_8045();
        class_2338 blockpos = context.method_8037();
        class_2680 blockstate = world.method_8320(blockpos);
        if (!blockstate.method_26164(class_3481.field_15463)) {
            return class_1269.field_5814;
        } else {
            class_1799 itemstack = context.method_8041();
            if (world instanceof class_3218 serverlevel) {
                class_2768 railshape = blockstate.method_26204() instanceof class_2241 abstractRailBlock ? blockstate.method_11654(abstractRailBlock.method_9474()) : class_2768.field_12665;
                double d0 = 0.0D;
                if (railshape.method_11897()) {
                    d0 = 0.5D;
                }

                class_1688 abstractminecartentity = class_1688.method_7523(
                    serverlevel,
                    (double) blockpos.method_10263() + 0.5D,
                    (double) blockpos.method_10264() + 0.0625D + d0,
                    (double) blockpos.method_10260() + 0.5D,
                    this.minecartType,
                    class_3730.field_16465,
                    itemstack,
                    null
                );
                if (itemstack.method_57826(class_9334.field_49631))
                    abstractminecartentity.method_5665(itemstack.method_7964());
                class_1657 player = context.method_8036();
                world.method_8649(abstractminecartentity);
                addContraptionToMinecart(world, itemstack, abstractminecartentity, player == null ? null : player.method_5735());
            }

            itemstack.method_7934(1);
            return class_1269.field_5812;
        }
    }

    public static void addContraptionToMinecart(class_1937 world, class_1799 itemstack, class_1688 cart, @Nullable class_2350 newFacing) {
        if (itemstack.method_57826(AllDataComponents.MINECRAFT_CONTRAPTION_DATA)) {
            class_2487 contraptionTag = itemstack.method_58694(AllDataComponents.MINECRAFT_CONTRAPTION_DATA);

            class_2350 intialOrientation = contraptionTag.method_67491("InitialOrientation", class_2350.field_29502).orElse(class_2350.field_11033);

            try (class_8942.class_11340 logging = new class_8942.class_11340(cart.method_71370(), LOGGER)) {
                Contraption mountedContraption = Contraption.fromData(
                    world,
                    class_11352.method_71417(logging, world.method_30349(), contraptionTag),
                    false
                );
                OrientedContraptionEntity contraptionEntity = newFacing == null ? OrientedContraptionEntity.create(
                    world,
                    mountedContraption,
                    intialOrientation
                ) : OrientedContraptionEntity.createAtYaw(
                    world,
                    mountedContraption,
                    intialOrientation,
                    newFacing.method_10144()
                );

                contraptionEntity.method_5804(cart);
                contraptionEntity.method_5814(cart.method_23317(), cart.method_23318(), cart.method_23321());
                world.method_8649(contraptionEntity);
            }
        }
    }

    public static class_1269 wrenchCanBeUsedToPickUpMinecartContraptions(class_1657 player, class_1268 hand, class_1297 entity) {
        if (player == null || entity == null)
            return null;
        if (!AllConfigs.server().kinetics.survivalContraptionPickup.get() && !player.method_68878())
            return null;

        class_1799 wrench = player.method_5998(hand);
        if (!wrench.method_31574(AllItems.WRENCH))
            return null;
        if (entity instanceof AbstractContraptionEntity)
            entity = entity.method_5854();
        if (!(entity instanceof class_1688 cart))
            return null;
        if (!entity.method_5805())
            return null;
        if (player instanceof DeployerPlayer dfp && dfp.isOnMinecartContraption())
            return null;
        class_1299<?> type = cart.method_5864();
        if (type != class_1299.field_6096 && type != class_1299.field_6080 && type != class_1299.field_6126)
            return null;
        List<class_1297> passengers = cart.method_5685();
        if (passengers.isEmpty() || !(passengers.getFirst() instanceof OrientedContraptionEntity oce))
            return null;
        Contraption contraption = oce.getContraption();

        if (ContraptionMovementSetting.isNoPickup(contraption.getBlocks().values())) {
            player.method_7353(
                class_2561.method_43471("create.contraption.minecart_contraption_illegal_pickup").method_27692(class_124.field_1061), true);
            return null;
        }

        class_1937 world = player.method_73183();
        if (world.method_8608()) {
            return class_1269.field_5812;
        }

        contraption.stop(world);

        for (MutablePair<class_3501, MovementContext> pair : contraption.getActors())
            if (MovementBehaviour.REGISTRY.get(pair.left.comp_1342()) instanceof PortableStorageInterfaceMovement psim)
                psim.reset(pair.right);

        class_1799 generatedStack = create(type, oce);
        generatedStack.method_57379(class_9334.field_49631, entity.method_5797());

        if (!generatedStack.method_7960()) {
            Optional<class_2520> result = class_1799.field_24671.encodeStart(world.method_30349().method_57093(class_2509.field_11560), generatedStack)
                .result();
            if (result.isPresent() && ContraptionPickupLimiting.isTooLargeForPickup(result.get())) {
                player.method_7353(
                    class_2561.method_43471("create.contraption.minecart_contraption_too_big").method_27692(class_124.field_1061),
                    true
                );
                return null;
            }
        }

        if (contraption.getBlocks().size() > 200 && player instanceof class_3222 serverPlayer)
            AllAdvancements.CART_PICKUP.trigger(serverPlayer);

        player.method_31548().method_7398(generatedStack);
        oce.method_31472();
        entity.method_31472();
        return class_1269.field_5812;
    }

    public static class_1799 create(class_1299<?> type, OrientedContraptionEntity entity) {
        class_1799 stack = class_1799.field_8037;

        if (type == class_1299.field_6096) {
            stack = AllItems.MINECART_CONTRAPTION.method_7854();
        } else if (type == class_1299.field_6080) {
            stack = AllItems.FURNACE_MINECART_CONTRAPTION.method_7854();
        } else if (type == class_1299.field_6126) {
            stack = AllItems.CHEST_MINECART_CONTRAPTION.method_7854();
        }

        if (stack.method_7960())
            return stack;

        try (class_8942.class_11340 logging = new class_8942.class_11340(entity.method_71370(), LOGGER)) {
            class_11362 view = class_11362.method_71459(logging, entity.method_56673());
            entity.getContraption().write(view, false);
            view.method_71478("UUID");
            view.method_71478("Pos");
            view.method_71478("Motion");
            view.method_71468("InitialOrientation", class_2350.field_29502, entity.getInitialOrientation());
            stack.method_57379(AllDataComponents.MINECRAFT_CONTRAPTION_DATA, view.method_71475());
        }

        return stack;
    }
}
