package com.zurrtum.create.content.contraptions.piston;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.content.contraptions.piston.MechanicalPistonBlock.PistonState;
import com.zurrtum.create.foundation.block.WrenchableDirectionalBlock;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2764;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

import static com.zurrtum.create.content.contraptions.piston.MechanicalPistonBlock.isExtensionPole;

public class MechanicalPistonHeadBlock extends WrenchableDirectionalBlock implements class_3737 {

    public static final class_2754<class_2764> TYPE = class_2741.field_12492;

    public MechanicalPistonHeadBlock(class_2251 p_i48415_1_) {
        super(p_i48415_1_);
        method_9590(method_9564().method_11657(class_2741.field_12508, false));
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> builder) {
        builder.method_11667(TYPE, class_2741.field_12508);
        super.method_9515(builder);
    }

    @Override
    public class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        return AllItems.PISTON_EXTENSION_POLE.method_7854();
    }

    @Override
    public class_2680 method_9576(class_1937 worldIn, class_2338 pos, class_2680 state, class_1657 player) {
        class_2350 direction = state.method_11654(field_10927);
        class_2338 pistonHead = pos;
        class_2338 pistonBase = null;

        for (int offset = 1; offset < MechanicalPistonBlock.maxAllowedPistonPoles(); offset++) {
            class_2338 currentPos = pos.method_10079(direction.method_10153(), offset);
            class_2680 block = worldIn.method_8320(currentPos);

            if (isExtensionPole(block) && direction.method_10166() == block.method_11654(class_2741.field_12525).method_10166())
                continue;

            if (MechanicalPistonBlock.isPiston(block) && block.method_11654(class_2741.field_12525) == direction)
                pistonBase = currentPos;

            break;
        }

        if (pistonHead != null && pistonBase != null) {
            final class_2338 basePos = pistonBase;
            class_2338.method_20437(pistonBase, pistonHead).filter(p -> !p.equals(pos) && !p.equals(basePos))
                .forEach(p -> worldIn.method_22352(p, !player.method_68878()));
            worldIn.method_8501(basePos, worldIn.method_8320(basePos).method_11657(MechanicalPistonBlock.STATE, PistonState.RETRACTED));
            if (worldIn.method_8321(basePos) instanceof MechanicalPistonBlockEntity baseBE) {
                baseBE.onLengthBroken();
            }
        }

        return super.method_9576(worldIn, pos, state, player);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return AllShapes.MECHANICAL_PISTON_HEAD.get(state.method_11654(field_10927));
    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        return state.method_11654(class_2741.field_12508) ? class_3612.field_15910.method_15729(false) : class_3612.field_15906.method_15785();
    }

    @Override
    public class_2680 method_9559(
        class_2680 state,
        class_4538 world,
        class_10225 tickView,
        class_2338 pos,
        class_2350 direction,
        class_2338 neighbourPos,
        class_2680 neighbourState,
        class_5819 random
    ) {
        if (state.method_11654(class_2741.field_12508))
            tickView.method_64312(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
        return state;
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_3610 FluidState = context.method_8045().method_8316(context.method_8037());
        return super.method_9605(context).method_11657(class_2741.field_12508, Boolean.valueOf(FluidState.method_15772() == class_3612.field_15910));
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }
}
