package com.zurrtum.create.content.contraptions.piston;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllContraptionTypes;
import com.zurrtum.create.api.contraption.BlockMovementChecks;
import com.zurrtum.create.api.contraption.ContraptionType;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.contraptions.TranslatingContraption;
import com.zurrtum.create.content.contraptions.piston.MechanicalPistonBlock.PistonState;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import org.apache.commons.lang3.tuple.Pair;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2764;
import net.minecraft.class_3499.class_3501;
import net.minecraft.class_3619;
import net.minecraft.class_5815;

import static com.zurrtum.create.content.contraptions.piston.MechanicalPistonBlock.*;
import static net.minecraft.class_2741.field_12525;

public class PistonContraption extends TranslatingContraption {

    protected int extensionLength;
    protected int initialExtensionProgress;
    protected class_2350 orientation;

    private class_238 pistonExtensionCollisionBox;
    private boolean retract;

    @Override
    public ContraptionType getType() {
        return AllContraptionTypes.PISTON;
    }

    public PistonContraption() {
    }

    public PistonContraption(class_2350 direction, boolean retract) {
        orientation = direction;
        this.retract = retract;
    }

    @Override
    public boolean assemble(class_1937 world, class_2338 pos) throws AssemblyException {
        if (!collectExtensions(world, pos, orientation))
            return false;
        int count = blocks.size();
        if (!searchMovedStructure(world, anchor, retract ? orientation.method_10153() : orientation))
            return false;
        if (blocks.size() == count) { // no new blocks added
            bounds = pistonExtensionCollisionBox;
        } else {
            bounds = bounds.method_991(pistonExtensionCollisionBox);
        }
        startMoving(world);
        return true;
    }

    private boolean collectExtensions(class_1937 world, class_2338 pos, class_2350 direction) throws AssemblyException {
        List<class_3501> poles = new ArrayList<>();
        class_2338 actualStart = pos;
        class_2680 nextBlock = world.method_8320(actualStart.method_10093(direction));
        int extensionsInFront = 0;
        class_2680 blockState = world.method_8320(pos);
        boolean sticky = isStickyPiston(blockState);

        if (!isPiston(blockState))
            return false;

        if (blockState.method_11654(MechanicalPistonBlock.STATE) == PistonState.EXTENDED) {
            while (PistonExtensionPoleBlock.PlacementHelper.get()
                .matchesAxis(nextBlock, direction.method_10166()) || isPistonHead(nextBlock) && nextBlock.method_11654(field_12525) == direction) {

                actualStart = actualStart.method_10093(direction);
                poles.add(new class_3501(actualStart, nextBlock.method_11657(field_12525, direction), null));
                extensionsInFront++;

                if (isPistonHead(nextBlock))
                    break;

                nextBlock = world.method_8320(actualStart.method_10093(direction));
                if (extensionsInFront > MechanicalPistonBlock.maxAllowedPistonPoles())
                    throw AssemblyException.tooManyPistonPoles();
            }
        }

        if (extensionsInFront == 0)
            poles.add(new class_3501(
                pos,
                AllBlocks.MECHANICAL_PISTON_HEAD.method_9564().method_11657(field_12525, direction)
                    .method_11657(class_2741.field_12492, sticky ? class_2764.field_12634 : class_2764.field_12637),
                null
            ));
        else
            poles.add(new class_3501(pos, AllBlocks.PISTON_EXTENSION_POLE.method_9564().method_11657(field_12525, direction), null));

        class_2338 end = pos;
        nextBlock = world.method_8320(end.method_10093(direction.method_10153()));
        int extensionsInBack = 0;

        while (PistonExtensionPoleBlock.PlacementHelper.get().matchesAxis(nextBlock, direction.method_10166())) {
            end = end.method_10093(direction.method_10153());
            poles.add(new class_3501(end, nextBlock.method_11657(field_12525, direction), null));
            extensionsInBack++;
            nextBlock = world.method_8320(end.method_10093(direction.method_10153()));

            if (extensionsInFront + extensionsInBack > MechanicalPistonBlock.maxAllowedPistonPoles())
                throw AssemblyException.tooManyPistonPoles();
        }

        anchor = pos.method_10079(direction, initialExtensionProgress + 1);
        extensionLength = extensionsInBack + extensionsInFront;
        initialExtensionProgress = extensionsInFront;
        pistonExtensionCollisionBox = new class_238(
            class_243.method_24954(class_2338.field_10980.method_10079(direction, -1)),
            class_243.method_24954(class_2338.field_10980.method_10079(direction, -extensionLength - 1))
        ).method_1012(1, 1, 1);

        if (extensionLength == 0)
            throw AssemblyException.noPistonPoles();

        bounds = new class_238(0, 0, 0, 0, 0, 0);

        for (class_3501 pole : poles) {
            class_2338 relPos = pole.comp_1341().method_10079(direction, -extensionsInFront);
            class_2338 localPos = relPos.method_10059(anchor);
            getBlocks().put(localPos, new class_3501(localPos, pole.comp_1342(), null));
            //pistonExtensionCollisionBox = pistonExtensionCollisionBox.union(new AABB(localPos));
        }

        return true;
    }

    @Override
    protected boolean isAnchoringBlockAt(class_2338 pos) {
        return pistonExtensionCollisionBox.method_1006(VecHelper.getCenterOf(pos.method_10059(anchor)));
    }

    @Override
    protected boolean addToInitialFrontier(class_1937 world, class_2338 pos, class_2350 direction, Queue<class_2338> frontier) throws AssemblyException {
        frontier.clear();
        boolean sticky = isStickyPiston(world.method_8320(pos.method_10079(orientation, -1)));
        boolean retracting = direction != orientation;
        if (retracting && !sticky)
            return true;
        for (int offset = 0; offset <= AllConfigs.server().kinetics.maxChassisRange.get(); offset++) {
            if (offset == 1 && retracting)
                return true;
            class_2338 currentPos = pos.method_10079(orientation, offset + initialExtensionProgress);
            if (retracting && world.method_31606(currentPos))
                return true;
            if (!world.method_8477(currentPos))
                throw AssemblyException.unloadedChunk(currentPos);
            class_2680 state = world.method_8320(currentPos);
            if (!BlockMovementChecks.isMovementNecessary(state, world, currentPos))
                return true;
            if (BlockMovementChecks.isBrittle(state) && !(state.method_26204() instanceof class_5815))
                return true;
            if (isPistonHead(state) && state.method_11654(field_12525) == direction.method_10153())
                return true;
            if (!BlockMovementChecks.isMovementAllowed(state, world, currentPos))
                if (retracting)
                    return true;
                else
                    throw AssemblyException.unmovableBlock(currentPos, state);
            if (retracting && state.method_26223() == class_3619.field_15970)
                return true;
            frontier.add(currentPos);
            if (BlockMovementChecks.isNotSupportive(state, orientation))
                return true;
        }
        return true;
    }

    @Override
    public void addBlock(class_1937 level, class_2338 pos, Pair<class_3501, class_2586> capture) {
        super.addBlock(level, pos.method_10079(orientation, -initialExtensionProgress), capture);
    }

    @Override
    public class_2338 toLocalPos(class_2338 globalPos) {
        return globalPos.method_10059(anchor).method_10079(orientation, -initialExtensionProgress);
    }

    @Override
    protected boolean customBlockPlacement(class_1936 world, class_2338 pos, class_2680 state) {
        class_2338 pistonPos = anchor.method_10079(orientation, -1);
        class_2680 pistonState = world.method_8320(pistonPos);
        class_2586 be = world.method_8321(pistonPos);
        if (pos.equals(pistonPos)) {
            if (be == null || be.method_11015())
                return true;
            if (!isExtensionPole(state) && isPiston(pistonState))
                world.method_8652(pistonPos, pistonState.method_11657(MechanicalPistonBlock.STATE, PistonState.RETRACTED), 3 | 16);
            return true;
        }
        return false;
    }

    @Override
    protected boolean customBlockRemoval(class_1936 world, class_2338 pos, class_2680 state) {
        class_2338 pistonPos = anchor.method_10079(orientation, -1);
        class_2680 blockState = world.method_8320(pos);
        if (pos.equals(pistonPos) && isPiston(blockState)) {
            world.method_8652(pos, blockState.method_11657(MechanicalPistonBlock.STATE, PistonState.MOVING), 66 | 16);
            return true;
        }
        return false;
    }

    @Override
    public void read(class_1937 world, class_11368 view, boolean spawnData) {
        super.read(world, view, spawnData);
        initialExtensionProgress = view.method_71424("InitialLength", 0);
        extensionLength = view.method_71424("ExtensionLength", 0);
        orientation = view.method_71426("Orientation", class_2350.field_29502).orElseThrow();
    }

    @Override
    public void write(class_11372 view, boolean spawnPacket) {
        super.write(view, spawnPacket);
        view.method_71465("InitialLength", initialExtensionProgress);
        view.method_71465("ExtensionLength", extensionLength);
        view.method_71468("Orientation", class_2350.field_29502, orientation);
    }

}
