package com.zurrtum.create.content.decoration.copycat;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.api.contraption.transformable.TransformableBlockEntity;
import com.zurrtum.create.api.schematic.nbt.PartialSafeNBT;
import com.zurrtum.create.api.schematic.requirement.SpecialBlockEntityItemRequirement;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.redstone.RoseQuartzLampBlock;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement.ItemUseType;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2533;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_9326;

public class CopycatBlockEntity extends SmartBlockEntity implements SpecialBlockEntityItemRequirement, TransformableBlockEntity, PartialSafeNBT {

    private class_2680 material;
    private class_1799 consumedItem;

    public CopycatBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.COPYCAT, pos, state);
        material = AllBlocks.COPYCAT_BASE.method_9564();
        consumedItem = class_1799.field_8037;
    }

    @Override
    public void method_66473(class_2338 pos, class_2680 oldState) {
        super.method_66473(pos, oldState);
        class_2248.method_9577(field_11863, pos, consumedItem);
    }

    public class_2680 getMaterial() {
        return material;
    }

    public boolean hasCustomMaterial() {
        return !getMaterial().method_27852(AllBlocks.COPYCAT_BASE);
    }

    public void setMaterial(class_2680 blockState) {
        class_2680 wrapperState = method_11010();

        if (!material.method_27852(blockState.method_26204()))
            for (class_2350 side : Iterate.directions) {
                class_2338 neighbour = field_11867.method_10093(side);
                class_2680 neighbourState = field_11863.method_8320(neighbour);
                if (neighbourState != wrapperState)
                    continue;
                if (!(field_11863.method_8321(neighbour) instanceof CopycatBlockEntity cbe))
                    continue;
                class_2680 otherMaterial = cbe.getMaterial();
                if (!otherMaterial.method_27852(blockState.method_26204()))
                    continue;
                blockState = otherMaterial;
                break;
            }

        material = blockState;
        if (!field_11863.method_8608()) {
            notifyUpdate();
            return;
        }
        redraw();
    }

    public boolean cycleMaterial() {
        if (material.method_28498(class_2533.field_11625) && material.method_61767(class_2533.field_11631, false))
            setMaterial(material.method_28493(class_2533.field_11625));
        else if (material.method_28498(class_2741.field_12525))
            setMaterial(material.method_28493(class_2741.field_12525));
        else if (material.method_28498(class_2741.field_12481))
            setMaterial(material.method_11657(
                class_2741.field_12481,
                material.method_11654(class_2741.field_12481).method_10170()
            ));
        else if (material.method_28498(class_2741.field_12496))
            setMaterial(material.method_28493(class_2741.field_12496));
        else if (material.method_28498(class_2741.field_12529))
            setMaterial(material.method_28493(class_2741.field_12529));
        else if (material.method_28498(class_2741.field_12548))
            setMaterial(material.method_28493(class_2741.field_12548));
        else if (material.method_28498(RoseQuartzLampBlock.POWERING))
            setMaterial(material.method_28493(RoseQuartzLampBlock.POWERING));
        else
            return false;

        return true;
    }

    public class_1799 getConsumedItem() {
        return consumedItem;
    }

    public void setConsumedItem(class_1799 stack) {
        consumedItem = stack.method_46651(1);
        method_5431();
    }

    private void redraw() {
        if (field_11863 != null) {
            field_11863.method_8413(method_11016(), method_11010(), method_11010(), 16);
            field_11863.method_8398().method_12130().method_15513(field_11867);
        }
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    @Override
    public ItemRequirement getRequiredItems(class_2680 state) {
        if (consumedItem.method_7960())
            return ItemRequirement.NONE;
        return new ItemRequirement(ItemUseType.CONSUME, consumedItem);
    }

    @Override
    public void transform(class_2586 be, StructureTransform transform) {
        material = transform.apply(material);
        notifyUpdate();
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);

        consumedItem = view.method_71426("Item", class_1799.field_24671).orElse(class_1799.field_8037);

        Optional<class_2680> state = view.method_71426("Material", class_2680.field_24734);
        if (state.isEmpty()) {
            consumedItem = class_1799.field_8037;
            return;
        }

        class_2680 prevMaterial = material;
        material = state.get();

        // Validate Material
        if (!clientPacket) {
            class_2680 blockState = method_11010();
            if (blockState == null)
                return;
            if (!(blockState.method_26204() instanceof CopycatBlock cb))
                return;
            class_2680 acceptedBlockState = cb.getAcceptedBlockState(field_11863, field_11867, consumedItem, null);
            if (acceptedBlockState != null && material.method_27852(acceptedBlockState.method_26204()))
                return;
            consumedItem = class_1799.field_8037;
            material = AllBlocks.COPYCAT_BASE.method_9564();
        }

        if (clientPacket && prevMaterial != material)
            redraw();
    }

    @Override
    public void writeSafe(class_11372 view) {
        super.writeSafe(view);

        class_1799 stackWithoutComponents = new class_1799(consumedItem.method_41409(), consumedItem.method_7947(), class_9326.field_49588);

        write(view, stackWithoutComponents, material);
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        write(view, consumedItem, material);
    }

    protected void write(class_11372 view, class_1799 stack, class_2680 material) {
        if (!stack.method_7960()) {
            view.method_71468("Item", class_1799.field_24671, stack);
        }
        view.method_71468("Material", class_2680.field_24734, material);
    }
}