package com.zurrtum.create.content.decoration.girder;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.kinetics.base.HorizontalAxisKineticBlock;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.block.IBE;
import net.minecraft.class_10225;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

import static net.minecraft.class_2741.field_12508;

public class GirderEncasedShaftBlock extends HorizontalAxisKineticBlock implements IBE<KineticBlockEntity>, class_3737, IWrenchable, SpecialBlockItemRequirement {

    public static final class_2746 TOP = GirderBlock.TOP;
    public static final class_2746 BOTTOM = GirderBlock.BOTTOM;

    public GirderEncasedShaftBlock(class_2251 properties) {
        super(properties);
        method_9590(method_9564().method_11657(field_12508, false).method_11657(TOP, false).method_11657(BOTTOM, false));
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder.method_11667(TOP, BOTTOM, field_12508));
    }

    @Override
    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        return AllShapes.GIRDER_BEAM_SHAFT.get(pState.method_11654(HORIZONTAL_AXIS));
    }

    @Override
    public class_265 method_25959(class_2680 pState, class_1922 pReader, class_2338 pPos) {
        return class_259.method_1084(super.method_25959(pState, pReader, pPos), AllShapes.EIGHT_VOXEL_POLE.get(class_2351.field_11052));
    }

    @Override
    public class_2680 getRotatedBlockState(class_2680 originalState, class_2350 targetedFace) {
        return AllBlocks.METAL_GIRDER.method_9564().method_11657(field_12508, originalState.method_11654(field_12508))
            .method_11657(GirderBlock.X, originalState.method_11654(HORIZONTAL_AXIS) == class_2351.field_11051)
            .method_11657(GirderBlock.Z, originalState.method_11654(HORIZONTAL_AXIS) == class_2351.field_11048)
            .method_11657(GirderBlock.AXIS, originalState.method_11654(HORIZONTAL_AXIS) == class_2351.field_11048 ? class_2351.field_11051 : class_2351.field_11048)
            .method_11657(GirderBlock.BOTTOM, originalState.method_11654(BOTTOM)).method_11657(GirderBlock.TOP, originalState.method_11654(TOP));
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        class_1269 onWrenched = super.onWrenched(state, context);
        class_1657 player = context.method_8036();
        if (onWrenched == class_1269.field_5812 && player != null && !player.method_68878())
            player.method_31548().method_7398(AllItems.SHAFT.method_7854());
        return onWrenched;
    }

    @Override
    public Class<KineticBlockEntity> getBlockEntityClass() {
        return KineticBlockEntity.class;
    }

    @Override
    public class_2591<? extends KineticBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.ENCASED_SHAFT;
    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        return state.method_11654(field_12508) ? class_3612.field_15910.method_15729(false) : class_3612.field_15906.method_15785();
    }

    @Override
    public class_2680 method_9559(
        class_2680 state,
        class_4538 world,
        class_10225 tickView,
        class_2338 pos,
        class_2350 direction,
        class_2338 neighbourPos,
        class_2680 neighbourState,
        class_5819 random
    ) {
        if (state.method_11654(field_12508))
            tickView.method_64312(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));

        class_2769<Boolean> updateProperty = direction == class_2350.field_11036 ? TOP : BOTTOM;
        if (direction.method_10166().method_10178()) {
            if (world.method_8320(pos.method_10093(direction)).method_26222(world, pos.method_10093(direction)).method_1110())
                state = state.method_11657(updateProperty, false);
            return GirderBlock.updateVerticalProperty(world, pos, state, updateProperty, neighbourState, direction);
        }

        return state;
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        class_3610 ifluidstate = level.method_8316(pos);
        class_2680 state = super.method_9605(context);
        return state.method_11657(field_12508, ifluidstate.method_15772() == class_3612.field_15910);
    }

    @Override
    public ItemRequirement getRequiredItems(class_2680 state, class_2586 be) {
        return ItemRequirement.of(AllBlocks.SHAFT.method_9564(), be).union(ItemRequirement.of(AllBlocks.METAL_GIRDER.method_9564(), be));
    }

}
