package com.zurrtum.create.content.decoration.slidingDoor;

import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.catnip.animation.LerpedFloat.Chaser;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.contraptions.elevator.ElevatorColumn;
import com.zurrtum.create.content.contraptions.elevator.ElevatorColumn.ColumnCoords;
import com.zurrtum.create.content.contraptions.elevator.ElevatorContraption;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.content.trains.station.GlobalStation;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import net.minecraft.class_1937;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3499.class_3501;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import java.lang.ref.WeakReference;

public class SlidingDoorMovementBehaviour extends MovementBehaviour {
    @Override
    public boolean mustTickWhileDisabled() {
        return true;
    }

    @Override
    public void tick(MovementContext context) {
        class_3501 structureBlockInfo = context.contraption.getBlocks().get(context.localPos);
        if (structureBlockInfo == null)
            return;
        boolean open = SlidingDoorBlockEntity.isOpen(structureBlockInfo.comp_1342());

        if (!context.world.method_8608()) {
            tickOpen(context, open);
            return;
        }

        if (!(AllClientHandle.INSTANCE.getBlockEntityClientSide(context.contraption, context.localPos) instanceof SlidingDoorBlockEntity sdbe))
            return;
        boolean wasSettled = sdbe.animation.settled();
        sdbe.animation.chase(open ? 1 : 0, .15f, Chaser.LINEAR);
        sdbe.animation.tickChaser();

        if (!wasSettled && sdbe.animation.settled() && !open)
            context.world.method_8486(
                context.position.field_1352,
                context.position.field_1351,
                context.position.field_1350,
                class_3417.field_14819,
                class_3419.field_15245,
                .125f,
                1,
                false
            );
    }

    protected void tickOpen(MovementContext context, boolean currentlyOpen) {
        boolean shouldOpen = shouldOpen(context);
        if (!shouldUpdate(context, shouldOpen))
            return;
        if (currentlyOpen == shouldOpen)
            return;

        class_2338 pos = context.localPos;
        Contraption contraption = context.contraption;

        class_3501 info = contraption.getBlocks().get(pos);
        if (info == null || !info.comp_1342().method_28498(class_2323.field_10945))
            return;

        toggleDoor(pos, contraption, info);

        class_2350 facing = getDoorFacing(context);
        class_2338 inWorldDoor = class_2338.method_49638(context.position).method_10093(facing);
        class_2680 inWorldDoorState = context.world.method_8320(inWorldDoor);
        if (inWorldDoorState.method_26204() instanceof class_2323 db && inWorldDoorState.method_28498(class_2323.field_10945))
            if (inWorldDoorState.method_28498(class_2323.field_10938) && inWorldDoorState.method_61767(class_2323.field_10938, class_2350.field_11036)
                .method_10166() == facing.method_10166())
                db.method_10033(null, context.world, inWorldDoorState, inWorldDoor, shouldOpen);

        if (shouldOpen)
            context.world.method_8396(null, class_2338.method_49638(context.position), class_3417.field_14567, class_3419.field_15245, .125f, 1);
    }

    private void toggleDoor(class_2338 pos, Contraption contraption, class_3501 info) {
        class_2680 newState = info.comp_1342().method_28493(class_2323.field_10945);
        contraption.entity.setBlock(pos, new class_3501(info.comp_1341(), newState, info.comp_1343()));

        class_2338 otherPos = newState.method_11654(class_2323.field_10946) == class_2756.field_12607 ? pos.method_10084() : pos.method_10074();
        info = contraption.getBlocks().get(otherPos);
        if (info != null && info.comp_1342().method_28498(class_2323.field_10945)) {
            newState = info.comp_1342().method_28493(class_2323.field_10945);
            contraption.entity.setBlock(otherPos, new class_3501(info.comp_1341(), newState, info.comp_1343()));
            contraption.invalidateColliders();
        }
    }

    protected boolean shouldUpdate(MovementContext context, boolean shouldOpen) {
        if (context.firstMovement && shouldOpen)
            return false;
        if (!context.data.method_10545("Open")) {
            context.data.method_10556("Open", shouldOpen);
            return true;
        }
        boolean wasOpen = context.data.method_68566("Open", false);
        context.data.method_10556("Open", shouldOpen);
        return wasOpen != shouldOpen;
    }

    protected boolean shouldOpen(MovementContext context) {
        if (context.disabled)
            return false;
        Contraption contraption = context.contraption;
        boolean canOpen = context.motion.method_1033() < 1 / 128f && !contraption.entity.isStalled() || contraption instanceof ElevatorContraption ec && ec.arrived;

        if (!canOpen) {
            context.temporaryData = null;
            return false;
        }

        if (context.temporaryData instanceof WeakReference<?> wr && wr.get() instanceof DoorControlBehaviour dcb)
            if (dcb.blockEntity != null && !dcb.blockEntity.method_11015())
                return shouldOpenAt(dcb, context);

        context.temporaryData = null;
        DoorControlBehaviour doorControls = null;

        if (contraption instanceof ElevatorContraption ec)
            doorControls = getElevatorDoorControl(ec, context);
        if (context.contraption.entity instanceof CarriageContraptionEntity cce)
            doorControls = getTrainStationDoorControl(cce, context);

        if (doorControls == null)
            return false;

        context.temporaryData = new WeakReference<>(doorControls);
        return shouldOpenAt(doorControls, context);
    }

    protected boolean shouldOpenAt(DoorControlBehaviour controller, MovementContext context) {
        if (controller.mode == DoorControl.ALL)
            return true;
        if (controller.mode == DoorControl.NONE)
            return false;
        return controller.mode.matches(getDoorFacing(context));
    }

    protected DoorControlBehaviour getElevatorDoorControl(ElevatorContraption ec, MovementContext context) {
        Integer currentTargetY = ec.getCurrentTargetY(context.world);
        if (currentTargetY == null)
            return null;
        ColumnCoords columnCoords = ec.getGlobalColumn();
        if (columnCoords == null)
            return null;
        ElevatorColumn elevatorColumn = ElevatorColumn.get(context.world, columnCoords);
        if (elevatorColumn == null)
            return null;
        return BlockEntityBehaviour.get(context.world, elevatorColumn.contactAt(currentTargetY), DoorControlBehaviour.TYPE);
    }

    protected DoorControlBehaviour getTrainStationDoorControl(CarriageContraptionEntity cce, MovementContext context) {
        Carriage carriage = cce.getCarriage();
        if (carriage == null || carriage.train == null)
            return null;
        GlobalStation currentStation = carriage.train.getCurrentStation();
        if (currentStation == null)
            return null;

        class_2338 stationPos = currentStation.getBlockEntityPos();
        class_5321<class_1937> stationDim = currentStation.getBlockEntityDimension();
        MinecraftServer server = context.world.method_8503();
        if (server == null)
            return null;
        class_3218 stationLevel = server.method_3847(stationDim);
        if (stationLevel == null || !stationLevel.method_8477(stationPos))
            return null;
        return BlockEntityBehaviour.get(stationLevel, stationPos, DoorControlBehaviour.TYPE);
    }

    protected class_2350 getDoorFacing(MovementContext context) {
        class_2350 stateFacing = context.state.method_11654(class_2323.field_10938);
        class_2350 originalFacing = class_2350.method_10156(class_2352.field_11056, stateFacing.method_10166());
        class_243 centerOfContraption = context.contraption.bounds.method_1005();
        class_243 diff = class_243.method_24953(context.localPos).method_1019(class_243.method_24954(stateFacing.method_62675()).method_1021(-.45f))
            .method_1020(centerOfContraption);
        if (originalFacing.method_10166().method_10172(diff.field_1352, diff.field_1351, diff.field_1350) < 0)
            originalFacing = originalFacing.method_10153();

        class_243 directionVec = class_243.method_24954(originalFacing.method_62675());
        directionVec = context.rotation.apply(directionVec);
        return class_2350.method_10142(directionVec.field_1352, directionVec.field_1351, directionVec.field_1350);
    }

}
