package com.zurrtum.create.content.equipment.sandPaper;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllRecipeSets;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.infrastructure.component.SandPaperItemComponent;
import net.minecraft.class_10290;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2392;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3959.class_242;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import net.minecraft.class_5953;
import net.minecraft.class_6088;
import net.minecraft.class_9696;
import net.minecraft.world.item.*;
import java.util.Optional;

public class SandPaperItem extends class_1792 {

    public SandPaperItem(class_1793 properties) {
        super(properties);
    }

    @Override
    public class_1269 method_7836(class_1937 worldIn, class_1657 playerIn, class_1268 handIn) {
        class_1799 itemstack = playerIn.method_5998(handIn);

        if (itemstack.method_57826(AllDataComponents.SAND_PAPER_POLISHING)) {
            playerIn.method_6019(handIn);
            return class_1269.field_5811;
        }

        class_1268 otherHand = handIn == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808;
        class_1799 itemInOtherHand = playerIn.method_5998(otherHand);
        class_10290 recipe = worldIn.method_8433().method_64678(AllRecipeSets.SAND_PAPER_POLISHING);
        if (recipe.method_64701(itemInOtherHand)) {
            class_1799 item = itemInOtherHand.method_7972();
            class_1799 toPolish = item.method_7971(1);
            playerIn.method_6019(handIn);
            itemstack.method_57379(AllDataComponents.SAND_PAPER_POLISHING, new SandPaperItemComponent(toPolish));
            playerIn.method_6122(otherHand, item);
            return class_1269.field_5812.method_61393(itemstack);
        }

        class_3965 raytraceresult = method_7872(worldIn, playerIn, class_242.field_1348);
        class_243 hitVec = raytraceresult.method_17784();

        class_238 bb = new class_238(hitVec, hitVec).method_1014(1f);
        class_1542 pickUp = null;
        for (class_1542 itemEntity : worldIn.method_18467(class_1542.class, bb)) {
            if (!itemEntity.method_5805())
                continue;
            if (itemEntity.method_73189().method_1022(playerIn.method_73189()) > 3)
                continue;
            class_1799 stack = itemEntity.method_6983();
            if (!recipe.method_64701(stack))
                continue;
            pickUp = itemEntity;
            break;
        }

        if (pickUp == null)
            return class_1269.field_5814;

        class_1799 item = pickUp.method_6983().method_7972();
        class_1799 toPolish = item.method_7971(1);

        playerIn.method_6019(handIn);

        if (!worldIn.method_8608()) {
            itemstack.method_57379(AllDataComponents.SAND_PAPER_POLISHING, new SandPaperItemComponent(toPolish));
            if (item.method_7960())
                pickUp.method_31472();
            else
                pickUp.method_6979(item);
        }

        return class_1269.field_5812.method_61393(itemstack);
    }

    @Override
    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        class_5819 random = user.method_59922();
        if (stack.method_57826(AllDataComponents.SAND_PAPER_POLISHING)) {
            class_1799 polishing = stack.method_58694(AllDataComponents.SAND_PAPER_POLISHING).item();
            if (!polishing.method_7960())
                user.method_6037(polishing, 1);
        }

        // After 6 ticks play the sound every 7th
        if ((user.method_6048() - 6) % 7 == 0) {
            user.method_5783(AllSoundEvents.SANDING_SHORT.getMainEvent(), 0.9F + 0.2F * random.method_43057(), random.method_43057() * 0.2F + 0.9F);
        }
    }

    @Override
    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 entityLiving) {
        if (!(entityLiving instanceof class_1657 player))
            return stack;
        SandPaperItemComponent component = stack.method_58694(AllDataComponents.SAND_PAPER_POLISHING);
        if (component == null)
            return stack;
        class_1799 toPolish = component.item();

        if (world.method_8608()) {
            spawnParticles(entityLiving.method_5836(1).method_1019(entityLiving.method_5720().method_1021(.5f)), toPolish, world);
            return stack;
        }

        class_9696 input = new class_9696(toPolish);
        ((class_3218) world).method_64577().method_8132(AllRecipeTypes.SANDPAPER_POLISHING, input, world).ifPresent(recipe -> {
            class_1799 polished = recipe.comp_1933().assemble(input, world.method_30349());
            class_1661 playerInv = player.method_31548();
            if (!polished.method_7960()) {
                playerInv.method_7398(polished);
            }
            class_1799 recipeRemainder = toPolish.method_7909().method_7858();
            if (!recipeRemainder.method_7960()) {
                playerInv.method_7398(recipeRemainder);
            }
        });

        stack.method_57381(AllDataComponents.SAND_PAPER_POLISHING);
        stack.method_7970(1, entityLiving, entityLiving.method_6058().method_73186());

        return stack;
    }

    public static void spawnParticles(class_243 location, class_1799 polishedStack, class_1937 world) {
        for (int i = 0; i < 20; i++) {
            class_243 motion = VecHelper.offsetRandomly(class_243.field_1353, world.field_9229, 1 / 8f);
            world.method_8406(
                new class_2392(class_2398.field_11218, polishedStack),
                location.field_1352,
                location.field_1351,
                location.field_1350,
                motion.field_1352,
                motion.field_1351,
                motion.field_1350
            );
        }
    }

    @Override
    public boolean method_7840(class_1799 stack, class_1937 worldIn, class_1309 entityLiving, int timeLeft) {
        if (!(entityLiving instanceof class_1657 player))
            return false;
        if (stack.method_57826(AllDataComponents.SAND_PAPER_POLISHING)) {
            class_1799 toPolish = stack.method_58694(AllDataComponents.SAND_PAPER_POLISHING).item();
            //noinspection DataFlowIssue - toPolish won't be null as we do call .has before calling .get
            player.method_31548().method_7398(toPolish);
            stack.method_57381(AllDataComponents.SAND_PAPER_POLISHING);
        }
        return false;
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        class_1657 player = context.method_8036();
        class_1799 stack = context.method_8041();
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2680 state = level.method_8320(pos);

        Optional<class_2680> newState = ((class_1743) class_1802.field_8556).method_34716(state);
        if (newState.isPresent()) {
            AllSoundEvents.SANDING_LONG.play(level, player, pos, 1, 1 + (level.field_9229.method_43057() * 0.5f - 1f) / 5f);
            level.method_8444(player, class_6088.field_31158, pos, 0); // Spawn particles
        } else {
            newState = Optional.ofNullable(class_5953.field_29561.get().get(state.method_26204())).map(block -> block.method_34725(state));

            if (newState.isPresent()) {
                AllSoundEvents.SANDING_LONG.play(level, player, pos, 1, 1 + (level.field_9229.method_43057() * 0.5f - 1f) / 5f);
                level.method_8444(player, class_6088.field_31157, pos, 0); // Spawn particles
            }
        }

        if (newState.isPresent()) {
            level.method_8501(pos, newState.get());
            if (player != null)
                stack.method_7970(1, player, player.method_6058().method_73186());
            return class_1269.field_5812;
        }

        return class_1269.field_5811;
    }

    @Override
    public int method_7881(class_1799 stack, class_1309 user) {
        return 32;
    }

    @Override
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8950;
    }
}
