package com.zurrtum.create.content.equipment.toolbox;

import com.zurrtum.create.AllMenuTypes;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.animatedContainer.AnimatedContainerBehaviour;
import com.zurrtum.create.foundation.gui.menu.MenuBase;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;

import static com.zurrtum.create.content.equipment.toolbox.ToolboxInventory.STACKS_PER_COMPARTMENT;

public class ToolboxMenu extends MenuBase<ToolboxBlockEntity> {
    public ToolboxMenu(int id, class_1661 inv, ToolboxBlockEntity be) {
        super(AllMenuTypes.TOOLBOX, id, inv, be);
        BlockEntityBehaviour.get(be, AnimatedContainerBehaviour.TYPE).startOpen(player);
    }

    @Override
    public class_1799 method_7601(class_1657 player, int index) {
        class_1735 clickedSlot = method_7611(index);
        class_1799 stack = clickedSlot.method_7677();
        int size = contentHolder.inventory.method_5439();
        boolean success;
        if (index < size) {
            stack = settle(stack, index);
            if (stack.method_7960()) {
                return stack;
            }
            success = !method_7616(stack, size, field_7761.size(), true);
            contentHolder.inventory.method_5431();
        } else {
            if (stack.method_7960()) {
                return stack;
            }
            success = !method_7616(stack, 0, size, false);
        }

        return success ? class_1799.field_8037 : stack;
    }

    public class_1799 settle(class_1799 stack, int index) {
        int count = stack.method_7947();
        int space;
        if (count == 0) {
            class_1799 filter = contentHolder.inventory.filters.get(index / STACKS_PER_COMPARTMENT);
            if (filter.method_7960()) {
                return stack;
            }
            space = filter.method_7914();
        } else {
            space = stack.method_7914() - count;
        }
        if (space != 0) {
            class_1799 extract = contentHolder.inventory.takeFromCompartment(space, index + 1, index + STACKS_PER_COMPARTMENT - 1);
            if (!extract.method_7960()) {
                if (count == 0) {
                    stack = extract;
                    contentHolder.inventory.method_5447(index, stack);
                } else {
                    stack.method_7939(count + extract.method_7947());
                }
            }
        }
        return stack;
    }

    @Override
    protected void initAndReadInventory(ToolboxBlockEntity contentHolder) {
    }

    @Override
    public void method_7593(int index, int flags, class_1713 type, class_1657 player) {
        if (index >= 0 && index < contentHolder.inventory.method_5439()) {
            class_1799 itemInClickedSlot = method_7611(index).method_7677();
            class_1799 carried = method_34255();

            if (type == class_1713.field_7790 && !carried.method_7960() && !itemInClickedSlot.method_7960() && ToolboxInventory.canItemsShareCompartment(itemInClickedSlot,
                carried
            )) {
                int subIndex = index % STACKS_PER_COMPARTMENT;
                if (subIndex != STACKS_PER_COMPARTMENT - 1) {
                    method_7593(index - subIndex + STACKS_PER_COMPARTMENT - 1, flags, type, player);
                    return;
                }
            }

            if (type == class_1713.field_7790 && carried.method_7960() && settle(itemInClickedSlot, index).method_7960() && !player.method_73183().method_8608()) {
                contentHolder.inventory.filters.set(index / STACKS_PER_COMPARTMENT, class_1799.field_8037);
                contentHolder.sendData();
            }

        }
        super.method_7593(index, flags, type, player);
    }

    @Override
    public boolean method_7615(class_1735 slot) {
        return slot.field_7874 > contentHolder.inventory.method_5439();
    }

    public class_1799 getFilter(int compartment) {
        return contentHolder.inventory.filters.get(compartment);
    }

    public int totalCountInCompartment(int compartment) {
        int count = 0;
        int baseSlot = compartment * STACKS_PER_COMPARTMENT;
        for (int i = 0; i < STACKS_PER_COMPARTMENT; i++)
            count += method_7611(baseSlot + i).method_7677().method_7947();
        return count;
    }

    public boolean renderPass;

    @Override
    protected void addSlots() {
        ToolboxInventory inventory = contentHolder.inventory;

        int x = 79;
        int y = 37;

        int[] xOffsets = {x, x + 33, x + 66, x + 66 + 6, x + 66, x + 33, x, x - 6};
        int[] yOffsets = {y, y - 6, y, y + 33, y + 66, y + 66 + 6, y + 66, y + 33};

        for (int compartment = 0; compartment < 8; compartment++) {
            int baseIndex = compartment * STACKS_PER_COMPARTMENT;

            // Representative Slots
            method_7621(new ToolboxSlot(this, inventory, baseIndex, xOffsets[compartment], yOffsets[compartment], true));

            // Hidden Slots
            for (int i = 1; i < STACKS_PER_COMPARTMENT; i++)
                method_7621(new ToolboxSlot(this, inventory, baseIndex + i, -10000, -10000, false));
        }

        addPlayerSlots(8, 165);
    }

    @Override
    protected void saveData(ToolboxBlockEntity contentHolder) {

    }

    @Override
    public void method_7595(class_1657 playerIn) {
        super.method_7595(playerIn);
        if (!playerIn.method_73183().method_8608())
            BlockEntityBehaviour.get(contentHolder, AnimatedContainerBehaviour.TYPE).stopOpen(playerIn);
    }

}
