package com.zurrtum.create.content.fluids.pipes;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.contraptions.StructureTransform;

import java.util.Map;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2429;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2746;

public class FluidPipeBlockRotation {

    public static final Map<class_2350, class_2746> FACING_TO_PROPERTY_MAP = class_2429.field_11329;

    public static class_2680 rotate(class_2680 state, class_2470 rotation) {
        class_2680 rotated = state;
        for (class_2350 direction : Iterate.horizontalDirections)
            rotated = rotated.method_11657(FACING_TO_PROPERTY_MAP.get(rotation.method_10503(direction)), state.method_11654(FACING_TO_PROPERTY_MAP.get(direction)));
        return rotated;
    }

    public static class_2680 mirror(class_2680 state, class_2415 mirror) {
        class_2680 mirrored = state;
        for (class_2350 direction : Iterate.horizontalDirections)
            mirrored = mirrored.method_11657(FACING_TO_PROPERTY_MAP.get(mirror.method_10343(direction)), state.method_11654(FACING_TO_PROPERTY_MAP.get(direction)));
        return mirrored;
    }

    public static class_2680 transform(class_2680 state, StructureTransform transform) {
        if (transform.mirror != null)
            state = mirror(state, transform.mirror);

        if (transform.rotationAxis == class_2350.class_2351.field_11052)
            return rotate(state, transform.rotation);

        class_2680 rotated = state;
        for (class_2350 direction : Iterate.directions)
            rotated = rotated.method_11657(
                FACING_TO_PROPERTY_MAP.get(transform.rotateFacing(direction)),
                state.method_11654(FACING_TO_PROPERTY_MAP.get(direction))
            );
        return rotated;
    }

}
