package com.zurrtum.create.content.fluids.potion;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllFluids;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.foundation.fluid.FluidIngredient;
import com.zurrtum.create.foundation.fluid.FluidStackIngredient;
import com.zurrtum.create.infrastructure.component.BottleType;
import com.zurrtum.create.infrastructure.fluids.BottleFluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import net.minecraft.class_124;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_2561;
import net.minecraft.class_3612;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import net.minecraft.world.item.*;

public class PotionFluidHandler {
    private static final class_2561 NO_EFFECT = class_2561.method_43471("effect.none").method_27692(class_124.field_1080);

    public static boolean isPotionItem(class_1799 stack) {
        return stack.method_7909() instanceof class_1812 && !(stack.method_7909().method_7858().method_7909() instanceof class_1755) && !stack.method_31573(
            AllItemTags.NOT_POTION);
    }

    public static Pair<FluidStack, class_1799> emptyPotion(class_1799 stack, boolean simulate) {
        FluidStack fluid = getFluidFromPotionItem(stack);
        if (!simulate)
            stack.method_7934(1);
        return Pair.of(fluid, new class_1799(class_1802.field_8469));
    }

    //TODO
    //    public static FluidIngredient potionIngredient(Holder<Potion> potion, int amount) {
    //        return FluidIngredient.fromFluidStack(FluidHelper.copyStackWithAmount(PotionFluidHandler
    //            .getFluidFromPotionItem(PotionContents.createItemStack(Items.POTION, potion)), amount));
    //    }

    public static FluidStack getFluidFromPotionItem(class_1799 stack) {
        class_1844 potion = stack.method_58695(class_9334.field_49651, class_1844.field_49274);
        BottleType bottleTypeFromItem = bottleTypeFromItem(stack.method_7909());
        if (potion.method_57401(class_1847.field_8991) && potion.comp_2380().isEmpty() && bottleTypeFromItem == BottleType.REGULAR)
            return new FluidStack(class_3612.field_15910, BottleFluidInventory.CAPACITY);
        FluidStack fluid = getFluidFromPotion(potion, bottleTypeFromItem, BottleFluidInventory.CAPACITY);
        fluid.set(AllDataComponents.POTION_FLUID_BOTTLE_TYPE, bottleTypeFromItem);
        return fluid;
    }

    public static FluidIngredient getFluidIngredientFromPotion(class_1844 potionContents, BottleType bottleType, int amount) {
        if (potionContents.method_57401(class_1847.field_8991) && bottleType == BottleType.REGULAR)
            return new FluidStackIngredient(class_3612.field_15910, class_9326.field_49588, amount);
        return getFluidIngredient(amount, potionContents, bottleType);
    }

    public static FluidStack getFluidFromPotion(class_1844 potionContents, BottleType bottleType, int amount) {
        if (potionContents.method_57401(class_1847.field_8991) && bottleType == BottleType.REGULAR)
            return new FluidStack(class_3612.field_15910, amount);
        return getFluidStack(amount, potionContents, bottleType);
    }

    public static FluidIngredient getFluidIngredient(int amount, class_1844 potionContents, BottleType bottleType) {
        class_9326.class_9327 builder = class_9326.method_57841();
        if (potionContents != class_1844.field_49274) {
            builder.method_57854(class_9334.field_49651, potionContents);
        }
        builder.method_57854(AllDataComponents.POTION_FLUID_BOTTLE_TYPE, bottleType);
        return new FluidStackIngredient(AllFluids.POTION, builder.method_57852(), amount);
    }

    public static FluidStack getFluidStack(int amount, class_1844 potionContents, BottleType bottleType) {
        FluidStack fluidStack = new FluidStack(AllFluids.POTION, amount);
        addPotionToFluidStack(fluidStack, potionContents);
        fluidStack.set(AllDataComponents.POTION_FLUID_BOTTLE_TYPE, bottleType);
        return fluidStack;
    }

    public static void addPotionToFluidStack(FluidStack fs, class_1844 potionContents) {
        if (potionContents == class_1844.field_49274) {
            fs.remove(class_9334.field_49651);
            return;
        }
        fs.set(class_9334.field_49651, potionContents);
    }

    public static BottleType bottleTypeFromItem(class_1792 item) {
        if (item == class_1802.field_8150)
            return BottleType.LINGERING;
        if (item == class_1802.field_8436)
            return BottleType.SPLASH;
        return BottleType.REGULAR;
    }

    public static class_1792 itemFromBottleType(BottleType type) {
        return switch (type) {
            case LINGERING -> class_1802.field_8150;
            case SPLASH -> class_1802.field_8436;
            default -> class_1802.field_8574;
        };
    }

    public static int getRequiredAmountForFilledBottle(class_1799 stack, FluidStack availableFluid) {
        return BottleFluidInventory.CAPACITY;
    }

    public static class_1799 fillBottle(class_1799 stack, FluidStack availableFluid) {
        class_1799 potionStack = new class_1799(itemFromBottleType(availableFluid.method_58695(
            AllDataComponents.POTION_FLUID_BOTTLE_TYPE,
            BottleType.REGULAR
        )));
        potionStack.method_57379(class_9334.field_49651, availableFluid.method_58694(class_9334.field_49651));
        return potionStack;
    }

    //TODO
    //    @OnlyIn(Dist.CLIENT)
    //    public static void addPotionTooltip(FluidStack fs, Consumer<Component> tooltipAdder, float durationFactor) {
    //        PotionContents contents = fs.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
    //        Iterable<MobEffectInstance> effects = contents.getAllEffects();
    //
    //        List<Pair<Holder<Attribute>, AttributeModifier>> list = Lists.newArrayList();
    //
    //        boolean flag = true;
    //        for (MobEffectInstance mobeffectinstance : effects) {
    //            flag = false;
    //            MutableComponent mutablecomponent = Component.translatable(mobeffectinstance.getDescriptionId());
    //            Holder<MobEffect> holder = mobeffectinstance.getEffect();
    //            holder.value().createModifiers(mobeffectinstance.getAmplifier(), (h, m) -> list.add(Pair.of(h, m)));
    //            if (mobeffectinstance.getAmplifier() > 0) {
    //                mutablecomponent.append(" ").append(Component.translatable("potion.potency." + mobeffectinstance.getAmplifier()).getString());
    //            }
    //
    //            if (!mobeffectinstance.endsWithin(20)) {
    //                mutablecomponent.append(" (").append(MobEffectUtil.formatDuration(
    //                    mobeffectinstance,
    //                    durationFactor,
    //                    Minecraft.getInstance().level.tickRateManager().tickrate()
    //                )).append(")");
    //            }
    //
    //            tooltipAdder.accept(mutablecomponent.withStyle(holder.value().getCategory().getTooltipFormatting()));
    //        }
    //
    //        if (flag)
    //            tooltipAdder.accept(NO_EFFECT);
    //
    //        if (!list.isEmpty()) {
    //            tooltipAdder.accept(CommonComponents.EMPTY);
    //            tooltipAdder.accept((Component.translatable("potion.whenDrank")).withStyle(ChatFormatting.DARK_PURPLE));
    //
    //            for (Pair<Holder<Attribute>, AttributeModifier> pair : list) {
    //                AttributeModifier attributemodifier = pair.getSecond();
    //                double d1 = attributemodifier.amount();
    //                double d0;
    //                if (attributemodifier.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_BASE && attributemodifier.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL) {
    //                    d0 = attributemodifier.amount();
    //                } else {
    //                    d0 = attributemodifier.amount() * 100.0D;
    //                }
    //
    //                if (d1 > 0.0D) {
    //                    tooltipAdder.accept((Component.translatable(
    //                        "attribute.modifier.plus." + attributemodifier.operation().id(),
    //                        ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(d0),
    //                        Component.translatable(pair.getFirst().value().getDescriptionId())
    //                    )).withStyle(ChatFormatting.BLUE));
    //                } else if (d1 < 0.0D) {
    //                    d0 = d0 * -1.0D;
    //                    tooltipAdder.accept((Component.translatable(
    //                        "attribute.modifier.take." + attributemodifier.operation().id(),
    //                        ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(d0),
    //                        Component.translatable(pair.getFirst().value().getDescriptionId())
    //                    )).withStyle(ChatFormatting.RED));
    //                }
    //            }
    //        }
    //    }
}
