package com.zurrtum.create.content.fluids.spout;

import com.zurrtum.create.AllRecipeSets;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.content.fluids.transfer.FillingInput;
import com.zurrtum.create.content.fluids.transfer.FillingRecipe;
import com.zurrtum.create.content.fluids.transfer.GenericItemFilling;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_8786;

public class FillingBySpout {
    public static boolean canItemBeFilled(class_1937 world, class_1799 stack) {
        if (world.method_8433().method_64678(AllRecipeSets.FILLING).method_64701(stack)) {
            return true;
        }
        return GenericItemFilling.canItemBeFilled(world, stack);
    }

    public static int getRequiredAmountForItem(class_3218 world, class_1799 stack, FluidStack availableFluid) {
        FillingInput input = new FillingInput(stack, availableFluid);
        Optional<class_8786<FillingRecipe>> findRecipe = world.method_64577().method_8132(AllRecipeTypes.FILLING, input, world);
        return findRecipe.map(fillingRecipeRecipeEntry -> fillingRecipeRecipeEntry.comp_1933().fluidIngredient().amount())
            .orElseGet(() -> GenericItemFilling.getRequiredAmountForItem(world, stack, availableFluid));
    }

    public static class_1799 fillItem(class_3218 world, int requiredAmount, class_1799 stack, FluidStack availableFluid) {
        FluidStack toFill = availableFluid.copy();
        toFill.setAmount(requiredAmount);
        FillingInput input = new FillingInput(stack, toFill);
        Optional<class_8786<FillingRecipe>> findRecipe = world.method_64577().method_8132(AllRecipeTypes.FILLING, input, world);
        if (findRecipe.isPresent()) {
            FillingRecipe recipe = findRecipe.get().comp_1933();
            class_1799 result = recipe.assemble(input, world.method_30349());
            availableFluid.decrement(recipe.fluidIngredient().amount());
            stack.method_7934(1);
            return result;
        }

        return GenericItemFilling.fillItem(world, requiredAmount, stack, availableFluid);
    }
}
