package com.zurrtum.create.content.fluids.transfer;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.BBHelper;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.infrastructure.fluids.BucketFluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import java.util.*;
import net.minecraft.class_11368;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3341;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;


public class FluidDrainingBehaviour extends FluidManipulationBehaviour {

    public static final BehaviourType<FluidDrainingBehaviour> TYPE = new BehaviourType<>();

    class_3611 fluid;

    // Execution
    Set<class_2338> validationSet;
    PriorityQueue<BlockPosEntry> queue;
    boolean isValid;

    // Validation
    List<BlockPosEntry> validationFrontier;
    Set<class_2338> validationVisited;
    Set<class_2338> newValidationSet;

    public FluidDrainingBehaviour(SmartBlockEntity be) {
        super(be);
        validationVisited = new HashSet<>();
        validationFrontier = new ArrayList<>();
        validationSet = new HashSet<>();
        newValidationSet = new HashSet<>();
        queue = new ObjectHeapPriorityQueue<>(this::comparePositions);
    }

    public boolean pullNext(class_2338 root, boolean simulate) {
        if (!frontier.isEmpty())
            return false;
        if (!Objects.equals(root, rootPos)) {
            rebuildContext(root);
            return false;
        }

        if (counterpartActed) {
            counterpartActed = false;
            softReset(root);
            return false;
        }

        if (affectedArea == null)
            affectedArea = class_3341.method_34390(root, root);

        class_1937 world = getLevel();
        if (!queue.isEmpty() && !isValid) {
            rebuildContext(root);
            return false;
        }

        if (validationFrontier.isEmpty() && !queue.isEmpty() && !simulate && revalidateIn == 0)
            revalidate(root);

        if (!simulate && infinite) {
            blockEntity.award(AllAdvancements.HOSE_PULLEY);
            if (FluidHelper.isLava(fluid))
                blockEntity.award(AllAdvancements.HOSE_PULLEY_LAVA);

            playEffect(world, root, fluid, true);
            return true;
        }

        while (!queue.isEmpty()) {
            // Dont dequeue here, so we can decide not to dequeue a valid entry when
            // simulating
            class_2338 currentPos = queue.first().pos();

            class_2680 blockState = world.method_8320(currentPos);
            class_2680 emptied = blockState;
            class_3611 fluid = class_3612.field_15906;

            if (blockState.method_28498(class_2741.field_12508) && blockState.method_11654(class_2741.field_12508)) {
                emptied = blockState.method_11657(class_2741.field_12508, Boolean.valueOf(false));
                fluid = class_3612.field_15910;
            } else if (blockState.method_26204() instanceof class_2404 flowingFluid) {
                emptied = class_2246.field_10124.method_9564();
                if (blockState.method_11654(class_2404.field_11278) == 0)
                    fluid = flowingFluid.field_11279;
                else {
                    affectedArea = BBHelper.encapsulate(affectedArea, class_3341.method_34390(currentPos, currentPos));
                    if (!blockEntity.isVirtual())
                        world.method_8652(currentPos, emptied, 2 | 16);
                    queue.dequeue();
                    if (queue.isEmpty()) {
                        isValid = checkValid(world, rootPos);
                        reset();
                    }
                    continue;
                }
            } else if (blockState.method_26227().method_15772() != class_3612.field_15906 && blockState.method_26194(
                world,
                currentPos,
                class_3726.method_16194()
            ).method_1110()) {
                fluid = blockState.method_26227().method_15772();
                emptied = class_2246.field_10124.method_9564();
            }

            if (this.fluid == null)
                this.fluid = fluid;

            if (!this.fluid.method_15780(fluid)) {
                queue.dequeue();
                if (queue.isEmpty()) {
                    isValid = checkValid(world, rootPos);
                    reset();
                }
                continue;
            }

            if (simulate)
                return true;

            playEffect(world, currentPos, fluid, true);
            blockEntity.award(AllAdvancements.HOSE_PULLEY);

            if (!blockEntity.isVirtual()) {
                world.method_8652(currentPos, emptied, 2 | 16);

                class_2680 stateAbove = world.method_8320(currentPos.method_10084());
                if (stateAbove.method_26227().method_15772() == class_3612.field_15906 && !stateAbove.method_26184(world, currentPos.method_10084()))
                    world.method_8652(currentPos.method_10084(), class_2246.field_10124.method_9564(), 2 | 16);
            }
            affectedArea = BBHelper.encapsulate(affectedArea, currentPos);

            queue.dequeue();
            if (queue.isEmpty()) {
                isValid = checkValid(world, rootPos);
                reset();
            } else if (!validationSet.contains(currentPos)) {
                reset();
            }
            return true;
        }

        if (rootPos == null)
            return false;

        if (isValid)
            rebuildContext(root);

        return false;
    }

    protected void softReset(class_2338 root) {
        queue.clear();
        validationSet.clear();
        newValidationSet.clear();
        validationFrontier.clear();
        validationVisited.clear();
        visited.clear();
        infinite = false;
        setValidationTimer();
        frontier.add(new BlockPosEntry(root, 0));
        blockEntity.sendData();
    }

    protected boolean checkValid(class_1937 world, class_2338 root) {
        class_2338 currentPos = root;
        for (int timeout = 1000; timeout > 0 && !root.equals(blockEntity.method_11016()); timeout--) {
            FluidBlockType canPullFluidsFrom = canPullFluidsFrom(world.method_8320(currentPos), currentPos);
            if (canPullFluidsFrom == FluidBlockType.FLOWING) {
                for (class_2350 d : Iterate.directions) {
                    class_2338 side = currentPos.method_10093(d);
                    if (canPullFluidsFrom(world.method_8320(side), side) == FluidBlockType.SOURCE)
                        return true;
                }
                currentPos = currentPos.method_10084();
                continue;
            }
            if (canPullFluidsFrom == FluidBlockType.SOURCE)
                return true;
            break;
        }
        return false;
    }

    protected enum FluidBlockType {
        NONE,
        SOURCE,
        FLOWING;
    }

    @Override
    public void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        if (!clientPacket && affectedArea != null)
            frontier.add(new BlockPosEntry(rootPos, 0));
    }

    protected FluidBlockType canPullFluidsFrom(class_2680 blockState, class_2338 pos) {
        if (blockState.method_28498(class_2741.field_12508) && blockState.method_11654(class_2741.field_12508))
            return FluidBlockType.SOURCE;
        if (blockState.method_26204() instanceof class_2404)
            return blockState.method_11654(class_2404.field_11278) == 0 ? FluidBlockType.SOURCE : FluidBlockType.FLOWING;
        if (blockState.method_26227().method_15772() != class_3612.field_15906 && blockState.method_26194(getLevel(), pos, class_3726.method_16194()).method_1110())
            return FluidBlockType.SOURCE;
        return FluidBlockType.NONE;
    }

    @Override
    public void tick() {
        super.tick();
        if (rootPos != null)
            isValid = checkValid(getLevel(), rootPos);
        if (!frontier.isEmpty()) {
            continueSearch();
            return;
        }
        if (!validationFrontier.isEmpty()) {
            continueValidation();
            return;
        }
        if (revalidateIn > 0)
            revalidateIn--;
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
    }

    public void rebuildContext(class_2338 root) {
        reset();
        rootPos = root;
        affectedArea = class_3341.method_34390(rootPos, rootPos);
        if (isValid)
            frontier.add(new BlockPosEntry(root, 0));
    }

    public void revalidate(class_2338 root) {
        validationFrontier.clear();
        validationVisited.clear();
        newValidationSet.clear();
        validationFrontier.add(new BlockPosEntry(root, 0));
        setValidationTimer();
    }

    private void continueSearch() {
        try {
            fluid = search(
                fluid, frontier, visited, (e, d) -> {
                    queue.enqueue(new BlockPosEntry(e, d));
                    validationSet.add(e);
                }, false
            );
        } catch (ChunkNotLoadedException e) {
            blockEntity.sendData();
            frontier.clear();
            visited.clear();
        }

        int maxBlocks = maxBlocks();
        if (visited.size() > maxBlocks && canDrainInfinitely(fluid) && !queue.isEmpty()) {
            infinite = true;
            class_2338 firstValid = queue.first().pos();
            frontier.clear();
            visited.clear();
            queue.clear();
            queue.enqueue(new BlockPosEntry(firstValid, 0));
            blockEntity.sendData();
            return;
        }

        if (!frontier.isEmpty())
            return;

        blockEntity.sendData();
        visited.clear();
    }

    private void continueValidation() {
        try {
            search(fluid, validationFrontier, validationVisited, (e, d) -> newValidationSet.add(e), false);
        } catch (ChunkNotLoadedException e) {
            validationFrontier.clear();
            validationVisited.clear();
            setLongValidationTimer();
            return;
        }

        int maxBlocks = maxBlocks();
        if (validationVisited.size() > maxBlocks && canDrainInfinitely(fluid)) {
            if (!infinite)
                reset();
            validationFrontier.clear();
            setLongValidationTimer();
            return;
        }

        if (!validationFrontier.isEmpty())
            return;
        if (infinite) {
            reset();
            return;
        }

        validationSet = newValidationSet;
        newValidationSet = new HashSet<>();
        validationVisited.clear();
    }

    @Override
    public void reset() {
        super.reset();

        fluid = null;
        rootPos = null;
        queue.clear();
        validationSet.clear();
        newValidationSet.clear();
        validationFrontier.clear();
        validationVisited.clear();
        blockEntity.sendData();
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    protected boolean isSearching() {
        return !frontier.isEmpty();
    }

    public FluidStack getDrainableFluid(class_2338 rootPos) {
        return fluid == null || isSearching() || !pullNext(rootPos, true) ? FluidStack.EMPTY : new FluidStack(fluid, BucketFluidInventory.CAPACITY);
    }

}
