package com.zurrtum.create.content.kinetics.base;

import com.zurrtum.create.catnip.data.Iterate;
import net.minecraft.class_1750;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2741;
import net.minecraft.class_2754;

public abstract class RotatedPillarKineticBlock extends KineticBlock {

    public static final class_2754<class_2350.class_2351> AXIS = class_2741.field_12496;

    public RotatedPillarKineticBlock(class_2251 properties) {
        super(properties);
        this.method_9590(this.method_9564().method_11657(AXIS, class_2350.class_2351.field_11052));
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rot) {
        switch (rot) {
            case field_11465:
            case field_11463:
                switch (state.method_11654(AXIS)) {
                    case field_11048:
                        return state.method_11657(AXIS, class_2350.class_2351.field_11051);
                    case field_11051:
                        return state.method_11657(AXIS, class_2350.class_2351.field_11048);
                    default:
                        return state;
                }
            default:
                return state;
        }
    }

    public static class_2351 getPreferredAxis(class_1750 context) {
        class_2351 prefferedAxis = null;
        for (class_2350 side : Iterate.directions) {
            class_2680 blockState = context.method_8045().method_8320(context.method_8037().method_10093(side));
            if (blockState.method_26204() instanceof IRotate) {
                if (((IRotate) blockState.method_26204()).hasShaftTowards(
                    context.method_8045(),
                    context.method_8037().method_10093(side),
                    blockState,
                    side.method_10153()
                ))
                    if (prefferedAxis != null && prefferedAxis != side.method_10166()) {
                        prefferedAxis = null;
                        break;
                    } else {
                        prefferedAxis = side.method_10166();
                    }
            }
        }
        return prefferedAxis;
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> builder) {
        builder.method_11667(AXIS);
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2351 preferredAxis = getPreferredAxis(context);
        if (preferredAxis != null && (context.method_8036() == null || !context.method_8036().method_5715()))
            return this.method_9564().method_11657(AXIS, preferredAxis);
        return this.method_9564().method_11657(
            AXIS,
            preferredAxis != null && context.method_8036().method_5715() ? context.method_8038().method_10166() : context.method_7715()
                .method_10166()
        );
    }
}