package com.zurrtum.create.content.kinetics.belt;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity.CasingType;
import com.zurrtum.create.content.kinetics.belt.item.BeltConnectorItem;
import com.zurrtum.create.content.kinetics.belt.transport.BeltInventory;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_6088;

public class BeltSlicer {

    public static class Feedback {
        int color = 0xffffff;
        class_238 bb;
        String langKey;
        class_124 formatting = class_124.field_1068;
    }

    public static class_1269 useWrench(
        class_2680 state,
        class_1937 world,
        class_2338 pos,
        class_1657 player,
        class_1268 handIn,
        class_3965 hit,
        Feedback feedBack
    ) {
        BeltBlockEntity controllerBE = BeltHelper.getControllerBE(world, pos);
        if (controllerBE == null)
            return class_1269.field_52423;
        if (state.method_11654(BeltBlock.CASING) && hit.method_17780() != class_2350.field_11036)
            return class_1269.field_52423;
        if (state.method_11654(BeltBlock.PART) == BeltPart.PULLEY && hit.method_17780().method_10166() != class_2351.field_11052)
            return class_1269.field_52423;

        int beltLength = controllerBE.beltLength;
        if (beltLength == 2)
            return class_1269.field_5814;

        class_2338 beltVector = class_2338.method_49638(BeltHelper.getBeltVector(state));
        BeltPart part = state.method_11654(BeltBlock.PART);
        List<class_2338> beltChain = BeltBlock.getBeltChain(world, controllerBE.method_11016());
        boolean creative = player.method_68878();

        // Shorten from End
        if (hoveringEnd(state, hit)) {
            if (world.method_8608())
                return class_1269.field_5812;

            for (class_2338 blockPos : beltChain) {
                BeltBlockEntity belt = BeltHelper.getSegmentBE(world, blockPos);
                if (belt == null)
                    continue;
                belt.detachKinetics();
                belt.invalidateItemHandler();
                belt.beltLength = 0;
            }

            BeltInventory inventory = controllerBE.inventory;
            class_2338 next = part == BeltPart.END ? pos.method_10059(beltVector) : pos.method_10081(beltVector);
            class_2680 replacedState = world.method_8320(next);
            BeltBlockEntity segmentBE = BeltHelper.getSegmentBE(world, next);
            KineticBlockEntity.switchToBlockState(
                world,
                next,
                ProperWaterloggedBlock.withWater(
                    world,
                    state.method_11657(BeltBlock.CASING, segmentBE != null && segmentBE.casing != CasingType.NONE),
                    next
                )
            );
            world.method_8652(
                pos,
                ProperWaterloggedBlock.withWater(world, class_2246.field_10124.method_9564(), pos),
                class_2248.field_31036 | class_2248.field_31033
            );
            world.method_8544(pos);
            world.method_20290(class_6088.field_31144, pos, class_2248.method_9507(state));

            if (!creative && replacedState.method_27852(AllBlocks.BELT) && replacedState.method_11654(BeltBlock.PART) == BeltPart.PULLEY)
                player.method_31548().method_7398(AllItems.SHAFT.method_7854());

            // Eject overshooting items
            if (part == BeltPart.END && inventory != null) {
                List<TransportedItemStack> toEject = new ArrayList<>();
                for (TransportedItemStack transportedItemStack : inventory.getTransportedItems())
                    if (transportedItemStack.beltPosition > beltLength - 1)
                        toEject.add(transportedItemStack);
                toEject.forEach(inventory::eject);
                toEject.forEach(inventory.getTransportedItems()::remove);
            }

            // Transfer items to new controller
            if (part == BeltPart.START && segmentBE != null && inventory != null) {
                controllerBE.inventory = null;
                segmentBE.inventory = null;
                segmentBE.setController(next);
                for (TransportedItemStack transportedItemStack : inventory.getTransportedItems()) {
                    transportedItemStack.beltPosition -= 1;
                    if (transportedItemStack.beltPosition <= 0) {
                        class_1542 entity = new class_1542(
                            world,
                            pos.method_10263() + .5f,
                            pos.method_10264() + 11 / 16f,
                            pos.method_10260() + .5f,
                            transportedItemStack.stack
                        );
                        entity.method_18799(class_243.field_1353);
                        entity.method_6988();
                        entity.field_6037 = true;
                        world.method_8649(entity);
                    } else
                        segmentBE.getInventory().addItem(transportedItemStack);
                }
            }

            return class_1269.field_5812;
        }

        BeltBlockEntity segmentBE = BeltHelper.getSegmentBE(world, pos);
        if (segmentBE == null)
            return class_1269.field_52423;

        // Split in half
        int hitSegment = segmentBE.index;
        class_243 centerOf = VecHelper.getCenterOf(hit.method_17777());
        class_243 subtract = hit.method_17784().method_1020(centerOf);
        boolean towardPositive = subtract.method_1026(class_243.method_24954(beltVector)) > 0;
        class_2338 next = !towardPositive ? pos.method_10059(beltVector) : pos.method_10081(beltVector);

        if (hitSegment == 0 || hitSegment == 1 && !towardPositive)
            return class_1269.field_5814;
        if (hitSegment == controllerBE.beltLength - 1 || hitSegment == controllerBE.beltLength - 2 && towardPositive)
            return class_1269.field_5814;

        // Look for shafts
        if (!creative) {
            int requiredShafts = 0;
            if (!segmentBE.hasPulley())
                requiredShafts++;
            class_2680 other = world.method_8320(next);
            if (other.method_27852(AllBlocks.BELT) && other.method_11654(BeltBlock.PART) == BeltPart.MIDDLE)
                requiredShafts++;

            int amountRetrieved = 0;
            boolean beltFound = false;
            Search:
            while (true) {
                for (int i = 0; i < player.method_31548().method_5439(); ++i) {
                    if (amountRetrieved == requiredShafts && beltFound)
                        break Search;

                    class_1799 itemstack = player.method_31548().method_5438(i);
                    if (itemstack.method_7960())
                        continue;
                    int count = itemstack.method_7947();

                    if (itemstack.method_31574(AllItems.BELT_CONNECTOR) && !beltFound) {
                        if (!world.method_8608())
                            itemstack.method_7934(1);
                        beltFound = true;
                        continue;
                    }

                    if (itemstack.method_31574(AllItems.SHAFT)) {
                        int taken = Math.min(count, requiredShafts - amountRetrieved);
                        if (!world.method_8608())
                            if (taken == count)
                                player.method_31548().method_5447(i, class_1799.field_8037);
                            else
                                itemstack.method_7934(taken);
                        amountRetrieved += taken;
                    }
                }

                if (!world.method_8608()) {
                    player.method_31548().method_7398(new class_1799(AllItems.SHAFT, amountRetrieved));
                    if (beltFound)
                        player.method_31548().method_7398(AllItems.BELT_CONNECTOR.method_7854());
                }
                return class_1269.field_5814;
            }
        }

        if (!world.method_8608()) {
            for (class_2338 blockPos : beltChain) {
                BeltBlockEntity belt = BeltHelper.getSegmentBE(world, blockPos);
                if (belt == null)
                    continue;
                belt.detachKinetics();
                belt.invalidateItemHandler();
                belt.beltLength = 0;
            }

            BeltInventory inventory = controllerBE.inventory;
            KineticBlockEntity.switchToBlockState(world, pos, state.method_11657(BeltBlock.PART, towardPositive ? BeltPart.END : BeltPart.START));
            KineticBlockEntity.switchToBlockState(
                world,
                next,
                world.method_8320(next).method_11657(BeltBlock.PART, towardPositive ? BeltPart.START : BeltPart.END)
            );
            world.method_8396(null, pos, class_3417.field_14628, class_3419.field_15248, 0.5F, 2.3F);

            // Transfer items to new controller
            BeltBlockEntity newController = towardPositive ? BeltHelper.getSegmentBE(world, next) : segmentBE;
            if (newController != null && inventory != null) {
                newController.inventory = null;
                newController.setController(newController.method_11016());
                for (Iterator<TransportedItemStack> iterator = inventory.getTransportedItems().iterator(); iterator.hasNext(); ) {
                    TransportedItemStack transportedItemStack = iterator.next();
                    float newPosition = transportedItemStack.beltPosition - hitSegment - (towardPositive ? 1 : 0);
                    if (newPosition <= 0)
                        continue;
                    transportedItemStack.beltPosition = newPosition;
                    iterator.remove();
                    newController.getInventory().addItem(transportedItemStack);
                }
            }
        }

        return class_1269.field_5812;
    }

    public static class_1269 useConnector(
        class_2680 state,
        class_1937 world,
        class_2338 pos,
        class_1657 player,
        class_1268 handIn,
        class_3965 hit,
        Feedback feedBack
    ) {
        BeltBlockEntity controllerBE = BeltHelper.getControllerBE(world, pos);
        if (controllerBE == null)
            return class_1269.field_52423;

        int beltLength = controllerBE.beltLength;
        if (beltLength == BeltConnectorItem.maxLength())
            return class_1269.field_5814;

        class_2338 beltVector = class_2338.method_49638(BeltHelper.getBeltVector(state));
        BeltPart part = state.method_11654(BeltBlock.PART);
        class_2350 facing = state.method_11654(BeltBlock.HORIZONTAL_FACING);
        List<class_2338> beltChain = BeltBlock.getBeltChain(world, controllerBE.method_11016());
        boolean creative = player.method_68878();

        if (!hoveringEnd(state, hit))
            return class_1269.field_52423;

        class_2338 next = part == BeltPart.START ? pos.method_10059(beltVector) : pos.method_10081(beltVector);
        BeltBlockEntity mergedController = null;
        int mergedBeltLength = 0;

        // Merge Belts / Extend at End
        class_2680 nextState = world.method_8320(next);
        if (!nextState.method_45474()) {
            if (!nextState.method_27852(AllBlocks.BELT))
                return class_1269.field_5814;
            if (!beltStatesCompatible(state, nextState))
                return class_1269.field_5814;

            mergedController = BeltHelper.getControllerBE(world, next);
            if (mergedController == null)
                return class_1269.field_5814;
            if (mergedController.beltLength + beltLength > BeltConnectorItem.maxLength())
                return class_1269.field_5814;

            mergedBeltLength = mergedController.beltLength;

            if (!world.method_8608()) {
                boolean flipBelt = facing != nextState.method_11654(BeltBlock.HORIZONTAL_FACING);
                Optional<class_1767> color = controllerBE.color;
                for (class_2338 blockPos : BeltBlock.getBeltChain(world, mergedController.method_11016())) {
                    BeltBlockEntity belt = BeltHelper.getSegmentBE(world, blockPos);
                    if (belt == null)
                        continue;
                    belt.detachKinetics();
                    belt.invalidateItemHandler();
                    belt.beltLength = 0;
                    belt.color = color;
                    if (flipBelt)
                        world.method_8652(blockPos, flipBelt(world.method_8320(blockPos)), class_2248.field_31036 | class_2248.field_31033);
                }

                // Reverse items
                if (flipBelt && mergedController.inventory != null) {
                    List<TransportedItemStack> transportedItems = mergedController.inventory.getTransportedItems();
                    for (TransportedItemStack transportedItemStack : transportedItems) {
                        transportedItemStack.beltPosition = mergedBeltLength - transportedItemStack.beltPosition;
                        transportedItemStack.prevBeltPosition = mergedBeltLength - transportedItemStack.prevBeltPosition;
                    }
                }

                beltChain = BeltBlock.getBeltChain(world, mergedController.method_11016());
            }
        }

        if (!world.method_8608()) {
            for (class_2338 blockPos : beltChain) {
                BeltBlockEntity belt = BeltHelper.getSegmentBE(world, blockPos);
                if (belt == null)
                    continue;
                belt.detachKinetics();
                belt.invalidateItemHandler();
                belt.beltLength = 0;
            }

            BeltInventory inventory = controllerBE.inventory;
            KineticBlockEntity.switchToBlockState(world, pos, state.method_11657(BeltBlock.PART, BeltPart.MIDDLE));

            if (mergedController == null) {
                // Attach at end
                world.method_8652(
                    next,
                    ProperWaterloggedBlock.withWater(world, state.method_11657(BeltBlock.CASING, false), next),
                    class_2248.field_31036 | class_2248.field_31033
                );
                BeltBlockEntity segmentBE = BeltHelper.getSegmentBE(world, next);
                if (segmentBE != null)
                    segmentBE.color = controllerBE.color;
                world.method_8396(null, pos, class_3417.field_15226, class_3419.field_15248, 0.5F, 1F);

                // Transfer items to new controller
                if (part == BeltPart.START && segmentBE != null && inventory != null) {
                    segmentBE.setController(next);
                    for (TransportedItemStack transportedItemStack : inventory.getTransportedItems()) {
                        transportedItemStack.beltPosition += 1;
                        segmentBE.getInventory().addItem(transportedItemStack);
                    }
                }

            } else {
                // Merge with other
                BeltInventory mergedInventory = mergedController.inventory;
                world.method_8396(null, pos, class_3417.field_14628, class_3419.field_15248, 0.5F, 1.3F);
                BeltBlockEntity segmentBE = BeltHelper.getSegmentBE(world, next);
                KineticBlockEntity.switchToBlockState(
                    world,
                    next,
                    state.method_11657(BeltBlock.CASING, segmentBE != null && segmentBE.casing != CasingType.NONE)
                        .method_11657(BeltBlock.PART, BeltPart.MIDDLE)
                );

                if (!creative) {
                    player.method_31548().method_7398(new class_1799(AllBlocks.SHAFT, 2));
                    player.method_31548().method_7398(AllItems.BELT_CONNECTOR.method_7854());
                }

                for (class_2338 blockPos : BeltBlock.getBeltChain(world, controllerBE.method_11016())) {
                    BeltBlockEntity belt = BeltHelper.getSegmentBE(world, blockPos);
                    if (belt == null)
                        continue;
                    belt.invalidateItemHandler();
                }

                // Transfer items to other controller
                class_2338 search = controllerBE.method_11016();
                for (int i = 0; i < 10000; i++) {
                    class_2680 blockState = world.method_8320(search);
                    if (!blockState.method_27852(AllBlocks.BELT))
                        break;
                    if (blockState.method_11654(BeltBlock.PART) != BeltPart.START) {
                        search = search.method_10059(beltVector);
                        continue;
                    }

                    BeltBlockEntity newController = BeltHelper.getSegmentBE(world, search);

                    if (newController != controllerBE && inventory != null) {
                        newController.setController(search);
                        controllerBE.inventory = null;
                        for (TransportedItemStack transportedItemStack : inventory.getTransportedItems()) {
                            transportedItemStack.beltPosition += mergedBeltLength;
                            newController.getInventory().addItem(transportedItemStack);
                        }
                    }

                    if (newController != mergedController && mergedInventory != null) {
                        newController.setController(search);
                        mergedController.inventory = null;
                        for (TransportedItemStack transportedItemStack : mergedInventory.getTransportedItems()) {
                            if (newController == controllerBE)
                                transportedItemStack.beltPosition += beltLength;
                            newController.getInventory().addItem(transportedItemStack);
                        }
                    }

                    break;
                }
            }
        }
        return class_1269.field_5812;
    }

    static boolean beltStatesCompatible(class_2680 state, class_2680 nextState) {
        class_2350 facing1 = state.method_11654(BeltBlock.HORIZONTAL_FACING);
        BeltSlope slope1 = state.method_11654(BeltBlock.SLOPE);
        class_2350 facing2 = nextState.method_11654(BeltBlock.HORIZONTAL_FACING);
        BeltSlope slope2 = nextState.method_11654(BeltBlock.SLOPE);

        switch (slope1) {
            case UPWARD:
                if (slope2 == BeltSlope.DOWNWARD)
                    return facing1 == facing2.method_10153();
                return slope2 == slope1 && facing1 == facing2;
            case DOWNWARD:
                if (slope2 == BeltSlope.UPWARD)
                    return facing1 == facing2.method_10153();
                return slope2 == slope1 && facing1 == facing2;
            default:
                return slope2 == slope1 && facing2.method_10166() == facing1.method_10166();
        }
    }

    static class_2680 flipBelt(class_2680 state) {
        class_2350 facing = state.method_11654(BeltBlock.HORIZONTAL_FACING);
        BeltSlope slope = state.method_11654(BeltBlock.SLOPE);
        BeltPart part = state.method_11654(BeltBlock.PART);

        if (slope == BeltSlope.UPWARD)
            state = state.method_11657(BeltBlock.SLOPE, BeltSlope.DOWNWARD);
        else if (slope == BeltSlope.DOWNWARD)
            state = state.method_11657(BeltBlock.SLOPE, BeltSlope.UPWARD);

        if (part == BeltPart.END)
            state = state.method_11657(BeltBlock.PART, BeltPart.START);
        else if (part == BeltPart.START)
            state = state.method_11657(BeltBlock.PART, BeltPart.END);

        return state.method_11657(BeltBlock.HORIZONTAL_FACING, facing.method_10153());
    }

    static boolean hoveringEnd(class_2680 state, class_3965 hit) {
        BeltPart part = state.method_11654(BeltBlock.PART);
        if (part == BeltPart.MIDDLE || part == BeltPart.PULLEY)
            return false;

        class_243 beltVector = BeltHelper.getBeltVector(state);
        class_243 centerOf = VecHelper.getCenterOf(hit.method_17777());
        class_243 subtract = hit.method_17784().method_1020(centerOf);

        return subtract.method_1026(beltVector) > 0 == (part == BeltPart.END);
    }
}
