package com.zurrtum.create.content.kinetics.belt.transport;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.content.equipment.armor.CardboardArmorHandler;
import com.zurrtum.create.content.kinetics.belt.BeltBlock;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltPart;
import com.zurrtum.create.content.kinetics.belt.BeltSlope;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1530;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3619;
import net.minecraft.class_5134;

import static net.minecraft.class_2350.class_2352.field_11060;
import static net.minecraft.class_2350.class_2352.field_11056;
import static net.minecraft.class_1313.field_6308;

public class BeltMovementHandler {

    public static class TransportedEntityInfo {
        int ticksSinceLastCollision;
        class_2338 lastCollidedPos;
        class_2680 lastCollidedState;

        public TransportedEntityInfo(class_2338 collision, class_2680 belt) {
            refresh(collision, belt);
        }

        public void refresh(class_2338 collision, class_2680 belt) {
            ticksSinceLastCollision = 0;
            lastCollidedPos = new class_2338(collision).method_10062();
            lastCollidedState = belt;
        }

        public TransportedEntityInfo tick() {
            ticksSinceLastCollision++;
            return this;
        }

        public int getTicksSinceLastCollision() {
            return ticksSinceLastCollision;
        }
    }

    public static boolean canBeTransported(class_1297 entity) {
        return entity.method_5805() && (!(entity instanceof class_1657 p) || !p.method_5715() || CardboardArmorHandler.testForStealth(entity));
    }

    public static void transportEntity(BeltBlockEntity beltBE, class_1297 entityIn, TransportedEntityInfo info) {
        class_2338 pos = info.lastCollidedPos;
        class_1937 world = beltBE.method_10997();
        class_2586 be = world.method_8321(pos);
        class_2586 blockEntityBelowPassenger = world.method_8321(entityIn.method_24515());
        class_2680 blockState = info.lastCollidedState;
        class_2350 movementFacing = class_2350.method_10169(
            blockState.method_11654(class_2741.field_12481).method_10166(),
            beltBE.getSpeed() < 0 ? field_11056 : field_11060
        );

        boolean collidedWithBelt = be instanceof BeltBlockEntity;
        boolean betweenBelts = blockEntityBelowPassenger instanceof BeltBlockEntity && blockEntityBelowPassenger != be;

        // Don't fight other Belts
        if (!collidedWithBelt || betweenBelts) {
            return;
        }

        // Too slow
        boolean notHorizontal = beltBE.method_11010().method_11654(BeltBlock.SLOPE) != BeltSlope.HORIZONTAL;
        if (Math.abs(beltBE.getSpeed()) < 1)
            return;

        // Not on top
        if (entityIn.method_23318() - .25f < pos.method_10264())
            return;

        // Lock entities in place
        boolean isPlayer = entityIn instanceof class_1657;
        if (entityIn instanceof class_1309 && !isPlayer)
            ((class_1309) entityIn).method_6092(new class_1293(class_1294.field_5909, 10, 1, false, false));

        final class_2350 beltFacing = blockState.method_11654(class_2741.field_12481);
        final BeltSlope slope = blockState.method_11654(BeltBlock.SLOPE);
        final class_2351 axis = beltFacing.method_10166();
        float movementSpeed = beltBE.getBeltMovementSpeed();
        final class_2350 movementDirection = class_2350.method_10156(axis == class_2351.field_11048 ? field_11060 : field_11056, axis);

        class_2382 centeringDirection = class_2350.method_10156(field_11056, beltFacing.method_10170().method_10166()).method_62675();
        class_243 movement = class_243.method_24954(movementDirection.method_62675()).method_1021(movementSpeed);

        double diffCenter = axis == class_2351.field_11051 ? (pos.method_10263() + .5f - entityIn.method_23317()) : (pos.method_10260() + .5f - entityIn.method_23321());
        if (Math.abs(diffCenter) > 48 / 64f)
            return;

        BeltPart part = blockState.method_11654(BeltBlock.PART);
        float top = 13 / 16f;
        boolean onSlope = notHorizontal && (part == BeltPart.MIDDLE || part == BeltPart.PULLEY || part == (slope == BeltSlope.UPWARD ? BeltPart.END : BeltPart.START) && entityIn.method_23318() - pos.method_10264() < top || part == (slope == BeltSlope.UPWARD ? BeltPart.START : BeltPart.END) && entityIn.method_23318() - pos.method_10264() > top);

        boolean movingDown = onSlope && slope == (movementFacing == beltFacing ? BeltSlope.DOWNWARD : BeltSlope.UPWARD);
        boolean movingUp = onSlope && slope == (movementFacing == beltFacing ? BeltSlope.UPWARD : BeltSlope.DOWNWARD);

        if (beltFacing.method_10166() == class_2351.field_11051) {
            boolean b = movingDown;
            movingDown = movingUp;
            movingUp = b;
        }

        if (movingUp)
            movement = movement.method_1031(0, Math.abs(axis.method_10172(movement.field_1352, movement.field_1351, movement.field_1350)), 0);
        if (movingDown)
            movement = movement.method_1031(0, -Math.abs(axis.method_10172(movement.field_1352, movement.field_1351, movement.field_1350)), 0);

        class_243 centering = class_243.method_24954(centeringDirection).method_1021(diffCenter * Math.min(Math.abs(movementSpeed), .1f) * 4);

        if (!(entityIn instanceof class_1309) || ((class_1309) entityIn).field_6250 == 0 && ((class_1309) entityIn).field_6212 == 0)
            movement = movement.method_1019(centering);

        float step = entityIn.method_49476();
        if (!isPlayer && entityIn instanceof class_1309 livingEntity) {
            step = (float) livingEntity.method_45326(class_5134.field_47761);
            //noinspection DataFlowIssue
            livingEntity.method_5996(class_5134.field_47761).method_6192(1.0f);
        }

        // Entity Collisions
        if (Math.abs(movementSpeed) < .5f) {
            class_243 checkDistance = movement.method_1029().method_1021(0.5);
            class_238 bb = entityIn.method_5829();
            class_238 checkBB = new class_238(bb.field_1323, bb.field_1322, bb.field_1321, bb.field_1320, bb.field_1325, bb.field_1324);
            checkBB = checkBB.method_997(checkDistance).method_1009(-Math.abs(checkDistance.field_1352), -Math.abs(checkDistance.field_1351), -Math.abs(checkDistance.field_1350));
            List<class_1297> list = world.method_8335(entityIn, checkBB);
            list.removeIf(e -> shouldIgnoreBlocking(entityIn, e));
            if (!list.isEmpty()) {
                entityIn.method_18800(0, 0, 0);
                info.ticksSinceLastCollision--;
                return;
            }
        }

        entityIn.field_6017 = 0;

        if (movingUp) {
            float minVelocity = .13f;
            float yMovement = (float) -(Math.max(Math.abs(movement.field_1351), minVelocity));
            entityIn.method_5784(field_6308, new class_243(0, yMovement, 0));
            entityIn.method_5784(field_6308, movement.method_18805(1, 0, 1));
        } else if (movingDown) {
            entityIn.method_5784(field_6308, movement.method_18805(1, 0, 1));
            entityIn.method_5784(field_6308, movement.method_18805(0, 1, 0));
        } else {
            entityIn.method_5784(field_6308, movement);
        }

        entityIn.method_24830(true);

        if (!isPlayer && entityIn instanceof class_1309 livingEntity) {
            livingEntity.method_5996(class_5134.field_47761).method_6192(step);
        }

        boolean movedPastEndingSlope = onSlope && (world.method_8320(entityIn.method_24515())
            .method_27852(AllBlocks.BELT) || world.method_8320(entityIn.method_24515().method_10074()).method_27852(AllBlocks.BELT));

        if (movedPastEndingSlope && !movingDown && Math.abs(movementSpeed) > 0)
            entityIn.method_5814(entityIn.method_23317(), entityIn.method_23318() + movement.field_1351, entityIn.method_23321());
        if (movedPastEndingSlope) {
            entityIn.method_18799(movement);
            entityIn.field_6037 = true;
        }

    }

    public static boolean shouldIgnoreBlocking(class_1297 me, class_1297 other) {
        if (other instanceof class_1530)
            return true;
        if (other.method_5657() == class_3619.field_15975)
            return true;
        return isRidingOrBeingRiddenBy(me, other);
    }

    public static boolean isRidingOrBeingRiddenBy(class_1297 me, class_1297 other) {
        for (class_1297 entity : me.method_5685()) {
            if (entity.equals(other))
                return true;
            if (isRidingOrBeingRiddenBy(entity, other))
                return true;
        }
        return false;
    }

}
