package com.zurrtum.create.content.kinetics.chainDrive;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.api.contraption.transformable.TransformableBlock;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.WeakPowerControlBlock;

import java.util.Locale;
import net.minecraft.class_10225;
import net.minecraft.class_1750;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_3542;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_8235;

public class ChainDriveBlock extends RotatedPillarKineticBlock implements IBE<KineticBlockEntity>, TransformableBlock, WeakPowerControlBlock {

    public static final class_2754<Part> PART = class_2754.method_11850("part", Part.class);
    public static final class_2746 CONNECTED_ALONG_FIRST_COORDINATE = DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE;

    public ChainDriveBlock(class_2251 properties) {
        super(properties);
        method_9590(method_9564().method_11657(PART, Part.NONE));
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder.method_11667(PART, CONNECTED_ALONG_FIRST_COORDINATE));
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2351 placedAxis = context.method_7715().method_10166();
        class_2351 axis = context.method_8036() != null && context.method_8036().method_5715() ? placedAxis : getPreferredAxis(context);
        if (axis == null)
            axis = placedAxis;

        class_2680 state = method_9564().method_11657(AXIS, axis);
        for (class_2350 facing : Iterate.directions) {
            if (facing.method_10166() == axis)
                continue;
            class_2338 pos = context.method_8037();
            class_2338 offset = pos.method_10093(facing);
            class_1937 world = context.method_8045();
            state = method_9559(state, world, world, pos, facing, offset, world.method_8320(offset), world.method_8409());
        }
        return state;
    }

    @Override
    public class_2680 method_9559(
        class_2680 stateIn,
        class_4538 worldIn,
        class_10225 tickView,
        class_2338 currentPos,
        class_2350 face,
        class_2338 facingPos,
        class_2680 neighbour,
        class_5819 random
    ) {
        Part part = stateIn.method_11654(PART);
        class_2351 axis = stateIn.method_11654(AXIS);
        boolean connectionAlongFirst = stateIn.method_11654(CONNECTED_ALONG_FIRST_COORDINATE);
        class_2351 connectionAxis = connectionAlongFirst ? (axis == class_2351.field_11048 ? class_2351.field_11052 : class_2351.field_11048) : (axis == class_2351.field_11051 ? class_2351.field_11052 : class_2351.field_11051);

        class_2351 faceAxis = face.method_10166();
        boolean facingAlongFirst = axis == class_2351.field_11048 ? faceAxis.method_10178() : faceAxis == class_2351.field_11048;
        boolean positive = face.method_10171() == class_2352.field_11056;

        if (axis == faceAxis)
            return stateIn;

        if (!(neighbour.method_26204() instanceof ChainDriveBlock)) {
            if (facingAlongFirst != connectionAlongFirst || part == Part.NONE)
                return stateIn;
            if (part == Part.MIDDLE)
                return stateIn.method_11657(PART, positive ? Part.END : Part.START);
            if ((part == Part.START) == positive)
                return stateIn.method_11657(PART, Part.NONE);
            return stateIn;
        }

        Part otherPart = neighbour.method_11654(PART);
        class_2351 otherAxis = neighbour.method_11654(AXIS);
        boolean otherConnection = neighbour.method_11654(CONNECTED_ALONG_FIRST_COORDINATE);
        class_2351 otherConnectionAxis = otherConnection ? (otherAxis == class_2351.field_11048 ? class_2351.field_11052 : class_2351.field_11048) : (otherAxis == class_2351.field_11051 ? class_2351.field_11052 : class_2351.field_11051);

        if (neighbour.method_11654(AXIS) == faceAxis)
            return stateIn;
        if (otherPart != Part.NONE && otherConnectionAxis != faceAxis)
            return stateIn;

        if (part == Part.NONE) {
            part = positive ? Part.START : Part.END;
            connectionAlongFirst = axis == class_2351.field_11048 ? faceAxis.method_10178() : faceAxis == class_2351.field_11048;
        } else if (connectionAxis != faceAxis) {
            return stateIn;
        }

        if ((part == Part.START) != positive)
            part = Part.MIDDLE;

        return stateIn.method_11657(PART, part).method_11657(CONNECTED_ALONG_FIRST_COORDINATE, connectionAlongFirst);
    }

    @Override
    public class_2680 getRotatedBlockState(class_2680 originalState, class_2350 targetedFace) {
        if (originalState.method_11654(PART) == Part.NONE)
            return super.getRotatedBlockState(originalState, targetedFace);
        return super.getRotatedBlockState(originalState, class_2350.method_10156(class_2352.field_11056, getConnectionAxis(originalState)));
    }

    @Override
    public boolean shouldCheckWeakPower(class_2680 state, class_8235 level, class_2338 pos, class_2350 side) {
        return false;
    }

    @Override
    public class_2680 updateAfterWrenched(class_2680 newState, class_1838 context) {
        //		Blocks.AIR.getDefaultState()
        //			.updateNeighbors(context.getWorld(), context.getPos(), 1);
        class_2351 axis = newState.method_11654(AXIS);
        newState = method_9564().method_11657(AXIS, axis);
        if (newState.method_28498(class_2741.field_12484))
            newState = newState.method_11657(class_2741.field_12484, context.method_8045().method_49803(context.method_8037()));
        for (class_2350 facing : Iterate.directions) {
            if (facing.method_10166() == axis)
                continue;
            class_2338 pos = context.method_8037();
            class_2338 offset = pos.method_10093(facing);
            class_1937 world = context.method_8045();
            newState = method_9559(newState, world, world, pos, facing, offset, world.method_8320(offset), world.method_8409());
        }
        //		newState.updateNeighbors(context.getWorld(), context.getPos(), 1 | 2);
        return newState;
    }

    @Override
    public boolean hasShaftTowards(class_4538 world, class_2338 pos, class_2680 state, class_2350 face) {
        return face.method_10166() == state.method_11654(AXIS);
    }

    @Override
    public class_2351 getRotationAxis(class_2680 state) {
        return state.method_11654(AXIS);
    }

    public static boolean areBlocksConnected(class_2680 state, class_2680 other, class_2350 facing) {
        Part part = state.method_11654(PART);
        class_2351 connectionAxis = getConnectionAxis(state);
        class_2351 otherConnectionAxis = getConnectionAxis(other);

        if (otherConnectionAxis != connectionAxis)
            return false;
        if (facing.method_10166() != connectionAxis)
            return false;
        if (facing.method_10171() == class_2352.field_11056 && (part == Part.MIDDLE || part == Part.START))
            return true;
        if (facing.method_10171() == class_2352.field_11060 && (part == Part.MIDDLE || part == Part.END))
            return true;

        return false;
    }

    protected static class_2351 getConnectionAxis(class_2680 state) {
        class_2351 axis = state.method_11654(AXIS);
        boolean connectionAlongFirst = state.method_11654(CONNECTED_ALONG_FIRST_COORDINATE);
        return connectionAlongFirst ? (axis == class_2351.field_11048 ? class_2351.field_11052 : class_2351.field_11048) : (axis == class_2351.field_11051 ? class_2351.field_11052 : class_2351.field_11051);
    }

    public static float getRotationSpeedModifier(KineticBlockEntity from, KineticBlockEntity to) {
        float fromMod = 1;
        float toMod = 1;
        if (from instanceof ChainGearshiftBlockEntity)
            fromMod = ((ChainGearshiftBlockEntity) from).getModifier();
        if (to instanceof ChainGearshiftBlockEntity)
            toMod = ((ChainGearshiftBlockEntity) to).getModifier();
        return fromMod / toMod;
    }

    public enum Part implements class_3542 {
        START,
        MIDDLE,
        END,
        NONE;

        @Override
        public String method_15434() {
            return name().toLowerCase(Locale.ROOT);
        }
    }

    @Override
    public Class<KineticBlockEntity> getBlockEntityClass() {
        return KineticBlockEntity.class;
    }

    @Override
    public class_2591<? extends KineticBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.ENCASED_SHAFT;
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rot) {
        return rotate(state, rot, class_2351.field_11052);
    }

    protected class_2680 rotate(class_2680 pState, class_2470 rot, class_2351 rotAxis) {
        class_2351 connectionAxis = getConnectionAxis(pState);
        class_2350 direction = class_2350.method_10169(connectionAxis, class_2352.field_11056);
        class_2350 normal = class_2350.method_10169(pState.method_11654(AXIS), class_2352.field_11056);
        for (int i = 0; i < rot.ordinal(); i++) {
            direction = direction.method_35833(rotAxis);
            normal = normal.method_35833(rotAxis);
        }

        if (direction.method_10171() == class_2352.field_11060)
            pState = reversePart(pState);

        class_2351 newAxis = normal.method_10166();
        class_2351 newConnectingDirection = direction.method_10166();
        boolean alongFirst = newAxis == class_2351.field_11048 && newConnectingDirection == class_2351.field_11052 || newAxis != class_2351.field_11048 && newConnectingDirection == class_2351.field_11048;

        return pState.method_11657(AXIS, newAxis).method_11657(CONNECTED_ALONG_FIRST_COORDINATE, alongFirst);
    }

    @Override
    public class_2680 method_9569(class_2680 pState, class_2415 pMirror) {
        class_2351 connectionAxis = getConnectionAxis(pState);
        if (pMirror.method_10343(class_2350.method_10169(connectionAxis, class_2352.field_11056)).method_10171() == class_2352.field_11056)
            return pState;
        return reversePart(pState);
    }

    protected class_2680 reversePart(class_2680 pState) {
        Part part = pState.method_11654(PART);
        if (part == Part.START)
            return pState.method_11657(PART, Part.END);
        if (part == Part.END)
            return pState.method_11657(PART, Part.START);
        return pState;
    }

    @Override
    public class_2680 transform(class_2680 state, StructureTransform transform) {
        return rotate(method_9569(state, transform.mirror), transform.rotation, transform.rotationAxis);
    }

}
