package com.zurrtum.create.content.kinetics.chainDrive;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import net.minecraft.class_1750;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_9904;
import org.jetbrains.annotations.Nullable;

public class ChainGearshiftBlock extends ChainDriveBlock {

    public static final class_2746 POWERED = class_2741.field_12484;

    public ChainGearshiftBlock(class_2251 properties) {
        super(properties);
        method_9590(method_9564().method_11657(POWERED, false));
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder.method_11667(POWERED));
    }

    @Override
    public void method_9615(class_2680 state, class_1937 worldIn, class_2338 pos, class_2680 oldState, boolean isMoving) {
        super.method_9615(state, worldIn, pos, oldState, isMoving);
        if (oldState.method_26204() == state.method_26204())
            return;
        withBlockEntityDo(worldIn, pos, kbe -> ((ChainGearshiftBlockEntity) kbe).neighbourChanged());
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        return super.method_9605(context).method_11657(POWERED, context.method_8045().method_49803(context.method_8037()));
    }

    @Override
    protected boolean areStatesKineticallyEquivalent(class_2680 oldState, class_2680 newState) {
        return super.areStatesKineticallyEquivalent(oldState, newState) && oldState.method_11654(POWERED) == newState.method_11654(POWERED);
    }

    @Override
    public void method_9612(
        class_2680 state,
        class_1937 worldIn,
        class_2338 pos,
        class_2248 blockIn,
        @Nullable class_9904 wireOrientation,
        boolean isMoving
    ) {
        if (worldIn.method_8608())
            return;

        withBlockEntityDo(worldIn, pos, kbe -> ((ChainGearshiftBlockEntity) kbe).neighbourChanged());

        boolean previouslyPowered = state.method_11654(POWERED);
        if (previouslyPowered != worldIn.method_49803(pos))
            worldIn.method_8652(pos, state.method_28493(POWERED), class_2248.field_31028 | class_2248.field_31031);
    }

    @Override
    public class_2591<? extends KineticBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.ADJUSTABLE_CHAIN_GEARSHIFT;
    }

}
