package com.zurrtum.create.content.kinetics.crank;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.foundation.utility.BlockHelper;

import java.util.function.Function;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3965;

public class ValveHandleBlock extends HandCrankBlock {

    public final class_1767 color;

    public static ValveHandleBlock copper(class_2251 properties) {
        return new ValveHandleBlock(properties, null);
    }

    public static Function<class_2251, ValveHandleBlock> dyed(class_1767 color) {
        return properties -> new ValveHandleBlock(properties, color);
    }

    private ValveHandleBlock(class_2251 properties, class_1767 color) {
        super(properties);
        this.color = color;
    }

    @Override
    public class_265 method_9530(class_2680 pState, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return AllShapes.VALVE_HANDLE.get(pState.method_11654(FACING));
    }

    public static ValveHandleBlock getColorBlock(class_1767 color) {
        return switch (color) {
            case null -> AllBlocks.COPPER_VALVE_HANDLE;
            case field_7952 -> AllBlocks.WHITE_VALVE_HANDLE;
            case field_7946 -> AllBlocks.ORANGE_VALVE_HANDLE;
            case field_7958 -> AllBlocks.MAGENTA_VALVE_HANDLE;
            case field_7951 -> AllBlocks.LIGHT_BLUE_VALVE_HANDLE;
            case field_7947 -> AllBlocks.YELLOW_VALVE_HANDLE;
            case field_7961 -> AllBlocks.LIME_VALVE_HANDLE;
            case field_7954 -> AllBlocks.PINK_VALVE_HANDLE;
            case field_7944 -> AllBlocks.GRAY_VALVE_HANDLE;
            case field_7967 -> AllBlocks.LIGHT_GRAY_VALVE_HANDLE;
            case field_7955 -> AllBlocks.CYAN_VALVE_HANDLE;
            case field_7945 -> AllBlocks.PURPLE_VALVE_HANDLE;
            case field_7966 -> AllBlocks.BLUE_VALVE_HANDLE;
            case field_7957 -> AllBlocks.BROWN_VALVE_HANDLE;
            case field_7942 -> AllBlocks.GREEN_VALVE_HANDLE;
            case field_7964 -> AllBlocks.RED_VALVE_HANDLE;
            case field_7963 -> AllBlocks.BLACK_VALVE_HANDLE;
        };
    }

    public void clicked(class_1937 level, class_2338 pos, class_2680 state, class_1657 player, class_1268 hand) {
        class_1799 heldItem = player.method_5998(hand);
        method_55765(heldItem, state, level, pos, player, hand, null);
    }

    @Override
    protected class_1269 method_55765(
        class_1799 heldItem,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        class_1767 color = AllItemTags.getDyeColor(heldItem);

        if (color != null && color != this.color) {
            if (!level.method_8608())
                level.method_8501(pos, BlockHelper.copyProperties(state, getColorBlock(color).method_9564()));
            return class_1269.field_5812;
        }

        onBlockEntityUse(
            level,
            pos,
            hcbe -> (hcbe instanceof ValveHandleBlockEntity vhbe) && vhbe.activate(player.method_5715()) ? class_1269.field_5812 : class_1269.field_5811
        );
        return class_1269.field_5812;
    }

    @Override
    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        return super.method_55766(state, world, pos, player, hit);
    }

    @Override
    public class_2591<? extends HandCrankBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.VALVE_HANDLE;
    }
}
