package com.zurrtum.create.content.kinetics.crank;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.transmission.sequencer.SequencedGearshiftBlockEntity.SequenceContext;
import com.zurrtum.create.content.kinetics.transmission.sequencer.SequencerInstructions;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollValueBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerValveScrollValueBehaviour;

import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class ValveHandleBlockEntity extends HandCrankBlockEntity {

    public ServerScrollValueBehaviour angleInput;
    public int cooldown;

    public int startAngle;
    public int targetAngle;
    public int totalUseTicks;
    private boolean keepAlive;

    public ValveHandleBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.VALVE_HANDLE, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        angleInput = new ServerValveScrollValueBehaviour(this);
        angleInput.between(-180, 180);
        angleInput.setValue(45);
        behaviours.add(angleInput);
    }

    @Override
    protected boolean clockwise() {
        return angleInput.getValue() < 0 ^ backwards;
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71465("TotalUseTicks", totalUseTicks);
        view.method_71465("StartAngle", startAngle);
        view.method_71465("TargetAngle", targetAngle);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        totalUseTicks = view.method_71424("TotalUseTicks", 0);
        startAngle = view.method_71424("StartAngle", 0);
        targetAngle = view.method_71424("TargetAngle", 0);
    }

    @Override
    public void tick() {
        super.tick();
        if (inUse == 0 && cooldown > 0)
            cooldown--;
        independentAngle = 0;
    }

    public boolean showValue() {
        return inUse == 0;
    }

    public boolean activate(boolean sneak) {
        if (getTheoreticalSpeed() != 0)
            return false;
        if (inUse > 0 || cooldown > 0)
            return false;
        if (field_11863.method_8608())
            return true;

        // Always overshoot, target will stop early
        int value = angleInput.getValue();
        int target = Math.abs(value);
        int rotationSpeed = AllBlocks.COPPER_VALVE_HANDLE.getRotationSpeed();
        double degreesPerTick = KineticBlockEntity.convertToAngular(rotationSpeed);
        inUse = (int) Math.ceil(target / degreesPerTick) + 2;

        startAngle = 0;
        targetAngle = Math.round((startAngle + (target > 135 ? 180 : 90) * class_3532.method_17822(value)) / 90f) * 90;
        totalUseTicks = inUse;
        backwards = sneak;

        sequenceContext = SequenceContext.fromGearshift(SequencerInstructions.TURN_ANGLE, rotationSpeed, target);
        updateGeneratedRotation();
        cooldown = 4;

        return true;
    }

    @Override
    protected void copySequenceContextFrom(KineticBlockEntity sourceBE) {
    }

    @Override
    @SuppressWarnings("deprecation")
    public void method_66473(class_2338 pos, class_2680 oldState) {
        class_2680 state = field_11863.method_8320(pos);
        if (method_11017().method_20526(state)) {
            keepAlive = true;
            method_31664(state);
        } else {
            super.method_66473(pos, oldState);
        }
    }

    @Override
    public void method_11012() {
        if (keepAlive) {
            keepAlive = false;
            field_11863.method_22350(field_11867).method_12007(this);
        } else {
            super.method_11012();
        }
    }
}
