package com.zurrtum.create.content.kinetics.crusher;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.foundation.advancement.CreateTrigger;

import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2680;

public class CrushingWheelBlockEntity extends KineticBlockEntity {
    public CrushingWheelBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.CRUSHING_WHEEL, pos, state);
        setLazyTickRate(20);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.CRUSHING_WHEEL, AllAdvancements.CRUSHER_MAXED);
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        fixControllers();
    }

    public void fixControllers() {
        for (class_2350 d : Iterate.directions)
            ((CrushingWheelBlock) method_11010().method_26204()).updateControllers(method_11010(), method_10997(), method_11016(), d);
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return new class_238(field_11867).method_1014(1);
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        fixControllers();
    }
}
