package com.zurrtum.create.content.kinetics.deployer;

import com.google.common.collect.HashMultimap;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.catnip.levelWrappers.WrappedLevel;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.mounted.CartAssemblerBlockItem;
import com.zurrtum.create.content.equipment.sandPaper.SandPaperItem;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity.Mode;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.component.SandPaperItemComponent;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1755;
import net.minecraft.class_1785;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2246;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3959;
import net.minecraft.class_3959.class_3960;
import net.minecraft.class_3965;
import net.minecraft.class_3988;
import net.minecraft.class_4174;
import net.minecraft.class_4770;
import net.minecraft.class_5425;
import net.minecraft.class_6880;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import net.minecraft.world.item.*;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

import java.util.*;

public class DeployerHandler {
    private static final Map<class_2338, List<class_1542>> CAPTURED_BLOCK_DROPS = new HashMap<>();
    public static final Map<class_2338, List<class_1542>> CAPTURED_BLOCK_DROPS_VIEW = Collections.unmodifiableMap(CAPTURED_BLOCK_DROPS);

    private static final class ItemUseWorld extends WrappedLevel implements class_5425 {
        private final class_2350 face;
        private final class_2338 pos;
        boolean rayMode = false;

        private ItemUseWorld(class_3218 level, class_2350 face, class_2338 pos) {
            super(level);
            this.face = face;
            this.pos = pos;
        }

        @Override
        public class_1266 method_8404(class_2338 pos) {
            return method_8410().method_8404(pos);
        }

        @Override
        public class_3218 method_8410() {
            // This is safe, we always pass ServerLevel in the constructor
            return (class_3218) level;
        }

        @Override
        public class_3965 method_17742(class_3959 context) {
            rayMode = true;
            class_3965 rayTraceBlocks = super.method_17742(context);
            rayMode = false;
            return rayTraceBlocks;
        }

        @Override
        public class_2680 method_8320(class_2338 position) {
            if (rayMode && (pos.method_10079(face.method_10153(), 3).equals(position) || pos.method_10079(face.method_10153(), 1).equals(position)))
                return class_2246.field_9987.method_9564();
            return level.method_8320(position);
        }
    }

    static boolean shouldActivate(class_1799 held, class_1937 world, class_2338 targetPos, @Nullable class_2350 facing) {
        if (held.method_7909() instanceof class_1747)
            if (world.method_8320(targetPos).method_26204() == ((class_1747) held.method_7909()).method_7711())
                return false;

        if (held.method_7909() instanceof class_1755 bucketItem) {
            class_3611 fluid = bucketItem.field_7905;
            if (fluid != class_3612.field_15906 && world.method_8316(targetPos).method_15772() == fluid)
                return false;
        }

        return held.method_7960() || facing != class_2350.field_11033 || BlockEntityBehaviour.get(
            world,
            targetPos,
            TransportedItemStackHandlerBehaviour.TYPE
        ) == null;
    }

    static void activate(DeployerPlayer player, class_243 vec, class_2338 clickedPos, class_243 extensionVector, Mode mode) {
        class_3222 serverPlayer = player.cast();
        HashMultimap<class_6880<class_1320>, class_1322> attributeModifiers = HashMultimap.create();
        class_1799 stack = serverPlayer.method_6047();
        stack.method_58695(class_9334.field_49636, class_9285.field_49326).comp_2393()
            .forEach(e -> attributeModifiers.put(e.comp_2395(), e.comp_2396()));

        serverPlayer.method_6127().method_59932(attributeModifiers);
        activateInner(player, vec, clickedPos, extensionVector, mode);
        serverPlayer.method_6127().method_59935(attributeModifiers);
    }

    private static void activateInner(DeployerPlayer player, class_243 vec, class_2338 clickedPos, class_243 extensionVector, Mode mode) {
        class_3222 serverPlayer = player.cast();
        class_243 rayOrigin = vec.method_1019(extensionVector.method_1021(3 / 2f + 1 / 64f));
        class_243 rayTarget = vec.method_1019(extensionVector.method_1021(5 / 2f - 1 / 64f));
        serverPlayer.method_5814(rayOrigin.field_1352, rayOrigin.field_1351, rayOrigin.field_1350);
        class_2338 pos = class_2338.method_49638(vec);
        class_1799 stack = serverPlayer.method_6047();
        class_1792 item = stack.method_7909();

        // Check for entities
        final class_3218 level = serverPlayer.method_51469();
        List<class_1297> entities = level.method_18467(class_1297.class, new class_238(clickedPos)).stream()
            .filter(e -> !(e instanceof AbstractContraptionEntity)).toList();
        class_1268 hand = class_1268.field_5808;
        if (!entities.isEmpty()) {
            class_1297 entity = entities.get(level.field_9229.method_43048(entities.size()));
            List<class_1799> capturedDrops = new ArrayList<>();
            boolean success = false;
            AllSynchedDatas.CAPTURE_DROPS.set(entity, Optional.of(capturedDrops));

            // Use on entity
            if (mode == Mode.USE) {
                class_1269 cancelResult = null;
                //TODO
                //                ActionResult cancelResult = CommonHooks.onInteractEntity(player, entity, hand);
                //                if (cancelResult == ActionResult.FAIL) {
                //                    entity.captureDrops(null);
                //                    return;
                //                }
                if (cancelResult == null) {
                    if (entity.method_5688(serverPlayer, hand).method_23665()) {
                        if (entity instanceof class_3988 villager) {
                            if (villager.method_8257() == serverPlayer)
                                villager.method_8259(null);
                        }
                        success = true;
                    } else if (entity instanceof class_1309 livingEntity && stack.method_7920(serverPlayer, livingEntity, hand)
                        .method_23665())
                        success = true;
                }
                if (!success && entity instanceof class_1657 playerEntity) {
                    if (stack.method_57826(class_9334.field_50075)) {
                        class_4174 foodProperties = stack.method_58694(class_9334.field_50075);
                        if (foodProperties != null && playerEntity.method_7332(foodProperties.comp_2493())) {
                            class_1799 copy = stack.method_7972();
                            serverPlayer.method_6122(hand, stack.method_7910(level, playerEntity));
                            player.setSpawnedItemEffects(copy);
                            success = true;
                        }
                    }
                    if (!success && stack.method_31573(AllItemTags.DEPLOYABLE_DRINK)) {
                        player.setSpawnedItemEffects(stack.method_7972());
                        serverPlayer.method_6122(hand, stack.method_7910(level, playerEntity));
                        success = true;
                    }
                }
            }

            // Punch entity
            if (mode == Mode.PUNCH) {
                serverPlayer.method_7350();
                serverPlayer.method_7324(entity);
                success = true;
            }

            AllSynchedDatas.CAPTURE_DROPS.set(entity, Optional.empty());
            capturedDrops.forEach(e -> serverPlayer.method_31548().method_7398(e));
            if (success)
                return;
        }

        // Shoot ray
        class_3959 rayTraceContext = new class_3959(
            rayOrigin,
            rayTarget,
            class_3960.field_17559,
            net.minecraft.class_3959.class_242.field_1348,
            serverPlayer
        );
        class_3965 result = level.method_17742(rayTraceContext);
        if (result.method_17777() != clickedPos)
            result = new class_3965(result.method_17784(), result.method_17780(), clickedPos, result.method_17781());
        class_2680 clickedState = level.method_8320(clickedPos);
        class_2350 face = result.method_17780();
        if (face == null)
            face = class_2350.method_10142(extensionVector.field_1352, extensionVector.field_1351, extensionVector.field_1350).method_10153();

        // Left click
        if (mode == Mode.PUNCH) {
            if (!level.method_8505(serverPlayer, clickedPos))
                return;
            if (clickedState.method_26218(level, clickedPos).method_1110()) {
                player.setBlockBreakingProgress(null);
                return;
            }
            //TODO
            //            LeftClickBlock event = CommonHooks.onLeftClickBlock(player, clickedPos, face, ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK);
            //            if (event.isCanceled())
            //                return;
            if (BlockHelper.extinguishFire(level, serverPlayer, clickedPos, face))
                return;
            //TODO
            //            if (event.getUseBlock() != TriState.FALSE)
            //                clickedState.attack(level, clickedPos, player);
            if (stack.method_7960())
                return;

            float progress = clickedState.method_26165(serverPlayer, level, clickedPos) * 16;
            float before = 0;
            Pair<class_2338, Float> blockBreakingProgress = player.getBlockBreakingProgress();
            if (blockBreakingProgress != null)
                before = blockBreakingProgress.getValue();
            progress += before;
            level.method_8396(null, clickedPos, clickedState.method_26231().method_10596(), class_3419.field_15254, .25f, 1);

            if (progress >= 1) {
                tryHarvestBlock(player, player.getInteractionManager(), clickedPos);
                level.method_8517(serverPlayer.method_5628(), clickedPos, -1);
                player.setBlockBreakingProgress(null);
                return;
            }
            if (progress <= 0) {
                player.setBlockBreakingProgress(null);
                return;
            }

            if ((int) (before * 10) != (int) (progress * 10))
                level.method_8517(serverPlayer.method_5628(), clickedPos, (int) (progress * 10));
            player.setBlockBreakingProgress(Pair.of(clickedPos, progress));
            return;
        }

        // Right click
        class_1838 itemusecontext = new class_1838(serverPlayer, hand, result);
        //TODO
        //        TriState useBlock = TriState.DEFAULT;
        //        TriState useItem = TriState.DEFAULT;
        //        if (!clickedState.getShape(level, clickedPos).isEmpty()) {
        //            RightClickBlock event = CommonHooks.onRightClickBlock(player, hand, clickedPos, result);
        //            useBlock = event.getUseBlock();
        //            useItem = event.getUseItem();
        //        }

        // Item has custom active use
        //        if (useItem != TriState.FALSE) {
        //            ActionResult actionresult = stack.onItemUseFirst(itemusecontext);
        //            if (actionresult != ActionResult.PASS)
        //                return;
        //        }

        boolean holdingSomething = !serverPlayer.method_6047().method_7960();
        boolean flag1 = !(serverPlayer.method_5715() && holdingSomething) || !serverPlayer.method_6047().method_7960();

        // Use on block
        if (flag1 && safeOnUse(clickedState, level, clickedPos, player, hand, result).method_23665())
            return;
        if (stack.method_7960())
            return;
        if (item instanceof CartAssemblerBlockItem && clickedState.method_26166(new class_1750(itemusecontext)))
            return;

        // Reposition fire placement for convenience
        if (item == class_1802.field_8884) {
            class_2350 newFace = result.method_17780();
            class_2338 newPos = result.method_17777();
            if (!class_4770.method_30032(level, clickedPos, newFace))
                newFace = class_2350.field_11036;
            if (clickedState.method_26215())
                newPos = newPos.method_10093(face.method_10153());
            result = new class_3965(result.method_17784(), newFace, newPos, result.method_17781());
            itemusecontext = new class_1838(serverPlayer, hand, result);
        }

        // 'Inert' item use behaviour & block placement
        class_1269 onItemUse = stack.method_7981(itemusecontext);
        if (onItemUse.method_23665()) {
            if (item instanceof class_1747 bi && (bi.method_7711() instanceof class_2241 || bi.method_7711() instanceof ITrackBlock))
                player.setPlacedTracks(true);
            return;
        }

        if (item == class_1802.field_8634)
            return;
        if (item.method_40131().method_40220(AllItemTags.DEPLOYABLE_DRINK))
            return;

        // buckets create their own ray, We use a fake wall to contain the active area
        class_1937 itemUseWorld = level;
        if (item instanceof class_1755 || item instanceof SandPaperItem)
            itemUseWorld = new ItemUseWorld(level, face, pos);

        class_1269 onItemRightClick = item.method_7836(itemUseWorld, serverPlayer, hand);

        if (onItemRightClick.method_23665() && item instanceof class_1785 bucketItem)
            bucketItem.method_7728(serverPlayer, level, stack, clickedPos);

        if (onItemRightClick instanceof class_1269.class_9860 success) {
            class_1799 resultStack = success.method_61396();
            if (resultStack != null && resultStack != stack || resultStack.method_7947() != stack.method_7947() || resultStack.method_7935(serverPlayer) > 0 || resultStack.method_7919() != stack.method_7919()) {
                serverPlayer.method_6122(hand, resultStack);
            }
        }

        if (stack.method_7909() instanceof SandPaperItem) {
            SandPaperItemComponent component = stack.method_58694(AllDataComponents.SAND_PAPER_POLISHING);
            if (component != null) {
                player.setSpawnedItemEffects(component.item());
                AllSoundEvents.SANDING_SHORT.playOnServer(level, pos, .25f, 1f);
            }
        }

        if (!serverPlayer.method_6030().method_7960())
            serverPlayer.method_6122(hand, stack.method_7910(level, serverPlayer));

        serverPlayer.method_6021();
    }

    public static boolean tryHarvestBlock(DeployerPlayer player, class_3225 interactionManager, class_2338 pos) {
        // <> PlayerInteractionManager#tryHarvestBlock

        class_3222 serverPlayer = player.cast();
        class_3218 world = serverPlayer.method_51469();
        class_2680 blockstate = world.method_8320(pos);
        class_1934 gameType = interactionManager.method_14257();

        //TODO
        //        if (CommonHooks.fireBlockBreak(world, gameType, player, pos, blockstate).isCanceled())
        //            return false;

        class_2586 blockEntity = world.method_8321(pos);
        if (serverPlayer.method_21701(world, pos, gameType))
            return false;

        class_1799 prevHeldItem = serverPlayer.method_6047();
        class_1799 heldItem = prevHeldItem.method_7972();

        boolean canHarvest = serverPlayer.method_7305(blockstate) && serverPlayer.method_7294();
        prevHeldItem.method_7952(world, blockstate, pos, player.cast());

        class_2338 posUp = pos.method_10084();
        class_2680 stateUp = world.method_8320(posUp);
        if (blockstate.method_26204() instanceof class_2320 && blockstate.method_11654(class_2320.field_10929) == class_2756.field_12607 && stateUp.method_26204() == blockstate.method_26204() && stateUp.method_11654(
            class_2320.field_10929) == class_2756.field_12609) {
            // hack to prevent DoublePlantBlock from dropping a duplicate item
            world.method_8652(
                pos,
                class_2246.field_10124.method_9564(),
                net.minecraft.class_2248.field_31036 | net.minecraft.class_2248.field_31032
            );
            world.method_8652(
                posUp,
                class_2246.field_10124.method_9564(),
                net.minecraft.class_2248.field_31036 | net.minecraft.class_2248.field_31032
            );
        } else {
            blockstate.method_26204().method_9576(world, pos, blockstate, player.cast());
            if (!world.method_8652(pos, world.method_8316(pos).method_15772().method_15785().method_15759(), world.method_8608() ? 11 : 3))
                return true;
        }

        blockstate.method_26204().method_9585(world, pos, blockstate);
        if (!canHarvest)
            return true;

        net.minecraft.class_2248.method_9609(blockstate, world, pos, blockEntity, player.cast(), prevHeldItem)
            .forEach(item -> serverPlayer.method_31548().method_7398(item));
        blockstate.method_26180(world, pos, prevHeldItem, true);
        return true;
    }

    public static class_1269 safeOnUse(
        class_2680 state,
        class_1937 world,
        class_2338 pos,
        DeployerPlayer player,
        class_1268 hand,
        class_3965 ray
    ) {
        List<class_1542> drops = new ArrayList<>(4);
        CAPTURED_BLOCK_DROPS.put(pos, drops);
        try {
            class_1269 result = BlockHelper.invokeUse(state, world, player.cast(), hand, ray);
            for (class_1542 itemEntity : drops)
                player.cast().method_31548().method_7398(itemEntity.method_6983());
            return result;
        } finally {
            CAPTURED_BLOCK_DROPS.remove(pos);
        }
    }

}
